package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ContractFinishSettleEntity;
import com.ejianc.business.income.service.IContractFinishSettleService;
import com.ejianc.business.income.service.IContractService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("contractFinishSettle") 
public class ContractFinishSettleBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IContractService contractService;

	@Autowired
	private IContractFinishSettleService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		ContractFinishSettleEntity entity = service.selectById(billId);
		this.writeBackContractFinsishFlag(entity, Boolean.FALSE);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ContractFinishSettleEntity entity = service.selectById(billId);
		this.writeBackContractFinsishFlag(entity, Boolean.TRUE);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ContractFinishSettleEntity entity = service.selectById(billId);
		this.writeBackContractFinsishFlag(entity, Boolean.FALSE);
		return CommonResponse.success();
	}

	/**
	 * 回写合同完工状态
	 *
	 * @param
	 * @param
	 */
	private void writeBackContractFinsishFlag(ContractFinishSettleEntity contractFinishSettleEntity, Boolean finishFlag) {
		LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		//根据完工状态回写合同状态，合同状态3已封账，2履约中
		updateWrapper.set(ContractEntity::getContractStatus, finishFlag ? "3" : "2");
		updateWrapper.eq(ContractEntity::getId, contractFinishSettleEntity.getContractId());
		ContractEntity contractEntity = contractService.getById(contractFinishSettleEntity.getContractId());
		contractService.update(contractEntity, updateWrapper, false);
	}

}
