/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.bean.IncomeCostCarryoverEntity;
import com.ejianc.business.income.service.IIncomeCostCarryoverService;
import com.ejianc.business.income.utils.NCUtil;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="incomeCostCarryover")
public class IncomeCostCarryoverBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncomeCostCarryoverService service;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        IncomeCostCarryoverEntity costCarryoverEntity = (IncomeCostCarryoverEntity)((Object)this.service.selectById(billId));
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(costCarryoverEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())) {
            this.pushToNC(costCarryoverEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        IncomeCostCarryoverEntity costCarryoverEntity = (IncomeCostCarryoverEntity)((Object)this.service.selectById(billId));
        if (StringUtils.isNotEmpty((String)costCarryoverEntity.getSourceId())) {
            String[] split;
            for (String sourceId : split = costCarryoverEntity.getSourceId().split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deletearbill");
                json.put("pk_bill", (Object)sourceId);
                this.ncUtil.postByJson(json.toJSONString());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(IncomeCostCarryoverEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.service.update((Wrapper)wrapper);
        }
        return CommonResponse.success();
    }

    private void pushToNC(IncomeCostCarryoverEntity entity) {
        ArBillVO vo = this.transferToNCVO(entity);
        String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(IncomeCostCarryoverEntity::getSourceId, (Object)sourceId);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.service.update((Wrapper)wrapper);
    }

    private ArBillVO transferToNCVO(IncomeCostCarryoverEntity entity) {
        this.logger.info("----\u5e94\u6536\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = this.ncUtil.queryCustomerById(entity.getCustomerId());
        ArBillVO vo = new ArBillVO();
        vo.setBusitype("arbill");
        vo.setTradetype("F0-Cxx-003");
        vo.setDef1(Boolean.valueOf(false));
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setDef19(entity.getBillCode());
        vo.setPk_org(orgVO.getCode());
        vo.setPk_customer(String.valueOf(entity.getCustomerId()));
        vo.setDef6(Boolean.valueOf(customerVO.getInsideOrgId() != null));
        ArrayList<ArBillDetailVO> detailVOS = new ArrayList<ArBillDetailVO>();
        ArBillDetailVO detailVO = new ArBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getTheCostMny());
        detailVO.setTotalmny(entity.getTheIncomeMny());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }
}

