/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.bean.ProductionDetailEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.mapper.ProductionMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionClaimService;
import com.ejianc.business.income.service.IProductionDetailService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ProductionClaimVo;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.business.income.vo.comparator.ProductionDetailComparatorVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="ProductionService")
public class ProductionServiceImpl
extends BaseServiceImpl<ProductionMapper, ProductionEntity>
implements IProductionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PRODUCTION_BILL_CODE = "INCOME_PRODUCTION";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private ProductionMapper productionMapper;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionClaimService productionClaimService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IClaimService claimService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<ProductionVo> saveOrUpdate(ProductionVo productionVo) {
        List entities;
        LambdaQueryWrapper lambda;
        ContractEntity contractEntity;
        block41: {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(productionVo.getContractId()));
            if (contractEntity != null && contractEntity.getIsFinish() == 1) {
                return CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u505a\u7ae3\u5de5\u7ed3\u7b97\uff0c\u4e0d\u80fd\u505a\u4ea7\u503c\u7edf\u8ba1\uff01");
            }
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            try {
                CommonResponse param;
                List claimVos;
                locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(productionVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (productionVo.getContractVersion() != null && productionVo.getContractVersion() != 0) {
                    if (locked) {
                        Integer conVersion;
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (version != (conVersion = productionVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u65bd\u5de5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                    } else {
                        CommonResponse version = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        return version;
                    }
                }
                if ((claimVos = productionVo.getClaimList()) == null || claimVos.size() <= 0) break block41;
                HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
                for (ProductionClaimVo claimVo : claimVos) {
                    if (claimVo.getClaimVersion() == null || claimVo.getClaimVersion() == 0) continue;
                    versionMap.put(claimVo.getClaimId(), claimVo.getClaimVersion());
                }
                if (versionMap == null || versionMap.size() <= 0) break block41;
                if (locked) {
                    param = new QueryParam();
                    param.getParams().put("id", new Parameter("in", new ArrayList(versionMap.keySet())));
                    List claimEntities = this.claimService.queryList((QueryParam)param, false);
                    for (ClaimEntity claimEntity : claimEntities) {
                        if ((claimEntity.getVersion() == null ? 0 : claimEntity.getVersion()) == (Integer)versionMap.get(claimEntity.getId())) continue;
                        CommonResponse commonResponse = CommonResponse.error((String)"\u53d8\u66f4\u7b7e\u8bc1\u6d3d\u5546\u7d22\u8d54\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        return commonResponse;
                    }
                    break block41;
                }
                param = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return param;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(productionVo.getContractId()), (String)"saveOrUpdate");
                }
                jedis.close();
            }
        }
        LambdaQueryWrapper lamb = new LambdaQueryWrapper();
        lamb.eq(ProductionEntity::getContractId, (Object)productionVo.getContractId());
        lamb.ne(productionVo.getId() != null && productionVo.getId() > 0L, BaseEntity::getId, (Object)productionVo.getId());
        lamb.last("and date_format(production_date,'%Y-%m')='" + DateUtil.getYearAndMonth((Date)productionVo.getProductionDate()) + "'");
        List list = super.list((Wrapper)lamb);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u5408\u540c\u5728\u8be5\u6708\u4efd\u5df2\u5236\u5b9a\u4ea7\u503c\u7edf\u8ba1\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
        }
        LambdaQueryWrapper lamb2 = new LambdaQueryWrapper();
        lamb2.eq(ProductionEntity::getContractId, (Object)productionVo.getContractId());
        lamb2.ne(productionVo.getId() != null && productionVo.getId() > 0L, BaseEntity::getId, (Object)productionVo.getId());
        lamb2.last("and date_format(production_date,'%Y-%m')>'" + DateUtil.getYearAndMonth((Date)productionVo.getProductionDate()) + "'");
        List list2 = super.list((Wrapper)lamb2);
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            throw new BusinessException("\u8be5\u5408\u540c\u5b58\u5728\u6bd4\u5f53\u524d\u6708\u4efd\u66f4\u665a\u7684\u4ea7\u503c\u7edf\u8ba1\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
        }
        Date signDate = contractEntity.getSignDate();
        if (null != signDate && productionVo.getProductionDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u4ea7\u503c\u65f6\u95f4\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u65bd\u5de5\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ProductionEntity entity = null;
        String operateType = null;
        if (productionVo.getId() != null && productionVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)productionVo.getBillCode())) {
                productionVo.setBillCode(null);
            }
            entity = (ProductionEntity)((Object)BeanMapper.map((Object)productionVo, ProductionEntity.class));
            operateType = "edit";
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)productionVo.getContractId()));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(0);
            billStatus.add(2);
            billStatus.add(5);
            queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
            List entities2 = super.queryList(queryParam, false);
            if (null != entities2 && entities2.size() > 0) {
                throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u4ea7\u503c\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PRODUCTION_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            productionVo.setBillCode((String)billCode.getData());
            entity = (ProductionEntity)((Object)BeanMapper.map((Object)productionVo, ProductionEntity.class));
            operateType = "add";
        }
        if (productionVo.getId() != null && productionVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ProductionEntity::getBillCode, (Object)productionVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)productionVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ProductionEntity::getBillCode, (Object)productionVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity);
        List detailsVos = productionVo.getCheckList();
        ArrayList<ProductionDetailEntity> saveOrUpldates = new ArrayList<ProductionDetailEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (Object detailsVo : detailsVos) {
            ProductionDetailEntity detailslist;
            if ("add".equals(detailsVo.getRowState())) {
                detailslist = (ProductionDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ProductionDetailEntity.class));
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
                continue;
            }
            if ("edit".equals(detailsVo.getRowState())) {
                detailslist = (ProductionDetailEntity)((Object)BeanMapper.map((Object)detailsVo, ProductionDetailEntity.class));
                saveOrUpldates.add(detailslist);
                continue;
            }
            if (!"del".equals(detailsVo.getRowState())) continue;
            deleteIds.add(detailsVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.productionDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ProductionDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProductionDetailEntity cdEntity : saveOrUpldates) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.productionDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.productionDetailService.removeByIds(deleteIds, false);
        }
        List clauseVos = productionVo.getClaimList();
        ArrayList<ProductionClaimEntity> clauseList = new ArrayList<ProductionClaimEntity>();
        ArrayList<Long> deleteClauseIds = new ArrayList<Long>();
        for (ProductionClaimVo clauseVo : clauseVos) {
            ProductionClaimEntity detailslist;
            if ("add".equals(clauseVo.getRowState())) {
                detailslist = (ProductionClaimEntity)((Object)BeanMapper.map((Object)clauseVo, ProductionClaimEntity.class));
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                clauseList.add(detailslist);
                continue;
            }
            if ("edit".equals(clauseVo.getRowState())) {
                detailslist = (ProductionClaimEntity)((Object)BeanMapper.map((Object)clauseVo, ProductionClaimEntity.class));
                clauseList.add(detailslist);
                continue;
            }
            if (!"del".equals(clauseVo.getRowState())) continue;
            deleteClauseIds.add(clauseVo.getId());
        }
        if (clauseList.size() > 0) {
            this.productionClaimService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            this.productionClaimService.removeByIds(deleteClauseIds, false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public ProductionVo queryDetail(Long id) {
        ProductionEntity entity = (ProductionEntity)((Object)this.productionMapper.selectById(id));
        if (entity != null) {
            ProductionVo vo = (ProductionVo)BeanMapper.map((Object)((Object)entity), ProductionVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("productionId", new Parameter("eq", (Object)vo.getId()));
            List details = this.productionDetailService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (ProductionDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)details, ProductionDetailVo.class);
                Collections.sort(resultMapList, new ProductionDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            QueryParam parm = new QueryParam();
            parm.getParams().put("productionId", new Parameter("eq", (Object)vo.getId()));
            List productionClaimEntities = this.productionClaimService.queryList(parm, false);
            vo.setClaimList(BeanMapper.mapList((Iterable)productionClaimEntities, ProductionClaimVo.class));
            return vo;
        }
        return null;
    }

    @Override
    public void deleteProduction(List<ProductionVo> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ProductionHistoryVo queryProductionHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List prodEntities = this.productionMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object[])new String[]{"production_date", "create_time"}));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumClaimMny = contractEntity.getSumClaimMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimMny();
        ProductionHistoryVo vo = new ProductionHistoryVo();
        vo.setContractId(id);
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumProductionTaxMny(contractEntity.getSumProductionTaxMny());
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        BigDecimal add = contractTaxMny;
        if (add.compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumImageProgress(BigDecimal.ZERO);
        } else {
            vo.setSumImageProgress(sumProductionTaxMny.divide(add, 8, 4).multiply(new BigDecimal(100)));
        }
        vo.setProductionRecord(BeanMapper.mapList((Iterable)prodEntities, ProductionVo.class));
        return vo;
    }

    @Override
    public List<ProductionDetailVo> detailRef(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("productionId", new Parameter("eq", (Object)id));
        List details = this.productionDetailService.queryList(queryParam, false);
        if (details != null && details.size() > 0) {
            for (ProductionDetailEntity cdEntity : details) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)details, ProductionDetailVo.class);
            Collections.sort(resultMapList, new ProductionDetailComparatorVo());
            return TreeNodeBUtil.buildTree((List)resultMapList);
        }
        return null;
    }

    @Override
    public List<ProductionVo> queryTotalFinishTaxMny(List<Long> orgIds, Integer yearFlag) {
        return this.productionMapper.queryTotalFinishTaxMny(orgIds, yearFlag);
    }
}

