package com.ejianc.business.income.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * <p>
 * 施工合同变更表
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_change")
public class ChangeEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private Integer contractStatus;

    /**
     * 发包单位
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 承包单位
     */
    @TableField("contractor_unit")
    private Long contractorUnit;

    /**
     * 经营方式：1-自营，2-联营
     */
    @TableField("type")
    private Integer type;

    /**
     * 管理费比例,联营时展示，自营时不展示
     */
    @TableField("manage_charge_rate")
    private BigDecimal manageChargeRate;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同计价形式，档案
     */
    @TableField("contract_valuation_type")
    private Long contractValuationType;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 开工日期
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 竣工日期
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 总工期
     */
    @TableField("term")
    private Integer term;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 初始版本金额（含税）
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更（编制）时间
     */
    @TableField("change_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeTime;

    /**
     * 生效时间
     */
    @TableField("used_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date usedTime;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 发包单位名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 承包单位名称
     */
    @TableField("contractor_unit_name")
    private String contractorUnitName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 变更前合同名称
     */
    @TableField("before_contract_name")
    private String beforeContractName;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 变更原因
     */
    @TableField("change_reason")
    private String changeReason;

    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)

    @TableField(exist = false)
    @SubEntity(serviceName = "ChangeDetailService", pidName = "changeId")
    private List<ChangeDetailEntity> checkList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "ChangeClauseService", pidName = "changeId")
    private List<ChangeClauseEntity> clauseList = new ArrayList<>();


    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public List<ChangeDetailEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<ChangeDetailEntity> checkList) {
        this.checkList = checkList;
    }

    public List<ChangeClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ChangeClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getContractorUnit() {
        return contractorUnit;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getManageChargeRate() {
        return manageChargeRate;
    }

    public void setManageChargeRate(BigDecimal manageChargeRate) {
        this.manageChargeRate = manageChargeRate;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public Date getUsedTime() {
        return usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    @Override
    public String toString() {
        return "ChangeEntity{" +
                "contractId=" + contractId +
                ", projectId=" + projectId +
                ", orgId=" + orgId +
                ", contractName=" + contractName +
                ", billCode=" + billCode +
                ", contractStatus=" + contractStatus +
                ", customerId=" + customerId +
                ", contractorUnit=" + contractorUnit +
                ", type=" + type +
                ", manageChargeRate=" + manageChargeRate +
                ", taxRate=" + taxRate +
                ", contractValuationType=" + contractValuationType +
                ", signDate=" + signDate +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", term=" + term +
                ", employeeId=" + employeeId +
                ", memo=" + memo +
                ", contractTaxMny=" + contractTaxMny +
                ", taxMny=" + taxMny +
                ", contractMny=" + contractMny +
                ", baseTaxMoney=" + baseTaxMoney +
                ", baseMoney=" + baseMoney +
                ", beforeChangeTaxMny=" + beforeChangeTaxMny +
                ", beforeChangeMny=" + beforeChangeMny +
                ", changeVersion=" + changeVersion +
                ", changeTime=" + changeTime +
                ", usedTime=" + usedTime +
                ", billState=" + billState +
                ", projectName=" + projectName +
                ", customerName=" + customerName +
                ", contractorUnitName=" + contractorUnitName +
                ", employeeName=" + employeeName +
                ", beforeContractName=" + beforeContractName +
                ", orgName=" + orgName +
                "}";
    }
}
