package com.ejianc.business.income.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工程定案实体
 * 
 * @author generator
 * 
 */
public class FinalizedVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long settleReportId; // 结算报审id
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long contractId; // 合同
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private java.math.BigDecimal contractMny; // 合同总造价(不含税)
    private java.math.BigDecimal contractTaxMny; // 合同总造价(含税)
    private Long contractValuationType; // 合同计价形式
    private java.math.BigDecimal sumProductionMny; // 累计产值(无税)
    private java.math.BigDecimal sumProductionTaxMny; // 累计产值
    private java.math.BigDecimal sumCostMny; // 累计成本(无税)
    private java.math.BigDecimal sumCostTaxMny; // 累计成本
    private java.math.BigDecimal sumReceiptMny; // 累计收款金额(无税)
    private java.math.BigDecimal sumReceiptTaxMny; // 累计收款金额
    private String finalStage; // 定案阶段：1-一审，2-二审，3-三审，4-终审
    private java.math.BigDecimal reportSettleMny; // 报审金额
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private java.util.Date reportDate; // 报审日期
    private java.math.BigDecimal checkMny; // 审定金额
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private java.util.Date checkDate; // 审定日期
    private java.math.BigDecimal materialMny; // 审减金额
    private java.math.BigDecimal reviewSubtractRate; // 审减率
    private java.math.BigDecimal reviewSubtractMny; // 审减金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 结算报审id
     */
    public Long getSettleReportId() {
        return settleReportId;
    }

    /**
     * 结算报审id
     */
    public void setSettleReportId(Long settleReportId) {
        this.settleReportId = settleReportId;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 合同
     */

    @ReferSerialTransfer(referCode="income-contract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 父级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同总造价(不含税)
     */
    public java.math.BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同总造价(不含税)
     */
    public void setContractMny(java.math.BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同总造价(含税)
     */
    public java.math.BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同总造价(含税)
     */
    public void setContractTaxMny(java.math.BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同计价形式
     */
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式
     */
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 累计产值(无税)
     */
    public java.math.BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    /**
     * 累计产值(无税)
     */
    public void setSumProductionMny(java.math.BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    /**
     * 累计产值
     */
    public java.math.BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    /**
     * 累计产值
     */
    public void setSumProductionTaxMny(java.math.BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    /**
     * 累计成本(无税)
     */
    public java.math.BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    /**
     * 累计成本(无税)
     */
    public void setSumCostMny(java.math.BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    /**
     * 累计成本
     */
    public java.math.BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    /**
     * 累计成本
     */
    public void setSumCostTaxMny(java.math.BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    /**
     * 累计收款金额(无税)
     */
    public java.math.BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    /**
     * 累计收款金额(无税)
     */
    public void setSumReceiptMny(java.math.BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    /**
     * 累计收款金额
     */
    public java.math.BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    /**
     * 累计收款金额
     */
    public void setSumReceiptTaxMny(java.math.BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    /**
     * 定案阶段：1-一审，2-二审，3-三审，4-终审
     */
    public String getFinalStage() {
        return finalStage;
    }

    /**
     * 定案阶段：1-一审，2-二审，3-三审，4-终审
     */
    public void setFinalStage(String finalStage) {
        this.finalStage = finalStage;
    }
    /**
     * 报审金额
     */
    public java.math.BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    /**
     * 报审金额
     */
    public void setReportSettleMny(java.math.BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    /**
     * 报审日期
     */
    public java.util.Date getReportDate() {
        return reportDate;
    }

    /**
     * 报审日期
     */
    public void setReportDate(java.util.Date reportDate) {
        this.reportDate = reportDate;
    }
    /**
     * 审定金额
     */
    public java.math.BigDecimal getCheckMny() {
        return checkMny;
    }

    /**
     * 审定金额
     */
    public void setCheckMny(java.math.BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    /**
     * 审定日期
     */
    public java.util.Date getCheckDate() {
        return checkDate;
    }

    /**
     * 审定日期
     */
    public void setCheckDate(java.util.Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 审减金额
     */
    public java.math.BigDecimal getMaterialMny() {
        return materialMny;
    }

    /**
     * 审减金额
     */
    public void setMaterialMny(java.math.BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    /**
     * 审减率
     */
    public java.math.BigDecimal getReviewSubtractRate() {
        return reviewSubtractRate;
    }

    /**
     * 审减率
     */
    public void setReviewSubtractRate(java.math.BigDecimal reviewSubtractRate) {
        this.reviewSubtractRate = reviewSubtractRate;
    }
    /**
     * 审减金额
     */
    public java.math.BigDecimal getReviewSubtractMny() {
        return reviewSubtractMny;
    }

    /**
     * 审减金额
     */
    public void setReviewSubtractMny(java.math.BigDecimal reviewSubtractMny) {
        this.reviewSubtractMny = reviewSubtractMny;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
