package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.income.history.ClaimHistoryVo;
import com.ejianc.business.income.vo.ClaimVo;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * <p>
 * 签证洽商索赔 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@RestController
@RequestMapping("/claim")
public class ClaimController {
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IOrgApi orgApi;

    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ClaimEntity>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("changeSummary");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success("查询列表数据成功！", claimService.queryPage(param, false));
    }

    /**
     * 新增或编辑
     *
     * @param claimVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ClaimVo> saveOrUpdate(@RequestBody ClaimVo claimVo) {
        CommonResponse<ClaimVo> response = claimService.saveOrUpdate(claimVo);
        return response;
    }

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ClaimVo> queryDetail(@RequestParam Long id) {
        ClaimVo vo = claimService.queryDetail(id);
        return CommonResponse.success(vo);
    }

    /**
     * 删除
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimVo> vos) {
        claimService.deleteClaim(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 签证洽商索赔参照
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ClaimEntity>> queryRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                       @RequestParam(defaultValue = "10") Integer pageSize,
                                                       @RequestParam(value = "searchText", required = false) String searchText,
                                                       @RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("changeSummary");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("employeeName");
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
            }
        }
        queryParam.getOrderMap().put("occurDate", "desc");
        queryParam.getOrderMap().put("createTime", "desc");
        Page<ClaimEntity> page = new Page<>((long) queryParam.getPageIndex(), (long) queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("type")) {
                if (conditionMap.get("type").equals("production")) {
                    wrapper.apply("reply_tax_mny > sum_production_tax_mny");
                }
                if (conditionMap.get("type").equals("quote")) {
                    wrapper.apply("reply_tax_mny > sum_quote_tax_mny");
                }
            }
        }
        IPage iPage = claimService.selectPage(page, wrapper);
        List<ClaimEntity> records = iPage.getRecords();
        if (null != records && records.size() > 0) {
            for (ClaimEntity ce : records) {
                if (null != ce.getChangeType()) {
                    if (1 == ce.getChangeType()) {
                        ce.setChangeTypeName("现场签证");
                    } else if (2 == ce.getChangeType()) {
                        ce.setChangeTypeName("变更洽商");
                    } else if (3 == ce.getChangeType()) {
                        ce.setChangeTypeName("索赔");
                    }
                } else {
                    ce.setChangeTypeName("");
                }
            }
            iPage.setRecords(records);
        }
        return CommonResponse.success("查询列表数据成功！", iPage);
    }

    /**
     * 签证变更索赔历史记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryClaimHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ClaimHistoryVo> queryClaimHistory(@RequestParam Long id) {
        ClaimHistoryVo vo = claimService.queryClaimHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("changeSummary");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<ClaimEntity> pageData = claimService.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<ClaimVo> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), ClaimVo.class);
            list.forEach(vo -> {
                if (null != vo.getChangeType()) {
                    if (1 == vo.getChangeType()) {
                        vo.setChangeTypeName("现场签证");
                    } else if (2 == vo.getChangeType()) {
                        vo.setChangeTypeName("变更洽商");
                    } else if (3 == vo.getChangeType()) {
                        vo.setChangeTypeName("索赔");
                    }
                } else {
                    vo.setChangeTypeName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });

        }
        beans.put("records", list);
        ExcelExport.getInstance().export("claim-export.xlsx", beans, response);
    }

    /**
     * @Author yqls
     * @Date 2021/8/11
     * @Description confirm 批量支付
     * @param vo
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/confirm", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> confirm(@RequestBody ClaimVo vo) {
        String msg = claimService.confirm(vo);
        return CommonResponse.success("确认成功！");
    }

}
