package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.business.income.vo.ContractDetailVo;
import com.ejianc.business.income.service.IContractDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@RestController
@RequestMapping("/contract/detail")
public class ContractDetailController {
    @Autowired
    private IContractDetailService contractDetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contract-detail-import.xlsx", "合同清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return contractDetailService.excelImport(request,response);
    }

    @RequestMapping(value = "/detailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractDetailVo>> detailRef(@RequestParam(value = "contractId")Long contractId) {
        return CommonResponse.success("查询清单参照成功！", contractDetailService.detailRef(contractId));
    }
}

