package com.ejianc.business.income.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.income.enums.FinalStageEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.income.bean.FinalizedEntity;
import com.ejianc.business.income.service.IFinalizedService;
import com.ejianc.business.income.vo.FinalizedVO;

/**
 * 工程定案实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("finalized")
public class FinalizedController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IFinalizedService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveorUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * 根据项目id、合同id查询工程定案单数据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/validateFinalStage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestParam(required = false) Long projectId, @RequestParam Long contractId
            , String finalStage, @RequestParam(required = false) Long id) {
        return CommonResponse.success("查询数据成功！", service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    /**
     * 根据 定安阶段 查询数据 final_stage
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalStage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> queryFinalStage(@RequestParam(required = false) Long projectId, @RequestParam Long contractId, String finalStage, @RequestParam(required = false) Long id) {

        return CommonResponse.success("查询数据成功！", service.validateFinalStage(projectId, contractId, finalStage, id));
    }
    /**
     * 根据项目id、合同id查询工程定案单数据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalized", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryFinalized(@RequestParam(required = false) Long projectId, @RequestParam Long contractId) {
        LambdaQueryWrapper<FinalizedEntity>query=new LambdaQueryWrapper<>();
        query.eq(FinalizedEntity::getProjectId,projectId);
        query.eq(FinalizedEntity::getContractId,contractId);
        query.eq(FinalizedEntity::getFinalStage,1);
        query.in(FinalizedEntity::getBillState,1,3);
        query.eq(FinalizedEntity::getDr,0);
        List<FinalizedEntity> entities = service.list(query);
        BigDecimal settleMny = new BigDecimal(0);
        //如果是终审查询一审二审三审数据取一审报审金额
        if(ListUtil.isNotEmpty(entities)){
            for(FinalizedEntity entity:entities){
                if(Objects.equals(entity.getFinalStage(), FinalStageEnum.一审.getCode())){
                    settleMny = entity.getReportSettleMny();
                }
            }
        }
        return CommonResponse.success("查询数据成功！", settleMny);
    }
    /**
     * 根据项目id、合同id查询工程定案单数据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalizedList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestParam(required = false) Long projectId, @RequestParam Long contractId
            , @RequestParam(required = false) Long id) {
        return CommonResponse.success("查询数据成功！", service.queryFinalizedList(projectId, contractId, id));
    }
    /**
     * 根据合同项目查询是否有终审单据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinal", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<FinalizedEntity>> queryFinal(@RequestParam(required = false) Long projectId, @RequestParam Long contractId) {

        return CommonResponse.success("查询数据成功！", service.queryFinalized(projectId,contractId));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
    	FinalizedEntity entity = service.selectById(id);
    	FinalizedVO vo = BeanMapper.map(entity, FinalizedVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        service.removeByIds(vos.stream().map(FinalizedVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FinalizedEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<FinalizedVO> voList = BeanMapper.mapList(list, FinalizedVO.class);
        for (FinalizedVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.一审.getCode())) {
                vo.setFinalStageName("一审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.二审.getCode())) {
                vo.setFinalStageName("二审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.三审.getCode())) {
                vo.setFinalStageName("三审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.终审.getCode())) {
                vo.setFinalStageName("终审");
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFinalizedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
