package com.ejianc.business.income.controller.api;

import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.service.*;
import com.ejianc.business.income.vo.ProductionPlanVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;

@RestController
@RequestMapping("/api/productionPlan/")
public class ProductionPlanApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProductionPlanService service;


    /**
     * 根据合同主键和计划日期查询产值计划
     * @param contractId
     * @param planMonth
     * @return
     */
    @RequestMapping(value = "queryProductionPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductionPlanVO> queryProductionPlan(@RequestParam(value = "contractId") Long contractId
            , @RequestParam(value = "planMonth") String planMonth) {

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("planMonth", new Parameter(QueryParam.EQ, planMonth));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 已生效

        List<ProductionPlanEntity> entities = service.queryList(queryParam, false);

        if (ListUtil.isEmpty(entities)) {
            return CommonResponse.success("查询产值计划成功！", new ProductionPlanVO());
        }

        List<ProductionPlanVO> list = BeanMapper.mapList(entities, ProductionPlanVO.class);
        return CommonResponse.success("查询产值计划成功！", list.get(0));
    }

}
