package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("claim")
public class ClaimBpmService implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //回写主表
        ClaimEntity claimEntity = claimService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(claimEntity.getContractId());
        // 审核通过金额
        BigDecimal replyMny = claimEntity.getReplyMny() == null ? BigDecimal.ZERO : claimEntity.getReplyMny();
        //合同累计审核通过金额
        BigDecimal sumClaimMny = contractEntity.getSumClaimMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimMny();
        //累加
        contractEntity.setSumClaimMny(sumClaimMny.add(replyMny));

        // 审核通过金额
        BigDecimal replyTaxMny = claimEntity.getReplyTaxMny() == null ? BigDecimal.ZERO : claimEntity.getReplyTaxMny();
        //合同累计审核通过金额
        BigDecimal sumClaimTaxMny = contractEntity.getSumClaimTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimTaxMny();
        //累加
        contractEntity.setSumClaimTaxMny(sumClaimTaxMny.add(replyTaxMny));

        contractService.updateById(contractEntity);

        return CommonResponse.success();
    }
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
}
