package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.income.enums.FinalStageEnum;
import com.ejianc.business.income.vo.FinalizedVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.income.mapper.FinalizedMapper;
import com.ejianc.business.income.bean.FinalizedEntity;
import com.ejianc.business.income.service.IFinalizedService;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 工程定案实体
 * 
 * @author generator
 * 
 */
@Service("finalizedService")
public class FinalizedServiceImpl extends BaseServiceImpl<FinalizedMapper, FinalizedEntity> implements IFinalizedService{

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "INCOME_FINALIZED";//此处需要根据实际修改

    @Override
    public FinalizedVO saveOrUpdate(FinalizedVO saveOrUpdateVO) {
        FinalizedVO finalizedVO = null;

        FinalizedEntity entity = BeanMapper.map(saveOrUpdateVO, FinalizedEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            // 查询校验工程定案
            finalizedVO = queryFinalizedList(entity.getProjectId(), entity.getContractId(), null);
            // 查询校验定案阶段
            validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), null);

            List<FinalizedEntity> finalizedEntityList = queryFinalized(entity.getProjectId(),entity.getContractId());
        }else{
            //编辑
            finalizedVO = queryFinalizedList(entity.getProjectId(), entity.getContractId(), entity.getId());
            // 查询校验定案阶段
            validateFinalStage(entity.getProjectId(), entity.getContractId(), entity.getFinalStage(), entity.getId());

            List<FinalizedEntity> finalizedEntityList = queryFinalized(entity.getProjectId(), entity.getContractId());
        }
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        super.saveOrUpdate(entity, false);
        FinalizedVO vo = BeanMapper.map(entity, FinalizedVO.class);
        return vo;
    }


    @Override
    public Boolean validateFinalStage(Long projectId, Long contractId, String finalStage, Long id) {
        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(FinalizedEntity::getId, id);
        }
        wrapper.eq(FinalizedEntity::getContractId, contractId);
        wrapper.orderByDesc(FinalizedEntity::getCreateTime);
        List<FinalizedEntity> list = this.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            if (Objects.equals(finalStage, FinalStageEnum.终审.getCode())) {
                return true;
            }
            if (!Objects.equals(finalStage, FinalStageEnum.一审.getCode())) {
                throw new BusinessException("请先完成一审！");
            }
        }

        boolean flag = list.stream().anyMatch(entity -> entity.getFinalStage().equals(finalStage));
        if (flag) {
            throw new BusinessException("已存在该定案阶段，请重新选择！");
        }

        List<String> finalStageList = list.stream().map(FinalizedEntity::getFinalStage).collect(Collectors.toList());
        if (Objects.equals(finalStage, FinalStageEnum.二审.getCode())) {
            if (!finalStageList.contains(FinalStageEnum.一审.getCode())) {
                throw new BusinessException("请先完成一审！");
            }
        }

        if (Objects.equals(finalStage, FinalStageEnum.三审.getCode())) {
            if (!finalStageList.contains(FinalStageEnum.一审.getCode()) && !finalStageList.contains(FinalStageEnum.二审.getCode())) {
                throw new BusinessException("请先完成一审！");
            }
            if (finalStageList.contains(FinalStageEnum.一审.getCode()) && !finalStageList.contains(FinalStageEnum.二审.getCode())) {
                throw new BusinessException("请先完成二审！");
            }
        }
        return true;
    }


    @Override
    public FinalizedVO queryFinalizedList(Long projectId, Long contractId, Long id) {
        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
        if (!Objects.equals(null, projectId)) {
            wrapper.eq(FinalizedEntity::getProjectId, projectId);
        }
        if (!Objects.equals(null, id)) {
            wrapper.ne(FinalizedEntity::getId, id);
        }
        wrapper.eq(FinalizedEntity::getContractId, contractId);
        wrapper.orderByDesc(FinalizedEntity::getCreateTime);
        List<FinalizedEntity> list = this.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new FinalizedVO();
        }

        long count = list.stream().filter(entity -> entity.getBillState() != 1 && entity.getBillState() != 3).count();
        if (count > 0) {
            throw new BusinessException("当前合同存在非审批通过的工程定案，不允许新增！");
        }

        return BeanMapper.map(list.get(0), FinalizedVO.class);
    }

    @Override
    public List<FinalizedEntity> queryFinalized(Long projectId, Long contractId) {
        LambdaQueryWrapper<FinalizedEntity>query=new LambdaQueryWrapper<>();
        query.eq(FinalizedEntity::getProjectId,projectId);
        query.eq(FinalizedEntity::getContractId,contractId);
        query.eq(FinalizedEntity::getFinalStage,4);
        query.in(FinalizedEntity::getBillState,1,3);
        query.eq(FinalizedEntity::getDr,0);
        List<FinalizedEntity> entities = super.list(query);

        if(ListUtil.isNotEmpty(entities)){
            throw new BusinessException("工程定案终审生效后不可再做工程定案！");
        }
        return entities;
    }

}
