package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.FinishEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IFinishService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.NCUtil;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.*;

@Service("finish") 
public class FinishBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IFinishService service;

	@Autowired
	private IContractService contractService;

	@Autowired
	private NCUtil ncUtil;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};


	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FinishEntity finishEntity = service.selectById(billId);
		ContractEntity contractEntity = contractService.selectById(finishEntity.getContractId());
		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(finishEntity.getProjectId())).get(0);
		if ("1".equals(project.getIndustryIntegrationFlag())){
			this.pushToNC(finishEntity,contractEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		FinishEntity finishEntity = service.selectById(billId);
		// 删除NC传应收单凭证
		if(StringUtils.isNotEmpty(finishEntity.getSourceId())){
			String[] split = finishEntity.getSourceId().split(",");
			for (String sourceId : split){
				JSONObject json = new JSONObject();
				json.put("busitype", "deletearbill");
				json.put("pk_bill", sourceId);
				ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
			}
			LambdaUpdateWrapper<FinishEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(FinishEntity::getSourceId, null);// 保存来源主键
			wrapper.eq(FinishEntity::getId, billId);
			service.update(wrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 推送NC传应收单凭证
	 * @param entity
	 */
	private void pushToNC(FinishEntity entity,ContractEntity contractEntity) {
		ArBillVO vo = this.transferToNCVO(entity,contractEntity);// 转换成NCVO
		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
//        List<Long> orgIds = ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
		List<Long> orgIds = ncUtil.validateInvoiceMainOrg(project.getOrgId(), project.getMainOrgId());
		StringBuffer stringBuffer = new StringBuffer();
		for(Long orgId:orgIds){
			OrgVO orgVO = ncUtil.queryOrgById(orgId);
			vo.setPk_org(orgVO.getCode());
			String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
			stringBuffer.append(sourceId).append(",");
		}
		String sourceIds = stringBuffer.substring(0,stringBuffer.length()-1);
		LambdaUpdateWrapper<FinishEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(FinishEntity::getSourceId, sourceIds);// 保存来源主键
		wrapper.eq(FinishEntity::getId, entity.getId());
		service.update(wrapper);
	}

	/**
	 * 转换成NCVO
	 * @param entity
	 * @return
	 */
	private ArBillVO transferToNCVO(FinishEntity entity,ContractEntity contractEntity){
		logger.info("----应收单传凭证开始:");
		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
		OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
		CustomerVO customerVO = ncUtil.queryCustomerById(contractEntity.getCustomerId());
		ArBillVO vo = new ArBillVO();
		vo.setBusitype("arbill");// 业务标识
		vo.setTradetype("F0-Cxx-001");// 交易类型
		vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
		vo.setPk_dept(String.valueOf(project.getDeptId()));// 部门主键
		vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
		vo.setDef19(entity.getBillCode());//单据编号
		vo.setPk_org(orgVO.getCode());// 财务组织编码
		vo.setDef1(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate() ? true : false);// 是否有计量证书
		vo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));// 开票主体分类 0-PMDA06001,1-PMDA06002
		vo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay()));// 计税方式 0-01,1-02
//        vo.setDef4(String.valueOf(project.getEngineeringType()));// 工程类型
		if(StringUtils.isEmpty(project.getAreaCode())){
			throw new BusinessException("项目-区域不能为空");
		}
		vo.setDef5(project.getAreaCode());// 区域编码
        vo.setPk_customer(String.valueOf(contractEntity.getCustomerId()));// 客户主键
		vo.setDef6(customerVO.getInsideOrgId() != null);// 是否内部单位 true/false
		vo.setDef7(ncUtil.getTaxRateDefCode(entity.getTaxRate()));// 税率
		vo.setDef8(contractEntity.getBillCode());
		vo.setDef9(contractEntity.getContractName());
		vo.setDef20(ncUtil.getWebSite("ejc-income-frontend/#/finish/card?id=" + entity.getId()));// 外部访问url
		vo.setDef21("BT210701000000001");// 单据类型

		List<ArBillDetailVO> detailVOS = new ArrayList<>();
		ArBillDetailVO detailVO = new ArBillDetailVO();
		detailVO.setPk_project(String.valueOf(entity.getProjectId()));
		// 累计结算差额 = 累计结算金额 - 累计报量金额
		BigDecimal sumSettleCutTaxMny = ComputeUtil.safeSub(entity.getSumSettleTaxMny(),entity.getSumQuoteTaxMny());
		// 因未记录累计报量金额(无税)，则由含税算无税
		BigDecimal sumSettleCutMny = ComputeUtil.safeMultiply(sumSettleCutTaxMny, ComputeUtil.safeDiv(ComputeUtil.safeAdd(new BigDecimal(100), entity.getTaxRate()), new BigDecimal(100)));
		detailVO.setNotaxmny(sumSettleCutMny); //无税
		detailVO.setTotalmny(sumSettleCutTaxMny);//含税
		detailVO.setTaxmny(entity.getTaxMny());
		detailVOS.add(detailVO);
		vo.setDetail(detailVOS);
		return  vo;
	}
}
