package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.HistoryClauseEntity;
import com.ejianc.business.income.bean.HistoryDetailEntity;
import com.ejianc.business.income.bean.HistoryEntity;
import com.ejianc.business.income.mapper.HistoryMapper;
import com.ejianc.business.income.service.IHistoryClauseService;
import com.ejianc.business.income.service.IHistoryDetailService;
import com.ejianc.business.income.service.IHistoryService;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.HistoryClauseVo;
import com.ejianc.business.income.vo.HistoryDetailVo;
import com.ejianc.business.income.vo.HistoryVo;
import com.ejianc.business.income.vo.comparator.HistoryDetailComparatorVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 施工合同记录表 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Service("HistoryService")
public class HistoryServiceImpl extends BaseServiceImpl<HistoryMapper, HistoryEntity> implements IHistoryService {
    @Autowired
    private IHistoryDetailService historyDetailService;
    @Autowired
    private IHistoryClauseService historyClauseService;

    @Override
    public HistoryVo queryDetailByChangeId(Long changeId) {

        HistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<HistoryEntity>().eq("change_id", changeId));
        if(historyEntity !=null){
            HistoryVo historyVo = BeanMapper.map(historyEntity, HistoryVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("historyId", new Parameter(QueryParam.EQ, historyEntity.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<HistoryDetailEntity> historyDetailEntities = historyDetailService.queryList(queryParam, false);

            if(historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<HistoryDetailVo> detailVos = BeanMapper.mapList(historyDetailEntities, HistoryDetailVo.class);
                //实现排序
                Collections.sort(detailVos,new HistoryDetailComparatorVo());
                for(HistoryDetailVo cdEntity:detailVos){
                    cdEntity.setTid(cdEntity.getContractBid().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                    //cdEntity.setRowState("edit");
                }
                historyVo.setCheckList(TreeNodeBUtil.buildTree(detailVos));
            }

            QueryParam query = new QueryParam();
            query.getParams().put("historyId", new Parameter(QueryParam.EQ, historyEntity.getId()));
            query.getOrderMap().put("createTime", "desc");
            List<HistoryClauseEntity> clauses = historyClauseService.queryList(query, false);
            if(clauses != null && clauses.size() > 0) {
                List<HistoryClauseVo> clauseVoList = BeanMapper.mapList(clauses, HistoryClauseVo.class);
                historyVo.setClauseList(clauseVoList);
            }
            return historyVo;
        }
        return null;
    }
}
