package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.service.*;
import com.ejianc.business.income.utils.DateUtil;
import com.ejianc.business.income.utils.NCUtil;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.ArBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ArBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

@Service("quote")
public class QuoteBpmService implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IQuoteClaimService quoteClaimService;
    @Autowired
    private IQuoteDetailService quoteDetailService;
    @Autowired
    private IProductionService productionService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private NCUtil ncUtil;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //回写主表
      QuoteEntity quoteEntity = quoteService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(quoteEntity.getContractId());
        //本期报量金额（含税）
          BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        //累计报量（含税）
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        //累加
        contractEntity.setSumQuoteTaxMny(quoteTaxMny.add(sumQuoteTaxMny));

        //本期报量金额（不含税）
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        //累计报量（不含税）
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        //累计报量（不含税）
        contractEntity.setSumQuoteMny(quoteMny.add(sumQuoteMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter(QueryParam.EQ, quoteEntity.getId()));
        List<QuoteClaimEntity> claimList = quoteClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            Map<Long, BigDecimal> idTaxMap = new HashMap<>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
                idTaxMap.put(pce.getClaimId(), pce.getClaimOccurTaxMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumQuoteMny((ce.getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny())
                        .add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
                ce.setSumQuoteTaxMny((ce.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : ce.getSumQuoteTaxMny())
                        .add(idTaxMap.get(ce.getId()) == null ? BigDecimal.ZERO : idTaxMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
        // 回写产值报量是否被引用过
        List<QuoteDetailEntity> checkList = quoteDetailService.queryList(parm, false);

        if (null != checkList && checkList.size() > 0) {
            Set<Long> ids = new HashSet<>();
            for(QuoteDetailEntity qde:checkList){
                if(null!=qde.getProductionId()&&qde.getProductionId()>0){
                    if(ids.add(qde.getProductionId())){
                        LambdaUpdateWrapper<ProductionEntity> updateWrapper = new LambdaUpdateWrapper<>();
                        updateWrapper.set(ProductionEntity::getQuoteFlag,1);//已被引用
                        updateWrapper.eq(ProductionEntity::getId,qde.getProductionId());
                        productionService.update(updateWrapper);
                    }
                }
            }
        }
        //推送凭证
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(quoteEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())){
            this.pushToNC(quoteEntity,contractEntity);
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QuoteEntity entity = quoteService.selectById(billId);
        LambdaQueryWrapper<QuoteEntity> lamb = new LambdaQueryWrapper();
        lamb.eq(QuoteEntity::getContractId, entity.getContractId());
        lamb.last("and date_format(quote_date,'%Y-%m')>'" + DateUtil.getYearAndMonth(entity.getQuoteDate())+ "'");
        List<QuoteEntity> list = quoteService.list(lamb);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("存在比当前甲方批量月份更晚的单据，不可跨期弃审！");
        }
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
        if(res.isSuccess()) {//单据未被下游单据引用
            callBackQuote(billId,state,billTypeCode);
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 删除NC传应收单凭证
        QuoteEntity quoteEntity = quoteService.selectById(billId);
        if(StringUtils.isNotEmpty(quoteEntity.getSourceId())){
            String[] split = quoteEntity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deletearbill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }
            LambdaUpdateWrapper<QuoteEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(QuoteEntity::getSourceId, null);// 保存来源主键
            wrapper.eq(QuoteEntity::getId, billId);
            quoteService.update(wrapper);
        }
        return CommonResponse.success();
    }

    private void callBackQuote(Long billId, Integer state, String billTypeCode){
        //回写主表
        QuoteEntity quoteEntity = quoteService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(quoteEntity.getContractId());
        //本期报量金额（含税）
        BigDecimal quoteTaxMny = quoteEntity.getQuoteTaxMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteTaxMny();
        //累计报量（含税）
        BigDecimal sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        //累加
        contractEntity.setSumQuoteTaxMny(sumQuoteTaxMny.subtract(quoteTaxMny));

        //本期报量金额（不含税）
        BigDecimal quoteMny = quoteEntity.getQuoteMny() == null ? BigDecimal.ZERO : quoteEntity.getQuoteMny();
        //累计报量（不含税）
        BigDecimal sumQuoteMny = contractEntity.getSumQuoteMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteMny();
        //累计报量（不含税）
        contractEntity.setSumQuoteMny(sumQuoteMny.subtract(quoteMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("quoteId", new Parameter(QueryParam.EQ, quoteEntity.getId()));
        List<QuoteClaimEntity> claimList = quoteClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            Map<Long, BigDecimal> idTaxMap = new HashMap<>();
            for (QuoteClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
                idTaxMap.put(pce.getClaimId(), pce.getClaimOccurTaxMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumQuoteMny((ce.getSumQuoteMny() == null ? BigDecimal.ZERO : ce.getSumQuoteMny())
                        .subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
                ce.setSumQuoteTaxMny((ce.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : ce.getSumQuoteTaxMny())
                        .subtract(idTaxMap.get(ce.getId()) == null ? BigDecimal.ZERO : idTaxMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
        // 回写产值报量是否被引用过
        List<QuoteDetailEntity> checkList = quoteDetailService.queryList(parm, false);

        if (null != checkList && checkList.size() > 0) {
            Set<Long> ids = new HashSet<>();
            for(QuoteDetailEntity qde:checkList){
                if(null!=qde.getProductionId()&&qde.getProductionId()>0){
                    if(ids.add(qde.getProductionId())){
                        LambdaUpdateWrapper<ProductionEntity> updateWrapper = new LambdaUpdateWrapper<>();
                        updateWrapper.set(ProductionEntity::getQuoteFlag,0);//已被引用
                        updateWrapper.eq(ProductionEntity::getId,qde.getProductionId());
                        productionService.update(updateWrapper);
                    }
                }
            }
        }
    }

    /**
     * 推送NC传应收单凭证
     * @param entity
     */
    private void pushToNC(QuoteEntity entity,ContractEntity contractEntity) {
        ArBillVO vo = this.transferToNCVO(entity,contractEntity);// 转换成NCVO
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
//        List<Long> orgIds = ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        List<Long> orgIds = ncUtil.validateInvoiceMainOrg(project.getOrgId(), project.getMainOrgId());
        StringBuffer stringBuffer = new StringBuffer();
        for(Long orgId:orgIds){
            OrgVO orgVO = ncUtil.queryOrgById(orgId);
            vo.setPk_org(orgVO.getCode());
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口
            stringBuffer.append(sourceId).append(",");
        }
        String sourceIds = stringBuffer.substring(0,stringBuffer.length()-1);
        LambdaUpdateWrapper<QuoteEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(QuoteEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(QuoteEntity::getId, entity.getId());
        quoteService.update(wrapper);
    }

    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private ArBillVO transferToNCVO(QuoteEntity entity, ContractEntity contractEntity){
        logger.info("----应收单传凭证开始:");
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = ncUtil.queryCustomerById(contractEntity.getCustomerId());
        ArBillVO vo = new ArBillVO();
        vo.setBusitype("arbill");// 业务标识
        vo.setTradetype("F0-Cxx-008");// 交易类型
        vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
        vo.setPk_dept(String.valueOf(project.getDeptId()));// 部门主键
        vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
        vo.setDef19(entity.getBillCode());//单据编号
        vo.setPk_org(orgVO.getCode());// 财务组织编码
        vo.setDef1(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate() ? true : false);// 是否有计量证书
        vo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));// 开票主体分类 0-PMDA06001,1-PMDA06002
        vo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay()));// 计税方式 0-01,1-02
        if(StringUtils.isEmpty(ncUtil.getDefDocById(project.getEngineeringType()).getCode())){
            throw new BusinessException("项目-工程类型不能为空");
        }
        vo.setDef4(ncUtil.getDefDocById(project.getEngineeringType()).getCode());// 工程类型
        if(StringUtils.isEmpty(project.getAreaCode())){
            throw new BusinessException("项目-区域不能为空");
        }
        vo.setDef5(project.getAreaCode());// 区域编码
        vo.setPk_customer(String.valueOf(contractEntity.getCustomerId()));// 客户主键
        vo.setDef6(customerVO.getInsideOrgId() != null);// 是否内部单位 true/false
        vo.setDef7(ncUtil.getTaxRateDefCode(entity.getTaxRate()));// 税率
        vo.setDef8(contractEntity.getBillCode());
        vo.setDef9(contractEntity.getContractName());
        vo.setDef20(ncUtil.getWebSite("ejc-income-frontend/#/quote/card?id=" + entity.getId()));// 外部访问url
        vo.setDef21("BT200609000000001");// 单据类型

        List<ArBillDetailVO> detailVOS = new ArrayList<>();
        ArBillDetailVO detailVO = new ArBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getQuoteMny());
        detailVO.setTotalmny(entity.getQuoteTaxMny());
        detailVO.setTaxmny(entity.getTaxMny());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return  vo;
    }
}
