package com.ejianc.business.income.utils;

import java.math.BigDecimal;

public class MathUtil {
    public static int precision = 18;

    public MathUtil() {
    }

    public static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        return decimal1 != null && decimal2 != null && decimal2.compareTo(BigDecimal.ZERO) != 0 ? decimal1.divide(decimal2, precision, 6) : new BigDecimal(0);
    }

    public static BigDecimal safeAdd(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            return decimal2;
        } else {
            return decimal2 == null ? decimal1 : decimal1.add(decimal2);
        }
    }

    public static BigDecimal safeMultiply(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }

        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }

        return decimal1.multiply(decimal2).setScale(precision, 6);
    }

    public static BigDecimal safeSub(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null) {
            decimal1 = new BigDecimal(0);
        }

        if (decimal2 == null) {
            decimal2 = new BigDecimal(0);
        }

        return decimal1.subtract(decimal2);
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? src : src.setScale(2, 6);
    }

}
