package com.ejianc.business.inother.controller;

import java.io.Serializable;

import com.ejianc.business.inother.bean.OtherSupplementEntity;
import com.ejianc.business.inother.history.OtherSupplementHistoryVO;
import com.ejianc.business.inother.vo.OtherSupplementVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.inother.service.IOtherSupplementService;

/**
 * 其他收入合同补充协议
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherSupplement")
public class OtherSupplementController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOtherSupplementService supplementService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherSupplementVO> saveOrUpdate(@RequestBody OtherSupplementVO OtherSupplementVO) {
        OtherSupplementVO vo = supplementService.insertOrUpdate(OtherSupplementVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSupplementVO> queryDetail(Long id) {
        OtherSupplementVO vo = supplementService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSupplementVO> addConvertByConId(@RequestParam Long id) {
        OtherSupplementVO vo = supplementService.addConvertByConId(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherSupplementHistoryVO> queryDetailRecord(@RequestParam Long id) {
        OtherSupplementHistoryVO vo = supplementService.queryDetailRecord(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherSupplementVO> vos) {
        supplementService.removeByIds(vos.stream().map(OtherSupplementVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OtherSupplementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<OtherSupplementEntity> page = supplementService.queryPage(param,false);
        IPage<OtherSupplementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OtherSupplementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
