/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.inother.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.inother.bean.OtherContractEntity;
import com.ejianc.business.inother.bean.OtherSettleEntity;
import com.ejianc.business.inother.history.OtherSettleHistoryVO;
import com.ejianc.business.inother.mapper.OtherSettleMapper;
import com.ejianc.business.inother.service.IOtherContractService;
import com.ejianc.business.inother.service.IOtherSettleDetailService;
import com.ejianc.business.inother.service.IOtherSettleService;
import com.ejianc.business.inother.vo.OtherSettleDetailVO;
import com.ejianc.business.inother.vo.OtherSettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherSettleService")
public class OtherSettleServiceImpl
extends BaseServiceImpl<OtherSettleMapper, OtherSettleEntity>
implements IOtherSettleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String OTHER_SETTLE_CODE = "OTHER_IN_SETTLE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private OtherSettleMapper otherSettleMapper;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherSettleDetailService service;

    @Override
    public CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO) {
        int num;
        OtherContractEntity contractEntity;
        if (saveorUpdateVO.getId() == null) {
            Long tenantId = InvocationInfoProxy.getTenantid();
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(OTHER_SETTLE_CODE, tenantId);
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode((String)billCode.getData());
            } else {
                return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(saveorUpdateVO.getContractId()))) != null && contractEntity.getChangeStatus() == 2) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5904\u4e8e\u53d8\u66f4\u4e2d\u72b6\u6001\uff0c\u4e0d\u80fd\u505a\u5408\u540c\u7ed3\u7b97!");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(OtherContractEntity::getMainContractId, (Object)saveorUpdateVO.getContractId());
        lambda.eq(OtherContractEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.eq(OtherContractEntity::getSupplementFlag, (Object)1);
        int conNum = this.contractService.count((Wrapper)lambda);
        if (conNum > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u505a\u5408\u540c\u7ed3\u7b97!");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(OtherSettleEntity::getContractId, (Object)saveorUpdateVO.getContractId());
        lambdaQuery.notIn(OtherSettleEntity::getBillState, new Object[]{1, 3});
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        if ((num = this.count((Wrapper)lambdaQuery)) > 0) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u7ed3\u7b97\u53ea\u80fd\u5b58\u5728\u4e00\u6761\u672a\u751f\u6548\u7684!");
        }
        Date signDate = contractEntity.getSignDate();
        if (null != signDate && saveorUpdateVO.getQuoteDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u7ed3\u7b97\u65e5\u671f\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u5176\u4ed6\u6536\u5165\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        OtherSettleEntity entity = (OtherSettleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OtherSettleEntity.class));
        this.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(OtherContractEntity::getIsFinish, (Object)1);
        updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getContractId());
        this.contractService.update((Wrapper)updateWrapper);
        OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public OtherSettleVO queryDetail(Long id) {
        OtherSettleEntity entity = (OtherSettleEntity)((Object)this.otherSettleMapper.selectById(id));
        if (entity != null) {
            OtherSettleVO vo = (OtherSettleVO)BeanMapper.map((Object)((Object)entity), OtherSettleVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("quoteId", new Parameter("eq", (Object)vo.getId()));
            List details = this.service.queryList(queryParam, false);
            vo.setCheckList(BeanMapper.mapList((Iterable)details, OtherSettleDetailVO.class));
            return vo;
        }
        return null;
    }

    @Override
    public OtherSettleHistoryVO queryQuoteHistory(Long id) {
        BigDecimal sumQuoteTaxMny;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List quoteEntities = this.otherSettleMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object[])new String[]{"quote_date", "create_time"}));
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        OtherSettleHistoryVO vo = new OtherSettleHistoryVO();
        vo.setContractId(id);
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setSumQuoteTaxMny(contractEntity.getSumQuoteTaxMny());
        BigDecimal bigDecimal = sumQuoteTaxMny = contractEntity.getSumQuoteTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumQuoteTaxMny();
        if (contractEntity.getContractTaxMny() == null || contractEntity.getContractTaxMny().compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumQuoteRate(BigDecimal.ZERO);
        } else {
            vo.setSumQuoteRate(sumQuoteTaxMny.divide(contractEntity.getContractTaxMny(), 8, 4).multiply(new BigDecimal(100)));
        }
        vo.setQuoteRecord(BeanMapper.mapList((Iterable)quoteEntities, OtherSettleVO.class));
        return vo;
    }
}

