package com.ejianc.business.inother.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.inother.vo.OtherContractVO;
import com.ejianc.business.inother.bean.OtherContractEntity;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.inother.service.IOtherContractService;

/**
 * 其他收入合同
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("otherContract")
public class OtherContractController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    
    @Autowired
    private IOtherContractService  contractService;

    /**
     * 新增或编辑
     *
     * @param OtherContractVO
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherContractVO> saveOrUpdate(@RequestBody OtherContractVO OtherContractVO) {
        CommonResponse<OtherContractVO> response = contractService.saveOrUpdate(OtherContractVO);
        return response;
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetail(@RequestParam Long id) {
        OtherContractVO purchaseOtherContractVO = contractService.queryDetail(id);
        return CommonResponse.success(purchaseOtherContractVO);
    }


    /**
     * 删除
     *
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherContractVO> vos) {
        contractService.deleteContract(vos);
        for (OtherContractVO otherContractVO : vos) {
			if(otherContractVO.getMainContractId() !=null) {
				contractService.updateContractIsSupplementFlag(otherContractVO.getMainContractId());
			}
		}
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、发包单位、承包单位、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        param.getParams().put("bill_type",new Parameter("eq","other"));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<OtherContractEntity> pageData = contractService.queryPage(param, false);


        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = contractService.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), OtherContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * 查询汇总金额
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/sumMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> sumMny(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、发包单位、承包单位、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<OtherContractEntity> list = contractService.queryList(param, false);
        Map<String, BigDecimal> map = new HashMap<>();
        BigDecimal sumBaseMoney = BigDecimal.ZERO;
        BigDecimal sumContractMny = BigDecimal.ZERO;
        for (OtherContractEntity entity : list) {
            if (entity.getBaseTaxMoney() != null) {
                sumBaseMoney = sumBaseMoney.add(entity.getBaseTaxMoney());
            }
            if (entity.getContractTaxMny() != null) {
                sumContractMny = sumContractMny.add(entity.getContractTaxMny());
            }
        }
        map.put("sumBaseMoney", sumBaseMoney);
        map.put("sumContractMny", sumContractMny);
        return CommonResponse.success("查询汇总金额成功！", map);
    }

    /**
     * 合同参照
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OtherContractEntity>> queryRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                          @RequestParam(defaultValue = "10") Integer pageSize,
                                                          @RequestParam(value = "searchText", required = false) String searchText,
                                                          @RequestParam(value = "condition", required = false) String condition) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        //竣工结算标志
        queryParam.getParams().put("is_finish", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("bill_type", new Parameter(QueryParam.EQ, "other"));
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("contractStatus")) {
                Long contractStatus = Long.valueOf(conditionMap.get("contractStatus").toString());
                queryParam.getParams().put("contractStatus", new Parameter(QueryParam.NE, contractStatus));
            }
            if (null != conditionMap.get("isFinishFlag")) {
                boolean flag = Boolean.valueOf(conditionMap.get("isFinishFlag").toString());
                // isFinishFlag 是否根据竣工过滤
                if(!flag){
                    queryParam.getParams().remove("is_finish");
                }
            }
        }
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        //queryParam.getOrderMap().put("signDate","desc");
        queryParam.getOrderMap().put("createTime", "desc");
        return CommonResponse.success("查询列表数据成功！", contractService.queryPage(queryParam, false));
    }

    /**
     * 合同状态修改
     *
     * @param OtherContractVO
     * @return
     */
    @PostMapping("changeState")
    public CommonResponse<String> changeState(@RequestBody OtherContractVO OtherContractVO) {
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OtherContractEntity::getId, OtherContractVO.getId());
        updateWrapper.set(OtherContractEntity::getContractStatus, OtherContractVO.getContractStatus());
        contractService.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、发包单位、承包单位、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("bill_type",new Parameter(QueryParam.EQ, "other"));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage<OtherContractEntity> pageData = contractService.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<OtherContractVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), OtherContractVO.class);
            list.forEach(vo -> {
                if (null != vo.getContractStatus()) {
                    if (1 == vo.getContractStatus()) {
                        vo.setContractStatusName("未签订");
                    } else if (2 == vo.getContractStatus()) {
                        vo.setContractStatusName("履约中");
                    } else if (3 == vo.getContractStatus()) {
                        vo.setContractStatusName("已封账");
                    }
                } else {
                    vo.setContractStatusName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("other-contract-export.xlsx", beans, response);
    }

    /**
     * 工程收款
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinanceHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractEntity> queryFinanceHistory(@RequestParam Long id) {
        OtherContractEntity vo = contractService.queryFinanceHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 开票登记
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryTaxHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenRecordVO> queryTaxHistory(@RequestParam Long id) {
        InvoiceOpenRecordVO vo = contractService.queryTaxHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/contractDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> contractDetail(@RequestParam Long id) {
        OtherContractVO vo = contractService.contractDetail(id);
        return CommonResponse.success(vo);
    }
}
