package com.ejianc.business.income.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.SupplementEntity;
import com.ejianc.business.income.history.ChangeHistoryVo;
import com.ejianc.business.income.history.SupplementHistoryVo;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.ISupplementService;
import com.ejianc.business.income.vo.SupplementVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 补充协议实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("supplement")
public class SupplementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplementService supplementService;
    @Autowired
    private IContractService contractService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplementVO> saveOrUpdate(@RequestBody SupplementVO supplementVO) {
    	SupplementVO vo = supplementService.insertOrUpdate(supplementVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementVO> queryDetail(Long id) {
        SupplementVO vo = supplementService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementVO> addConvertByConId(@RequestParam Long id) {
        SupplementVO vo = supplementService.addConvertByConId(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementHistoryVo> queryDetailRecord(@RequestParam Long id) {
        SupplementHistoryVo vo = supplementService.queryDetailRecord(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplementVO> vos) {
    	Long[] ids=new Long[vos.size()];
    	for (int i = 0; i < ids.length; i++) {
    		SupplementEntity entity =supplementService.getById(vos.get(i).getId());
    		ids[i]=entity.getMainContractId();
		}
        supplementService.removeByIds(vos.stream().map(SupplementVO::getId).collect(Collectors.toList()),true);
        for (int i = 0; i < ids.length; i++) {
        	contractService.updateContractIsSupplementFlag(ids[i]);
		}
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SupplementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SupplementEntity> page = supplementService.queryPage(param,false);
        IPage<SupplementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SupplementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
