package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ClaimDetailEntity;
import com.ejianc.business.income.mapper.ClaimDetailMapper;
import com.ejianc.business.income.service.IClaimDetailService;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.vo.ClaimDetailVo;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 * 签证洽商索赔-清单 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Service("ClaimDetailService")
public class ClaimDetailServiceImpl extends BaseServiceImpl<ClaimDetailMapper, ClaimDetailEntity> implements IClaimDetailService {

    @Override
    public void deleteByClaimId(Long id) {
        QueryWrapper<ClaimDetailEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("claim_id", id);
        baseMapper.delete(deleteWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<ClaimDetailVo> detailVoList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ClaimDetailVo vo = new ClaimDetailVo();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex,id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第"+(i+2)+"行序号和第" + (indexMap.get(detailIndex)+2) + "行重复");
                    }else{
                        indexMap.put(detailIndex,i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"[清单编码为空]";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"[清单名称为空]";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setUnit(datas.get(3));//计量单位

                    if (StringUtils.isEmpty(datas.get(4))) {
                        vo.setOccurTaxRate(null);
                    } else {
                        try {
                            vo.setOccurTaxRate(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            vo.setOccurTaxRate(null);
                            warnType = warnType+"[税率只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(5))) {
                        vo.setOccurNum(null);
                        warnType = warnType+"[工程量为空]";
                        flag = true;
                    } else {
                        try {
                            vo.setOccurNum(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            vo.setOccurNum(null);
                            warnType = warnType+"[工程量只能为数字或小数]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(datas.get(6))) {
                        vo.setOccurPrice(null);
                    } else {
                        try {
                            vo.setOccurPrice(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            vo.setOccurPrice(null);
                            warnType = warnType+"[单价(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(7))) {
                        vo.setOccurTaxPrice(null);
                    } else {
                        try {
                            vo.setOccurTaxPrice(new BigDecimal(datas.get(7)));
                        } catch (Exception e) {
                            vo.setOccurTaxPrice(null);
                            warnType = warnType+"[单价只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        vo.setOccurMny(null);
                    } else {
                        try {
                            vo.setOccurMny(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            vo.setOccurMny(null);
                            warnType = warnType+"[发生金额(无税)只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        vo.setOccurTaxMny(null);
                    } else {
                        try {
                            vo.setOccurTaxMny(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            vo.setOccurTaxMny(null);
                            warnType = warnType+"[发生金额只能为数字或小数]";
                            flag = true;
                        }
                    }
                    if (StringUtils.isEmpty(datas.get(10))) {
                        vo.setOccurTax(null);
                    } else {
                        try {
                            vo.setOccurTax(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            vo.setOccurTax(null);
                            warnType = warnType+"[税额只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setMemo(datas.get(11));

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setSourceType(2);//新增
                    detailVoList.add(vo);
                }

                for(ClaimDetailVo tVo:detailVoList){
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                new TaxCalculateUtil<ClaimDetailVo>().calculate(detailVoList);
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList",allList.get(0));
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - 1 - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }
}
