package com.ejianc.business.inother.controller;

import java.io.Serializable;

import com.ejianc.business.inother.history.OtherChangeHistoryVO;
import com.ejianc.business.inother.service.IOtherChangeService;
import com.ejianc.business.inother.service.IOtherContractService;
import com.ejianc.business.inother.vo.OtherChangeVO;

import java.util.List;

import com.ejianc.business.inother.vo.OtherContractVO;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 其他收入合同变更实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("otherChange")
public class OtherChangeController implements Serializable {
    @Autowired
    private IOtherChangeService changeService;
    @Autowired
    private IOtherContractService contractService;
    /**
     * 新增或编辑
     *
     * @param OtherChangeVO
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherChangeVO> saveOrUpdate(@RequestBody OtherChangeVO OtherChangeVO) {
        CommonResponse<OtherChangeVO> response = changeService.saveOrUpdate(OtherChangeVO);
        return response;
    }

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherChangeVO> queryDetail(@RequestParam Long id) {
        OtherChangeVO OtherChangeVO = changeService.queryDetail(id);
        return CommonResponse.success(OtherChangeVO);
    }

    /**
     * 删除
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherChangeVO> vos) {
        changeService.deleteChange(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetailChange(@RequestParam Long id) {
        OtherContractVO vo=changeService.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherChangeHistoryVO> queryChangeHistory(@RequestParam Long id) {
        OtherChangeHistoryVO vo = changeService.queryChangeHistory(id);

        return CommonResponse.success(vo);
    }
}
