package com.ejianc.business.income.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 年度计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_year_plan")
public class YearPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="plan_date")
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date planDate; // 年度
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税率
    @TableField(value="year_production_tax_mny")
    private BigDecimal yearProductionTaxMny; // 本年计划产值
    @TableField(value="year_production_mny")
    private BigDecimal yearProductionMny; // 本年计划产值(无税)
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id（申请人）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称（申请人）
    @TableField(value="department_id")
    private Long departmentId; // 经办（申请人）部门id
    @TableField(value="department_name")
    private String departmentName; // 经办（申请人）部门名称
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="yearPlanDetailService" ,pidName = "yearPlanId")
    private List<YearPlanDetailEntity> detailList = new ArrayList<>(); // 年度计划详情
    

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getYearProductionTaxMny() {
        return yearProductionTaxMny;
    }

    public void setYearProductionTaxMny(BigDecimal yearProductionTaxMny) {
        this.yearProductionTaxMny = yearProductionTaxMny;
    }
    public BigDecimal getYearProductionMny() {
        return yearProductionMny;
    }

    public void setYearProductionMny(BigDecimal yearProductionMny) {
        this.yearProductionMny = yearProductionMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<YearPlanDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<YearPlanDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
