package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IReceiveManageApi;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.income.bean.ContractClauseEntity;
import com.ejianc.business.income.bean.ContractDetailEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.SupplementEntity;
import com.ejianc.business.income.mapper.ContractMapper;
import com.ejianc.business.income.service.CommonBillCodeService;
import com.ejianc.business.income.service.IContractClauseService;
import com.ejianc.business.income.service.IContractDetailService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.ISupplementService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.*;
import com.ejianc.business.income.vo.comparator.ContractDetailComparatorVo;
import com.ejianc.business.income.vo.report.FinanceMnyVo;
import com.ejianc.business.income.vo.warn.IncomeContractWarnVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.business.income.utils.AddressResolutionUtil.*;

/**
 * <p>
 * 施工合同表 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@Service("ContractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService {
    private static final String INCOME_CONTRACT_BILL_CODE = "INCOME_CONTRACT";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ContractMapper contractMapper;
    @Autowired
    private IContractDetailService detailsService;
    @Autowired
    private IContractClauseService clauseService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IReceiveManageApi receiveManageApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IUserApi userApi;

    @Autowired
    private IProjectApi iProjectApi;

    @Autowired
    private CommonBillCodeService commonBillCodeService;

    @Autowired
    private IOrgApi orgApi;
    
    @Autowired
    private ISupplementService supplementService;

    @Override
    public CommonResponse<ContractVo> saveOrUpdate(ContractVo contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = null;
        String operateType = null;
        if(contractVo.getId() != null && contractVo.getId() > 0) { //修改
            if(StringUtils.isEmpty(contractVo.getBillCode())){
                throw new BusinessException("编码为空，不允许保存!");
//                contractVo.setBillCode(null);
            }
            entity = BeanMapper.map(contractVo, ContractEntity.class);
            operateType = "edit";
        }else{
            //新增
            if(StringUtils.isEmpty(contractVo.getBillCode())){
                String code = commonBillCodeService.getCodeByOrgId(contractVo.getOrgId(), INCOME_CONTRACT_BILL_CODE, contractVo);
                contractVo.setBillCode(code);
            }
            if(StringUtils.isEmpty(contractVo.getIsSupplement())) {
            	contractVo.setIsSupplement("0");
            }
            //新增设置 竣工结算标志
            contractVo.setIsFinish(0);
            entity = BeanMapper.map(contractVo, ContractEntity.class);
            operateType = "add";
        }
        logger.info("单据编码：{}", contractVo.getBillCode());
        if(contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.ne(ContractEntity::getId, contractVo.getId());
            List<ContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
            lambda.eq(ContractEntity::getTenantId, tenantId);
            lambda.eq(ContractEntity::getBillCode, contractVo.getBillCode());
            List<ContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        entity.setBillType("income");
        super.saveOrUpdate(entity);

        List<ContractDetailVo> detailsVos = contractVo.getCheckList();
        List<ContractDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for(ContractDetailVo detailsVo:detailsVos) {
            detailsVo.setChangeType(0);//因为导入的时候设置为增补项，避免后面逻辑问题，这里修改一下
            if("add".equals(detailsVo.getRowState())) {
                ContractDetailEntity detailslist = BeanMapper.map(detailsVo, ContractDetailEntity.class);
                detailslist.setContractId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
            }else if("edit".equals(detailsVo.getRowState())) {
                ContractDetailEntity detailslist = BeanMapper.map(detailsVo, ContractDetailEntity.class);
                saveOrUpldates.add(detailslist);
            } else if("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        if(saveOrUpldates.size() > 0) {
            detailsService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            //维护父子级关系
            Map<String,Long> idMap=new HashMap<>();
            for(ContractDetailEntity cdEntity:saveOrUpldates){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(ContractDetailEntity cdEntity:saveOrUpldates){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            detailsService.saveOrUpdateBatch(saveOrUpldates,saveOrUpldates.size(),false);
        }
        if(deleteIds.size() > 0) {
            detailsService.removeByIds(deleteIds, false);
        }

        List<ContractClauseVo> clauseVos = contractVo.getClauseList();
        List<ContractClauseEntity> clauseList = new ArrayList<>();
        List<Long> deleteClauseIds = new ArrayList<>();
        for(ContractClauseVo clauseVo:clauseVos) {
            if("add".equals(clauseVo.getRowState())) {
                ContractClauseEntity detailslist = BeanMapper.map(clauseVo, ContractClauseEntity.class);
                detailslist.setContractId(entity.getId());
                clauseList.add(detailslist);
            }else if("edit".equals(clauseVo.getRowState())) {
                ContractClauseEntity detailslist = BeanMapper.map(clauseVo, ContractClauseEntity.class);
                clauseList.add(detailslist);
            } else if("del".equals(clauseVo.getRowState())) {
                deleteClauseIds.add(clauseVo.getId());
            }
        }
        if(clauseList.size() > 0) {
            clauseService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if(deleteClauseIds.size() > 0) {
            clauseService.removeByIds(deleteClauseIds, false);
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public ContractVo queryDetail(Long id) {
        ContractEntity entity = contractMapper.selectById(id);
        if(entity != null) {
            ContractVo contractVo = BeanMapper.map(entity, ContractVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<ContractDetailEntity> purchaseDetailss = detailsService.queryList(queryParam, false);
            if(purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for(ContractDetailEntity cdEntity:purchaseDetailss){
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                    cdEntity.setRowState("edit");
                }
                //List<ContractDetailVo> purchaseDetailsVos = BeanMapper.mapList(purchaseDetailss, ContractDetailVo.class);
                List<ContractDetailVo> resultMapList = BeanMapper.mapList(purchaseDetailss, ContractDetailVo.class);
                //实现排序
                Collections.sort(resultMapList,new ContractDetailComparatorVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
                //contractVo.setDetailsList(purchaseDetailsVos);
            }

            QueryParam query = new QueryParam();
            query.getParams().put("contractId", new Parameter(QueryParam.EQ, contractVo.getId()));
            query.getOrderMap().put("createTime", "asc");
            List<ContractClauseEntity> clauses = clauseService.queryList(query, false);
            if(clauses != null && clauses.size() > 0) {
                List<ContractClauseVo> clauseVoList = BeanMapper.mapList(clauses, ContractClauseVo.class);
                contractVo.setClauseList(clauseVoList);
            }
            return contractVo;
        }
        return null;
    }

    @Override
    public void deleteContract(List<ContractVo> vos) {
        for(ContractVo vo:vos) {
            detailsService.deleteByContractId(vo.getId());
            clauseService.deleteByContractId(vo.getId());
            contractMapper.deleteById(vo.getId());
            
        }
    }

//    @Override
//    public void updateEntity(ContractEntity contractEntity) {
//        super.updateById(contractEntity);
//    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
//        String originalAmount = resp.get("originalAmount").toString();
//        String curAmount = resp.get("curAmount").toString();
//        resp.put("originalAmount",originalAmount);
//        resp.put("curAmount",curAmount);
        return resp;
    }

    /**
     * 获取合同签订时间
     * @param id
     * @return
     */
    @Override
    public Date getSignDate(Long id) {
        return contractMapper.getSignDate(id);
    }
    // 回写累计收款
    @Override
    public void updateCollectMny(Long contractId, BigDecimal collectMny, Boolean type) {
        ContractEntity contractEntity = super.selectById(contractId);
        BigDecimal sumCollectMny = contractEntity.getSumCollectMny()==null?BigDecimal.ZERO:contractEntity.getSumCollectMny();
        if(type){
            sumCollectMny = sumCollectMny.add(collectMny);
        }else{
            sumCollectMny = sumCollectMny.subtract(collectMny);
        }
        contractEntity.setSumCollectMny(sumCollectMny);
        super.updateById(contractEntity);
    }
    // 回写累计开票
    @Override
    public void updateInvoicingMny(Long contractId,BigDecimal invoicingTaxMny, BigDecimal invoicingMny, Boolean type) {
        ContractEntity contractEntity = super.selectById(contractId);
        BigDecimal sumInvoicingMny = contractEntity.getSumInvoicingMny()==null?BigDecimal.ZERO:contractEntity.getSumInvoicingMny();
        if(type){
            sumInvoicingMny = sumInvoicingMny.add(invoicingMny);
        }else{
            sumInvoicingMny = sumInvoicingMny.subtract(invoicingMny);
        }
        BigDecimal sumInvoicingTaxMny = contractEntity.getSumInvoicingTaxMny()==null?BigDecimal.ZERO:contractEntity.getSumInvoicingTaxMny();
        if(type){
            sumInvoicingTaxMny = sumInvoicingTaxMny.add(invoicingTaxMny);
        }else{
            sumInvoicingTaxMny = sumInvoicingTaxMny.subtract(invoicingTaxMny);
        }
        contractEntity.setSumInvoicingTaxMny(sumInvoicingTaxMny);
        contractEntity.setSumInvoicingMny(sumInvoicingMny);
        super.updateById(contractEntity);
    }
    // 根据项目主键查询最新创建的合同
    @Override
    public ContractVo searchContract(Long projectId) {
        ContractVo contractVo=contractMapper.searchContract(projectId);
        return contractVo;
    }
    // 工程收款
    @Override
    public ContractEntity queryFinanceHistory(Long id) {
        ContractEntity contractEntity = baseMapper.selectById(id);
        CommonResponse<SumReceiveVO> sumReceiveVOList = receiveManageApi.getSumReceiveVOList(id);
        if(sumReceiveVOList.isSuccess()) {
            contractEntity.setReceiveVOList(sumReceiveVOList.getData().getReceiveVOList());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return contractEntity;
    }
    // 开票登记
    @Override
    public InvoiceOpenRecordVO queryTaxHistory(Long id) {
        ContractEntity contractEntity = baseMapper.selectById(id);
        CommonResponse<InvoiceOpenRecordVO> invoiceOpenRecord = invoiceApi.getInvoiceOpenRecord(id);
        if(invoiceOpenRecord.isSuccess()) {
            InvoiceOpenRecordVO data = invoiceOpenRecord.getData();
            data.setContractTaxMny(contractEntity.getContractTaxMny());
            return data;
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
    }

    @Override
    public ContractVo contractDetail(Long id) {
        ContractEntity entity = contractMapper.selectById(id);
        ContractVo contractVo = BeanMapper.map(entity, ContractVo.class);

        ContractVo vo = new ContractVo();
        vo.setId(contractVo.getId());
        vo.setContractName(contractVo.getContractName());
        vo.setContractTaxMny(contractVo.getContractTaxMny());
        vo.setTaxRate(contractVo.getTaxRate());
        vo.setProjectId(contractVo.getProjectId());
        vo.setProjectName(contractVo.getProjectName());
        vo.setCustomerId(contractVo.getCustomerId());
        vo.setCustomerName(contractVo.getCustomerName());
        vo.setContractorUnit(contractVo.getContractorUnit());
        vo.setContractorUnitName(contractVo.getContractorUnitName());
        vo.setOrgId(contractVo.getOrgId());
        vo.setOrgName(contractVo.getOrgName());
        vo.setVersion(contractVo.getVersion());
        return vo;
    }

    @Override
    public CommonResponse<Map<String,BigDecimal>> capitalCount(Integer range,List<Long> orgIds) {
        String year =null;
        if(range==2){//年累
            year = Calendar.getInstance().get(Calendar.YEAR)+"";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        String a = "";
        for(Long idd:orgIds){
            a=a+","+idd;
        }
        System.out.println(a);
        // 资金统计需求（老需求） 
        BigDecimal inContractMoney=contractMapper.inContractMoney(range,year,orgIds,tenantId);//收入合同金额
        BigDecimal totalReceiveMoney=contractMapper.totalReceiveMoney(range,year,orgIds,tenantId);//累计收款
        BigDecimal outContractMoney=contractMapper.outContractMoney(range,year,orgIds,tenantId);//支出合同金额
        BigDecimal totalSettleMoney=contractMapper.totalSettleMoney(range,year,orgIds,tenantId);//累计结算金额
        BigDecimal totalOutMoney=contractMapper.totalOutMoney(range,year,orgIds,tenantId);//累计支出

        Map<String,BigDecimal> map=new HashMap<>();
        map.put("inContractMoney",inContractMoney);
        map.put("totalReceiveMoney",totalReceiveMoney);
        map.put("outContractMoney",outContractMoney);
        map.put("totalSettleMoney",totalSettleMoney);
        map.put("totalOutMoney",totalOutMoney);
        map.put("bookMoney",totalReceiveMoney.subtract(totalOutMoney));

        
        return CommonResponse.success("查询数据成功！", map);
    }

    @Override
    public CommonResponse<List<Map>> getproject(List<Long> orgIds) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map> map=contractMapper.getproject(orgIds,tenantId);
        return CommonResponse.success("查询数据成功！", map);
    }

    @Override
    public CommonResponse<Map> getprogress(Long projectId) {
        Map map=contractMapper.getProjectDetail(projectId);
        Map Datemap=contractMapper.getProjectDate(projectId);
        SimpleDateFormat fm = new SimpleDateFormat("yyy-MM-dd");
        String now = fm.format(new Date());
        String start=null;
        String end=null;
        if(Datemap!=null){
            if(Datemap.get("endDate")!=null){
                end=fm.format((Date)Datemap.get("endDate"));
            }
            if(Datemap.get("startDate")!=null){
                start= fm.format((Date)Datemap.get("startDate"));
            }
        }
        map.put("startDate",start);
        map.put("endDate",end);
        map.put("customerName",map.get("customerName"));
        map.put("projectState",map.get("projectState"));
        if(StringUtils.isNotEmpty(end)&&StringUtils.isNotEmpty(start)){
            //当当前日期超过竣工日期时，此值为100%
            if(subtractDay(now,end)>=0){
                map.put("dateProgress","100%");
            }else {
                //当当前日期小于开工日期时，此值为0%
                int a=subtractDay(now,start);
                if(a<=0){
                    map.put("dateProgress","0%");
                }else{
                    int b=subtractDay(end,start);
                    int c=a*100 / b;
                    map.put("dateProgress",c+"%");
                }
            }
        }else{//开竣工日期有一方未定义时候，此值返回为0%
            map.put("dateProgress","0%");
        }
        BigDecimal outputMoney=contractMapper.outputMoney(projectId);
        BigDecimal contractMoney=contractMapper.contractMoney(projectId);
        map.put("contractMoney",contractMoney);
        map.put("outputMoney",outputMoney);
        if(contractMoney.compareTo(BigDecimal.ZERO)==0){
            map.put("outputProgress","0%");
        }else{
            map.put("outputProgress",outputMoney.divide(contractMoney,8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100")).setScale(0,BigDecimal.ROUND_HALF_UP)+"%");
        }
        //查询项目成员
        CommonResponse<List<Map<String, Object>>>  membersResp = userApi.getEmployeeList((Long)map.get("projectDepartmentId"));
        if(!membersResp.isSuccess()) {
            throw new BusinessException("查询失败，获取项目成员失败。");
        }
        map.put("managerNum",membersResp.getData().size());

        return CommonResponse.success("查询数据成功！", map);
    }

    @Override
    public CommonResponse<List<List<Map>>> costCount(Integer range, List<Long> orgIds) {
        String year =null;
        if(range==2){//年累
            year = Calendar.getInstance().get(Calendar.YEAR)+"";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<Map> list = contractMapper.costCount(range,year,orgIds,tenantId);

        BigDecimal totalCostMny = BigDecimal.ZERO;
        for (Map map : list) {
            if (!map.get("name").equals("借款报销")) {
                BigDecimal mny = (BigDecimal) map.get("value");
                totalCostMny = ComputeUtil.safeAdd(mny, totalCostMny);
            }
        }

        ArrayList<Map> mnyList = new ArrayList<>();
        Map<String, BigDecimal> map = new HashMap<>();
        map.put("totalCostMny", totalCostMny);
        mnyList.add(map);

        list = list.stream().filter(i -> !i.get("name").equals("借款报销")).collect(Collectors.toList());

        List<List<Map>> resultList = new ArrayList<>();
        resultList.add(list);
        resultList.add(mnyList);

        return CommonResponse.success("查询数据成功！", resultList);
    }

    @Override
    public CommonResponse<JSONObject> projectCount(String range,String name, List<Long> orgIds) {
//                allProjectNumber:总项目数,
//                allContractMoney:总合同额,
//                allInMoney:总收入,
//                allOutMoney:总支出,
//                bookMoney:账面资金 =总收入-总支出；
        Long tenantId = InvocationInfoProxy.getTenantid();
        String year = Calendar.getInstance().get(Calendar.YEAR)+"";
        List<ProjectCountVO> list=contractMapper.projectCount(range,year,orgIds,tenantId);
        List<Long> ids=new ArrayList<>();
        BigDecimal allContractMoney=BigDecimal.ZERO;
        Set<String> provinceSet=new HashSet<>();
        Set<String> citySet=new HashSet<>();
        Set<String> countySet=new HashSet<>();
        String pname = null;
        for(ProjectCountVO vo:list){
            ids.add(vo.getId());
            BigDecimal contractTaxMny = vo.getContractTaxMny() == null?BigDecimal.ZERO:vo.getContractTaxMny();
            allContractMoney=allContractMoney.add(contractTaxMny);
            if(StringUtils.isNotEmpty(vo.getArea())){
                if(vo.getArea().equals("台湾省")){
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                }else{
                    Map<String, String> areaMmap = addressResolution(vo.getArea());
                    if(areaMmap!=null){
                        String province=areaMmap.get("province")==null?"其他":areaMmap.get("province");
                        String city=areaMmap.get("city")==null?"其他":areaMmap.get("city");
                        String county=areaMmap.get("county")==null?"其他":areaMmap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);

                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);

                        if(StringUtils.isNotBlank(name) && city.equals(name)){
                            pname = province;
                        }
                    }else{
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");

                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            }else{
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");

                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }

        }

        String rangeType=null;
        List<ProjectDataVO> dataVOS=new ArrayList<>();

        if(StringUtils.isNotBlank(name)){
            if(provinceSet.contains(name)){// 如果选择省
                rangeType = getProvincePinYin(name);
                dataVOS = projectCountByName(name,list,0);
            }else if(citySet.contains(name)){
                rangeType = getProvincePinYin(pname) + "-" + getNamePinYinChar(name,1);
                dataVOS = projectCountByName(name,list,1);
            }

        }else{

            if(provinceSet.size()==1){//同一省份
                if(citySet.size() == 1){// 如果是同一市
                    rangeType=getProvincePinYin(provinceSet.iterator().next()) + "-" + getNamePinYinChar(citySet.iterator().next(),1);
                    Map<String,ProjectDataVO> countyMap=new HashMap<>();
                    for(ProjectCountVO vo:list){
                        String county = vo.getCounty();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null?BigDecimal.ZERO:vo.getContractTaxMny();
                        if(!countyMap.containsKey(county)){
                            ProjectDataVO pvo=new ProjectDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            countyMap.put(county,pvo);
                        }else {
                            ProjectDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue()+1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            countyMap.put(county,projectDataVO);
                        }
                    }
                    dataVOS=new ArrayList<ProjectDataVO>(countyMap.values());
                }else{
                    rangeType=getProvincePinYin(provinceSet.iterator().next());
                    Map<String,ProjectDataVO> cityMap=new HashMap<>();
                    for(ProjectCountVO vo:list){
                        String city = vo.getCity();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null?BigDecimal.ZERO:vo.getContractTaxMny();
                        if(!cityMap.containsKey(city)){
                            ProjectDataVO pvo=new ProjectDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            cityMap.put(city,pvo);
                        }else {
                            ProjectDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue()+1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            cityMap.put(city,projectDataVO);
                        }
                    }
                    dataVOS=new ArrayList<ProjectDataVO>(cityMap.values());
                }

            }else {//不同省份
                rangeType="China";
                Map<String,ProjectDataVO> provinceMap=new HashMap<>();
                for(ProjectCountVO vo:list){
                    String province = vo.getProvince();
                    BigDecimal contractTaxMny = vo.getContractTaxMny() == null?BigDecimal.ZERO:vo.getContractTaxMny();
                    if(!provinceMap.containsKey(province)){
                        ProjectDataVO pvo=new ProjectDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        pvo.setContractMoney(contractTaxMny);
                        provinceMap.put(province,pvo);
                    }else {
                        ProjectDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue()+1);
                        projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                        provinceMap.put(province,projectDataVO);
                    }
                }
                dataVOS=new ArrayList<ProjectDataVO>(provinceMap.values());
            }
        }

        int allProjectNumber=list.size();
        BigDecimal allInMoney=ids.size()>0?contractMapper.allInMoney(ids):BigDecimal.ZERO;//总收入
        BigDecimal allOutMoney=ids.size()>0?contractMapper.allOutMoney(ids):BigDecimal.ZERO;//总收入
        BigDecimal bookMoney=allInMoney.subtract(allOutMoney);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", allProjectNumber);
        jsonObject.put("allContractMoney", allContractMoney);
        jsonObject.put("allInMoney", allInMoney);
        jsonObject.put("allOutMoney", allOutMoney);
        jsonObject.put("bookMoney", bookMoney);
        jsonObject.put("data", dataVOS);
        jsonObject.put("range", rangeType==null?"China":rangeType);

        return CommonResponse.success("查询数据成功！", jsonObject);
    }
    // type:0-省，1-市
    private List<ProjectDataVO> projectCountByName(String name,List<ProjectCountVO> list,Integer type){
        List<ProjectDataVO> dataVOS=new ArrayList<>();
        Map<String,ProjectDataVO> map=new HashMap<>();
        for(ProjectCountVO vo : list){
            String voName = null;
            String childrenName = null;
            if(type == 0){
                voName = vo.getProvince();
                childrenName = vo.getCity();
            }else{
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if(voName.equals(name)){
                BigDecimal contractTaxMny = vo.getContractTaxMny() == null?BigDecimal.ZERO:vo.getContractTaxMny();
                if(!map.containsKey(childrenName)){
                    ProjectDataVO pvo=new ProjectDataVO();
                    pvo.setName(childrenName);
                    pvo.setValue(1);
                    pvo.setContractMoney(contractTaxMny);
                    map.put(childrenName,pvo);
                }else {
                    ProjectDataVO projectDataVO = map.get(childrenName);
                    projectDataVO.setValue(projectDataVO.getValue()+1);
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    map.put(childrenName,projectDataVO);
                }
            }
        }
        return new ArrayList<ProjectDataVO>(map.values());

    }

    @Override
    public IPage<ProjectInOutVO> proPageList(Map<String, Object> params) {
        Object orgIds = params.get("orgIds");
        if(orgIds == null){
            return new Page<>();
        }
        List<ProjectInOutVO> voList = new ArrayList<>();
        IPage<ProjectInOutVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(params.get("pageIndex").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));

        long total = contractMapper.count(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }

        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() -  1) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = contractMapper.getList(params);
        page.setRecords(voList);
        return page;
    }

    @Override
    public List<Map<String, Object>> incomeMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.incomeMnyWarn(sqlParamList);
    }

    @Override
    public List<IncomeContractWarnVo> outIncomeMnyWarn(List<Long> tenantIds) {
        return baseMapper.outIncomeMnyWarn(tenantIds);
    }

    @Override
    public List<FinanceMnyVo> queryFinanceMny(Integer range, List<Long> orgIds) {
        String year = null;
        if (range == 2) {//年累
            year = Calendar.getInstance().get(Calendar.YEAR) + "";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();

        List<FinanceMnyVo> list = new ArrayList<>();

        // 财务数据（新需求）
        List<Map<String, BigDecimal>> quoteList = contractMapper.totalQuoteMoney(range, year, orgIds, tenantId); // 累计应收(验工计价含税金额)
        BigDecimal totalReceiveMoney = contractMapper.totalReceiveMoney(range, year, orgIds, tenantId); // 累计收款
        BigDecimal totalOutMoney = contractMapper.totalOutMoney(range, year, orgIds, tenantId); // 累计支出
        // 财务数据map
        Map<String, BigDecimal> financeMap = new HashMap<>();
        BigDecimal totalQuoteTaxMoney = ListUtil.isNotEmpty(quoteList) ? quoteList.get(0).get("totalQuoteTaxMoney") : BigDecimal.ZERO;
        //累计借款
        BigDecimal totalLoadApplyMoney=contractMapper.totalLoadApplyMoney(range, year, orgIds, tenantId);
        //累计还款
        BigDecimal totalLoadBackMoney=contractMapper.totalLoadBackMoney(range, year, orgIds, tenantId);
        //借款余额
        BigDecimal totalLoadMoney=ComputeUtil.safeSub(totalLoadApplyMoney, totalLoadBackMoney);
        
        BigDecimal totalMny=ComputeUtil.safeSub(totalReceiveMoney, totalOutMoney);
        
        totalMny=totalMny.add(totalLoadMoney);
        
        financeMap.put("累计应收", totalQuoteTaxMoney); // 累计应收
        financeMap.put("累计收款", totalReceiveMoney); // 累计收款
        financeMap.put("累计应收未收", ComputeUtil.safeSub(totalQuoteTaxMoney, totalReceiveMoney)); // 累计应收未收
        financeMap.put("累计支出", totalOutMoney); // 累计支出
//        financeMap.put("累计借款",totalLoadApplyMoney);
//        financeMap.put("累计还款",totalLoadBackMoney);
        financeMap.put("借款余额",totalLoadMoney);
        financeMap.put("账面金额",totalMny); // 账面金额

        for (Map.Entry<String, BigDecimal> entry : financeMap.entrySet()) {
            FinanceMnyVo vo = new FinanceMnyVo();
            vo.setName(entry.getKey());
            vo.setTaxMny(entry.getValue());
            list.add(vo);
        }

        // 排序
        list = list.stream().sorted(Comparator.comparing(FinanceMnyVo::getTaxMny).reversed()).collect(Collectors.toList());

        return list;
    }

    @Override
    public Map<String,BigDecimal> queryEconomyMny(Integer range, List<Long> orgIds) {
        String year = null;
        if (range == 2) {//年累
            year = Calendar.getInstance().get(Calendar.YEAR) + "";
        }
        Long tenantId = InvocationInfoProxy.getTenantid();

        CommonResponse<List<ProjectRegisterVO>> projectResponse = iProjectApi.queryChildrenProjectByOrgId(InvocationInfoProxy.getOrgId());
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("查询项目列表失败！");
        }
        List<Long> projectIds = new ArrayList<>();
        if (ListUtil.isNotEmpty(projectResponse.getData())) {
            projectIds = projectResponse.getData().stream().map(ProjectRegisterVO::getId).collect(Collectors.toList());
        }

        // 经济数据（新需求）
        List<Map<String, BigDecimal>> quoteList = contractMapper.totalQuoteMoney(range, year, orgIds, tenantId); // 累计应收(验工计价含税金额)
        BigDecimal totalProductionMoney = contractMapper.totalProductionMoney(range, year, orgIds, tenantId); // 累计产值
        BigDecimal totalCostMoney = contractMapper.totalCostMoney(range, year, ListUtil.isNotEmpty(projectIds) ? projectIds : null, tenantId); // 累计成本


        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<OrgVO> orgResponse = orgApi.detailById(orgId);
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("查询当前组织详情失败！");
        }
        OrgVO orgVO = orgResponse.getData();
        BigDecimal bidProfitRate = BigDecimal.ZERO;
        List<Map<String, BigDecimal>> planList = new ArrayList<>();
        if (orgVO.getOrgType() == 5) {
            bidProfitRate = contractMapper.bidProfitRateByProject(range, year, orgId, tenantId); // 投标利润率
            planList = contractMapper.planRate(range, year, null, tenantId, projectIds.get(0)); // 累计应收(验工计价含税金额)
        }else {
            bidProfitRate = contractMapper.bidProfitRate(range, year, orgIds, tenantId); // 投标利润率
            planList = contractMapper.planRate(range, year, orgIds, tenantId, null); // 累计应收(验工计价含税金额)
        }

        if (ListUtil.isNotEmpty(planList)) {
            Map<String, BigDecimal> map = planList.get(0);
            for (Map.Entry<String, BigDecimal> entry : map.entrySet()) {
                String key = entry.getKey();
                BigDecimal value = entry.getValue();
                if (value.equals(new BigDecimal("0E-8")) || value.equals(new BigDecimal("0E-12"))) {
                    planList.get(0).put(key, BigDecimal.ZERO);
                }
            }
        }
        // 经济数据map
        Map<String, BigDecimal> economyMap = new HashMap<>();
        economyMap.put("totalProductionMoney", totalProductionMoney); // 累计产值
        economyMap.put("totalQuoteMoney", ListUtil.isNotEmpty(quoteList) ? quoteList.get(0).get("totalQuoteMoney") : BigDecimal.ZERO); // 累计验工计价(无税)
        BigDecimal currentProfit = ComputeUtil.safeSub(totalProductionMoney, totalCostMoney);
        economyMap.put("currentProfit", currentProfit); // 当前利润
        economyMap.put("bidProfitRate", bidProfitRate); // 投标利润率
        economyMap.put("guaranteeTargetRate", ListUtil.isNotEmpty(planList) ? planList.get(0).get("guaranteeTargetRate") : BigDecimal.ZERO); // 确保目标利润率
        economyMap.put("accomplishTargetRate", ListUtil.isNotEmpty(planList) ? planList.get(0).get("accomplishTargetRate") : BigDecimal.ZERO); // 达标目标利润率
        economyMap.put("challengeTargetRate", ListUtil.isNotEmpty(planList) ? planList.get(0).get("challengeTargetRate") : BigDecimal.ZERO); // 挑战目标利润率
        economyMap.put("currentProfitRate", ComputeUtil.safeMultiply(ComputeUtil.safeDiv(currentProfit, totalProductionMoney), new BigDecimal("100"))); // 当前利润率

        return economyMap;
    }

    @Override
    public Long queryContractByProject(Long projectId) {
        LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractEntity::getProjectId, projectId);
        wrapper.eq(ContractEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.eq(ContractEntity::getSupplementFlag, 0);
        wrapper.orderByDesc(BaseEntity::getCreateTime);

        List<ContractEntity> list = this.list(wrapper);
        Long id = null;
        if (ListUtil.isNotEmpty(list)) {
            id = list.get(0).getId();
        }

        return id;
    }

    //日期相减得到天数
    public static int subtractDay(String date1, String date2) {
        int rs = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date start = simpleDateFormat.parse(date1);
            Date end = simpleDateFormat.parse(date2);
            long sss = (start.getTime() - end.getTime()) / 1000;
            rs = (int) sss / (60 * 60 * 24);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

	@Override
	public void updateContractIsSupplementFlag(Long id) {
		ContractEntity contractEntity = baseMapper.selectById(id);
        LambdaQueryWrapper<SupplementEntity> lambda = Wrappers.<SupplementEntity>lambdaQuery();
        lambda.eq(SupplementEntity::getMainContractId, id);
        lambda.orderByDesc(SupplementEntity::getSignDate);
        List<SupplementEntity> entities = supplementService.list(lambda);
        if(entities.size()>0) {
        	contractEntity.setIsSupplement("1");
        }else {
        	contractEntity.setIsSupplement("0");
        }
        baseMapper.updateById(contractEntity);
	}
}
