package com.ejianc.business.income.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 甲方报量
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@TableName("ejc_income_quote")
public class QuoteEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 报量时间
     */
    @TableField("quote_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date quoteDate;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 本期结算金额（含税）
     */
    @TableField("quote_tax_mny")
    private BigDecimal quoteTaxMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 本期结算金额（不含税）
     */
    @TableField("quote_mny")
    private BigDecimal quoteMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_quote_mny")
    private BigDecimal sumQuoteMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 合同金额(含税)
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;
    /**
     * 累计结算比例
     */
    @TableField("sum_quote_rate")
    private BigDecimal sumQuoteRate;

    @TableField(value="sum_quote_mny_have_this")
    private BigDecimal sumQuoteMnyHaveThis; // 累计结算金额(含本期)
    @TableField(value="sum_quote_tax_mny_have_this")
    private BigDecimal sumQuoteTaxMnyHaveThis; // 累计结算金额(含本期)
    @TableField(value="sum_quote_rate_have_this")
    private BigDecimal sumQuoteRateHaveThis; // 累计结算比例(含本期)

    @TableField(value="total_receive_tax_mny")
    private BigDecimal totalReceiveTaxMny; // 含本期累计收款金额
    @TableField(value="total_contract_receive_tax_mny")
    private BigDecimal totalContractReceiveTaxMny; // 合同含本期累计收款金额
    @TableField("memo")
    private String memo;



    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;
    @TableField(exist = false)
    @SubEntity(serviceName = "QuoteDetailService", pidName = "quoteId")
    private List<QuoteDetailEntity> checkList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "QuoteClaimService", pidName = "quoteId")
    private List<QuoteClaimEntity> claimList = new ArrayList<>();
    @TableField(exist = false)
    @SubEntity(serviceName = "QuoteOtherService", pidName = "quoteId")
    private List<QuoteOtherEntity> otherList = new ArrayList<>();

    public BigDecimal getSumQuoteMnyHaveThis() {
        return sumQuoteMnyHaveThis;
    }

    public void setSumQuoteMnyHaveThis(BigDecimal sumQuoteMnyHaveThis) {
        this.sumQuoteMnyHaveThis = sumQuoteMnyHaveThis;
    }

    public BigDecimal getSumQuoteTaxMnyHaveThis() {
        return sumQuoteTaxMnyHaveThis;
    }

    public void setSumQuoteTaxMnyHaveThis(BigDecimal sumQuoteTaxMnyHaveThis) {
        this.sumQuoteTaxMnyHaveThis = sumQuoteTaxMnyHaveThis;
    }

    public BigDecimal getSumQuoteRateHaveThis() {
        return sumQuoteRateHaveThis;
    }

    public void setSumQuoteRateHaveThis(BigDecimal sumQuoteRateHaveThis) {
        this.sumQuoteRateHaveThis = sumQuoteRateHaveThis;
    }

    public BigDecimal getSumQuoteRate() {
        return sumQuoteRate;
    }

    public void setSumQuoteRate(BigDecimal sumQuoteRate) {
        this.sumQuoteRate = sumQuoteRate;
    }

    public List<QuoteDetailEntity> getCheckList() {
        return checkList;
    }

    public void setCheckList(List<QuoteDetailEntity> checkList) {
        this.checkList = checkList;
    }

    public List<QuoteClaimEntity> getClaimList() {
        return claimList;
    }

    public void setClaimList(List<QuoteClaimEntity> claimList) {
        this.claimList = claimList;
    }

    public List<QuoteOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<QuoteOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Date getQuoteDate() {
        return quoteDate;
    }

    public void setQuoteDate(Date quoteDate) {
        this.quoteDate = quoteDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public BigDecimal getQuoteTaxMny() {
        return quoteTaxMny;
    }

    public void setQuoteTaxMny(BigDecimal quoteTaxMny) {
        this.quoteTaxMny = quoteTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getQuoteMny() {
        return quoteMny;
    }

    public void setQuoteMny(BigDecimal quoteMny) {
        this.quoteMny = quoteMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public String toString() {
        return "QuoteEntity{" +
                "projectId=" + projectId +
                ", orgId=" + orgId +
                ", billCode=" + billCode +
                ", contractId=" + contractId +
                ", quoteDate=" + quoteDate +
                ", employeeId=" + employeeId +
                ", quoteTaxMny=" + quoteTaxMny +
                ", taxRate=" + taxRate +
                ", taxMny=" + taxMny +
                ", quoteMny=" + quoteMny +
                ", sumQuoteMny=" + sumQuoteMny +
                ", sumQuoteTaxMny=" + sumQuoteTaxMny +
                ", billState=" + billState +
                ", contractName=" + contractName +
                ", projectName=" + projectName +
                ", employeeName=" + employeeName +
                ", contractMny=" + contractMny +
                ", contractTaxMny=" + contractTaxMny +
                ", orgName=" + orgName +
                "}";
    }

    public BigDecimal getTotalReceiveTaxMny() {
        return totalReceiveTaxMny;
    }

    public void setTotalReceiveTaxMny(BigDecimal totalReceiveTaxMny) {
        this.totalReceiveTaxMny = totalReceiveTaxMny;
    }

    public BigDecimal getTotalContractReceiveTaxMny() {
        return totalContractReceiveTaxMny;
    }

    public void setTotalContractReceiveTaxMny(BigDecimal totalContractReceiveTaxMny) {
        this.totalContractReceiveTaxMny = totalContractReceiveTaxMny;
    }
}
