package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.DeductionVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.income.mapper.DeductionMapper;
import com.ejianc.business.income.bean.DeductionEntity;
import com.ejianc.business.income.service.IDeductionService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 甲方扣款服务实现类
 * 
 * @author xuannl
 * 
 */
@Service("deductionService")
public class DeductionServiceImpl extends BaseServiceImpl<DeductionMapper, DeductionEntity> implements IDeductionService{

    @Autowired
    private DeductionMapper deductionMapper;

    public BigDecimal getSumMoney(Long projectId,Long contractId){
        if(null == contractId){
            return deductionMapper.getSumMoney(projectId);
        }
        return deductionMapper.getSumMoney(projectId,contractId);
    }
}
