package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.mapper.ReportMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.EJCDateUtil;
import com.ejianc.business.income.utils.MonthUtil;
import com.ejianc.business.income.vo.comparator.MonthComparatorVo;
import com.ejianc.business.income.vo.comparator.ReportComparatorVo;
import com.ejianc.business.income.vo.report.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class ReportServiceImpl extends BaseServiceImpl<ReportMapper, ContractEntity> implements IReportService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ReportMapper reportMapper;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IQuoteService quoteService;

    @Override
    public JSONObject pageList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();//第几页
        int pageSize = param.getPageSize();//一页多少条
        Map<String, Parameter> params = param.getParams();//入参
        String beginTime = "";
        String endTime = "";
        if (params.get("occTime") == null) {
            Date date = new Date();
            //DateFormat yearformat = new SimpleDateFormat("yyyy");
            DateFormat monthformat = new SimpleDateFormat("yyyy-MM");
            //不带日期查询最近三年的数据
            beginTime = (EJCDateUtil.getYear() - 3) + "-01-01";
            endTime = monthformat.format(date) + "-31";
        } else {
            String occTime = (String) params.get("occTime").getValue();
            String[] split = occTime.split(",");
//            beginTime = split[0];
//            endTime = split[1];
            beginTime = split[0].substring(0, 7) + "-01";
            endTime = split[1].substring(0, 7) + "-31";
        }
        String projectManager = params.get("projectManager") == null ? null : (String) params.get("projectManager").getValue();//项目经理
        String engineeringType = params.get("engineeringType") == null ? null : (String) params.get("engineeringType").getValue();//工程类型
        String text = param.getSearchText();
        List<Long> orgids = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        int total = 0;//总条数
        int current = pageIndex;//第几页
        int size = pageSize;//一页几条
        int pages = 0;//有几页

        // 查询所有的
        List<ReportVo> reportList = new ArrayList<>();
        if (orgids != null && orgids.size() > 0) {
            reportList = reportMapper.getFinance(tenantId, endTime, projectManager, engineeringType, text, orgids);
        }
        //日期区间的
        List<ReportVo> reportVos = dateInterval(reportList, beginTime);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        if (reportVos == null || reportVos.size() < 1) {
            page.put("records", new ArrayList<ReportVo>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }
        //排序，日期倒序
        Collections.sort(reportVos, new ReportComparatorVo());

        total = reportVos.size();
        if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        // 要查第几页
        //要查的这一页有几条数据
        int num = 0;
        if ((current - 1) * size + size > total) {
            num = total - ((current - 1) * size);
        } else {
            num = size;
        }
        List<ReportVo> reportVoList = new ArrayList<>();//最终要返回的数据，但是缺少一些参数值
        Set<Long> contractIds = new HashSet<>();//为了查询累计产值和累计批量
        Map<Long, Set<String>> cidTimeMap = new HashMap<>();//key:ContractId,value:ConfirmTime集合
        for (int i = (current - 1) * size; i < (current - 1) * size + num; i++) {
            ReportVo reportVo = reportVos.get(i);

            contractIds.add(reportVo.getContractId());

            if (cidTimeMap.containsKey(reportVo.getContractId())) {
                Set<String> ctime = cidTimeMap.get(reportVo.getContractId());
                ctime.add(reportVo.getConfirmTime());
                cidTimeMap.put(reportVo.getContractId(), ctime);
            } else {
                Set<String> ctime = new HashSet<>();
                ctime.add(reportVo.getConfirmTime());
                cidTimeMap.put(reportVo.getContractId(), ctime);
            }

            reportVoList.add(reportVo);
        }

        List<ReportSumVo> proSumList = new ArrayList<>();//产值统计
        List<ReportSumVo> quoSumList = new ArrayList<>();;//甲方批量

        if(CollectionUtils.isNotEmpty(contractIds)){
            proSumList = reportMapper.getProductionMny(contractIds, endTime);//产值统计
            quoSumList = reportMapper.getQuoteMny(contractIds, endTime);//甲方批量
        }


        Map<String, BigDecimal> receiveMny = getSumReceiveMny(reportList, cidTimeMap);//累计回款
        Map<String, BigDecimal> proFinishMny = getFinishMny(proSumList, cidTimeMap);//累计产值
        Map<String, BigDecimal> quoFinishMny = getFinishMny(quoSumList, cidTimeMap);//累计批量

        for (ReportVo vo : reportVoList) {
            // 累计产值
            BigDecimal sumProductionTaxMny = proFinishMny.get(vo.getContractId() + vo.getConfirmTime());
            // 累计批量
            BigDecimal sumQuoteTaxMny = quoFinishMny.get(vo.getContractId() + vo.getConfirmTime());
            // 累计回款
            BigDecimal sumReceiveMny = receiveMny.get(vo.getContractId() + vo.getConfirmTime());

            BigDecimal contractTaxMny = vo.getContractTaxMny();

            // 本次回款比例=回款金额/合同金额
            BigDecimal receiveMnyRate = ComputeUtil.bigDecimalPercent(vo.getReceiveMny(), contractTaxMny, 2);
            // 累计回款比例=累计回款金额/合同金额
            BigDecimal sumReceiveMnyRate = ComputeUtil.bigDecimalPercent(sumReceiveMny, contractTaxMny, 2);

            vo.setSumProductionTaxMny(sumProductionTaxMny);
            vo.setSumQuoteTaxMny(sumQuoteTaxMny);
            vo.setSumReceiveMny(sumReceiveMny);
            vo.setReceiveMnyRate(receiveMnyRate);
            vo.setSumReceiveMnyRate(sumReceiveMnyRate);
        }

        page.put("records", reportVoList);
        page.put("total", total);
        page.put("current", current);
        page.put("size", size);
        page.put("pages", pages);
        return page;
    }

    @Override
    public JSONObject monthPageList(QueryParam param) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        int pageIndex = param.getPageIndex();//第几页
        int pageSize = param.getPageSize();//一页多少条
        Map<String, Parameter> params = param.getParams();//入参
        String beginTime = "";
        String endTime = "";
        if (params.get("occTime") == null) {
            Date date = new Date();
            DateFormat yearformat = new SimpleDateFormat("yyyy");
            DateFormat monthformat = new SimpleDateFormat("yyyy-MM");
            beginTime = yearformat.format(date) + "-01";
            endTime = monthformat.format(date);
        } else {
            String occTime = (String) params.get("occTime").getValue();
            String[] split = occTime.split(",");
//            beginTime = split[0];
//            endTime = split[1];
            beginTime = split[0].substring(0, 7);
            endTime = split[1].substring(0, 7);
        }
        String projectManager = params.get("projectManager") == null ? null : (String) params.get("projectManager").getValue();//项目经理
        String engineeringType = params.get("engineeringType") == null ? null : (String) params.get("engineeringType").getValue();//工程类型
        Integer monthRule = 1;//月度规则，0-自然月，1-固定日期，默认固定日期
        Integer monthTime = 25;//月结束日期，下拉1-26，默认25
        if (params.get("monthRule") != null && params.get("monthRule").getValue() != null) {
            monthRule = Integer.parseInt((String) params.get("monthRule").getValue());
        }
        if (params.get("monthTime") != null && params.get("monthTime").getValue() != null) {
            monthTime = Integer.parseInt((String) params.get("monthTime").getValue());
        }
        String text = param.getSearchText();
        List<Long> orgids = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        int total = 0;//总条数
        int current = pageIndex;//第几页
        int size = pageSize;//一页几条
        int pages = 0;//有几页

        //查询所有权限下项目
        List<ReportMonthVo> reportVos = reportMapper.getProjectMonth(tenantId, projectManager, engineeringType, text, orgids);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        if (reportVos == null || reportVos.size() < 1) {
            page.put("records", new ArrayList<ReportMonthVo>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }

        //月度规则
        Integer lastDay = 0;
        if (monthRule == 1) {//固定日期
            lastDay = monthTime + 1;
        } else {
            lastDay = 32;
        }
        String lastTime = endTime + "-" + lastDay;

        Map<Long, ReportMonthVo> proMap = new HashMap<>();
        List<Long> projectIds = new ArrayList<>();
        for (ReportMonthVo vo : reportVos) {
            projectIds.add(vo.getProjectId());
            proMap.put(vo.getProjectId(), vo);
        }
        //查月度产值和月度成本，并且过滤掉同时为0的
        List<ReportSumVo> pcList = reportMapper.getProductionAndCost(lastTime, lastDay, projectIds);
        //查询收款
        List<ReportSumVo> skList = reportMapper.getReceive(tenantId, lastTime, lastDay, projectIds);
        List<ReportMonthVo> allList = new ArrayList<>();
        for (ReportSumVo rsvo : pcList) {
            if ((rsvo.getProductionMny() != null && rsvo.getProductionMny().compareTo(BigDecimal.ZERO) != 0) ||
                    (rsvo.getFinishMny() != null && rsvo.getFinishMny().compareTo(BigDecimal.ZERO) != 0)) {
                rsvo.setProductionMny(rsvo.getProductionMny() == null ? BigDecimal.ZERO : rsvo.getProductionMny());
                rsvo.setFinishMny(rsvo.getFinishMny() == null ? BigDecimal.ZERO : rsvo.getFinishMny());
                // 只查询在统计期间的
                if (indexTime(rsvo.getOccurDate(), beginTime, endTime)) {
                    ReportMonthVo rv = BeanMapper.map(proMap.get(rsvo.getRid()), ReportMonthVo.class);
                    rv.setCountMonth(rsvo.getOccurDate());//统计日期
                    rv.setMonthProductionTaxMny(rsvo.getProductionMny());//月度产值
                    rv.setMonthCostMny(rsvo.getFinishMny());// 月度成本
                    rv.setMonthProfit(rsvo.getProductionMny().subtract(rsvo.getFinishMny()));// 月度利润
                    if (rsvo.getProductionMny() == null || rsvo.getProductionMny().compareTo(BigDecimal.ZERO) == 0) {
                        rv.setMonthProfitRate(BigDecimal.ZERO);
                    } else {
                        BigDecimal monthProfitRate = rv.getMonthProfit().divide(rsvo.getProductionMny(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                        if (monthProfitRate.compareTo(BigDecimal.ZERO) > 0 && monthProfitRate.compareTo(new BigDecimal("0.01")) < 0
                                && monthProfitRate.compareTo(new BigDecimal("-0.01")) > 0) {
                            monthProfitRate = new BigDecimal("0.01");
                        }
                        rv.setMonthProfitRate(monthProfitRate);
                    }
                    allList.add(rv);
                }
            }
        }
        //统计期间可能没有数据
        if (allList == null || allList.size() < 1) {
            page.put("records", new ArrayList<ReportMonthVo>());
            page.put("total", total);
            page.put("current", current);
            page.put("size", size);
            page.put("pages", pages);
            return page;
        }
        //排序，取查询部分
        Collections.sort(allList, new MonthComparatorVo());

        total = allList.size();
        if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        // 要查第几页
        //要查的这一页有几条数据
        int num = 0;
        if ((current - 1) * size + size > total) {
            num = total - ((current - 1) * size);
        } else {
            num = size;
        }

        List<ReportMonthVo> responseList = new ArrayList<>();
        Map<Long, Set<String>> cidTimeMap = new HashMap<>();//key:projectId,value:年月集合
        for (int i = (current - 1) * size; i < (current - 1) * size + num; i++) {
            ReportMonthVo rmVo = allList.get(i);
            if (cidTimeMap.containsKey(rmVo.getProjectId())) {
                Set<String> ctime = cidTimeMap.get(rmVo.getProjectId());
                ctime.add(rmVo.getCountMonth());
                cidTimeMap.put(rmVo.getProjectId(), ctime);
            } else {
                Set<String> ctime = new HashSet<>();
                ctime.add(rmVo.getCountMonth());
                cidTimeMap.put(rmVo.getProjectId(), ctime);
            }
            responseList.add(rmVo);
        }
        Map<String, BigDecimal> skFinishMny = getFinishMny(skList, cidTimeMap);//累计收款
        Map<String, BigDecimal> chanzhiMap = new HashMap<>();//累计产值
        Map<String, BigDecimal> chengbenMap = new HashMap<>();//累计成本
        Map<String, BigDecimal> chanzhiYear = new HashMap<>();//年度产值
        Map<String, BigDecimal> chengbenYear = new HashMap<>();//年度成本
        for (ReportSumVo vo : pcList) {
            if (cidTimeMap.containsKey(vo.getRid())) {//目标数据的合同主键相同
                Set<String> ctimeList = cidTimeMap.get(vo.getRid());
                for (String ctime : ctimeList) {
                    if (MonthUtil.compareTime(ctime, vo.getOccurDate()) >= 0) {//该日期小于目标数据的日期，金额累加
                        //累计产值
                        if (chanzhiMap.containsKey(vo.getRid() + ctime)) {
                            BigDecimal add = ComputeUtil.safeAdd(chanzhiMap.get(vo.getRid() + ctime), vo.getProductionMny());
                            chanzhiMap.put(vo.getRid() + ctime, add);
                        } else {
                            chanzhiMap.put(vo.getRid() + ctime, vo.getProductionMny());
                        }
                        //累计成本
                        if (chengbenMap.containsKey(vo.getRid() + ctime)) {
                            BigDecimal add = ComputeUtil.safeAdd(chengbenMap.get(vo.getRid() + ctime), vo.getFinishMny());
                            chengbenMap.put(vo.getRid() + ctime, add);
                        } else {
                            chengbenMap.put(vo.getRid() + ctime, vo.getFinishMny());
                        }
                    }
                    if (indexTime(vo.getOccurDate(), firstMonth(ctime), ctime)) {
                        //年度产值
                        if (chanzhiYear.containsKey(vo.getRid() + ctime)) {
                            BigDecimal add = ComputeUtil.safeAdd(chanzhiYear.get(vo.getRid() + ctime), vo.getProductionMny());
                            chanzhiYear.put(vo.getRid() + ctime, add);
                        } else {
                            chanzhiYear.put(vo.getRid() + ctime, vo.getProductionMny());
                        }
                        //年度成本
                        if (chengbenYear.containsKey(vo.getRid() + ctime)) {
                            BigDecimal add = ComputeUtil.safeAdd(chengbenYear.get(vo.getRid() + ctime), vo.getFinishMny());
                            chengbenYear.put(vo.getRid() + ctime, add);
                        } else {
                            chengbenYear.put(vo.getRid() + ctime, vo.getFinishMny());
                        }
                    }
                }
            }
        }

        for (ReportMonthVo vo : responseList) {
            String ctime = vo.getProjectId() + vo.getCountMonth();
            BigDecimal sumReceiveMny = skFinishMny.get(ctime);// 累计收款
            BigDecimal yearProductionTaxMny = chanzhiYear.get(ctime);// 本年产值
            BigDecimal yearCostMny = chengbenYear.get(ctime);// 本年成本
            BigDecimal yearProfit = ComputeUtil.safeSub(yearProductionTaxMny, yearCostMny);// 本年利润
            BigDecimal yearProfitRate = BigDecimal.ZERO;// 本年利润lv
            if (ComputeUtil.isNotEmpty(yearProductionTaxMny)) {
                yearProfitRate = ComputeUtil.safeDiv(yearProfit, yearProductionTaxMny).multiply(new BigDecimal(100));
                if (yearProfitRate.compareTo(BigDecimal.ZERO) > 0 && yearProfitRate.compareTo(new BigDecimal("0.01")) < 0
                        && yearProfitRate.compareTo(new BigDecimal("-0.01")) > 0) {
                    yearProfitRate = new BigDecimal("0.01");
                }
            }
            BigDecimal sumProductionTaxMny = chanzhiMap.get(ctime);// 累计产值
            BigDecimal sumCostMny = chengbenMap.get(ctime);// 累计成本
            BigDecimal sumProfit = ComputeUtil.safeSub(sumProductionTaxMny, sumCostMny);// 累计利润
            BigDecimal sumProfitRate = BigDecimal.ZERO;// 累计利润lv
            if (ComputeUtil.isNotEmpty(sumProductionTaxMny)) {
                sumProfitRate = ComputeUtil.safeDiv(sumProfit, sumProductionTaxMny).multiply(new BigDecimal(100));
                if (sumProfitRate.compareTo(BigDecimal.ZERO) != 0 && sumProfitRate.compareTo(new BigDecimal("0.01")) < 0
                        && sumProfitRate.compareTo(new BigDecimal("-0.01")) > 0) {
                    sumProfitRate = new BigDecimal("0.01");
                }
            }
            vo.setSumReceiveMny(sumReceiveMny);
            vo.setYearProductionTaxMny(yearProductionTaxMny);
            vo.setYearCostMny(yearCostMny);
            vo.setYearProfit(yearProfit);
            vo.setYearProfitRate(yearProfitRate);
            vo.setSumProductionTaxMny(sumProductionTaxMny);
            vo.setSumCostMny(sumCostMny);
            vo.setSumProfit(sumProfit);
            vo.setSumProfitRate(sumProfitRate);
        }
        page.put("records", responseList);
        page.put("total", total);
        page.put("current", current);
        page.put("size", size);
        page.put("pages", pages);
        return page;
    }


    @Override
    public ProjectReportVo projectMonth(Long projectId, Integer lastDay) {
        return baseMapper.getDate(projectId, lastDay);
    }

    @Override
    public BigDecimal sumContractMny(Long projectId) {
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, projectId);
        lambda.eq(ContractEntity::getDr, 0);
        lambda.in(ContractEntity::getBillState, billStatus);
        List<ContractEntity> entities = super.list(lambda);
        for (ContractEntity ce : entities) {
            contractTaxMny = contractTaxMny.add(ce.getContractTaxMny());
        }
        return contractTaxMny;
    }

    @Override
    public List<ProjectReportVo> getMonthProductionMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthProductionMny(projectId, lastDay);
    }

    @Override
    public IncomeReportMnyVo getIncomeMny(Long projectId) {
        BigDecimal contractAmount = BigDecimal.ZERO;//合同金额
        BigDecimal visaAmount = BigDecimal.ZERO;//签证金额
        BigDecimal outputAmount = BigDecimal.ZERO;//产值金额
        BigDecimal batchAmount = BigDecimal.ZERO;//批量金额
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<ContractEntity> lambda = Wrappers.<ContractEntity>lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, projectId);
        lambda.eq(ContractEntity::getDr, 0);
        lambda.in(ContractEntity::getBillState, billStatus);
        List<ContractEntity> entities = super.list(lambda);
        for (ContractEntity ce : entities) {
            contractAmount = contractAmount.add(ce.getContractTaxMny());
        }
        LambdaQueryWrapper<ClaimEntity> lambda2 = Wrappers.<ClaimEntity>lambdaQuery();
        lambda2.eq(ClaimEntity::getProjectId, projectId);
        lambda2.eq(ClaimEntity::getDr, 0);
        lambda2.in(ClaimEntity::getBillState, billStatus);
        List<ClaimEntity> claimEntities = claimService.list(lambda2);
        for (ClaimEntity ce : claimEntities) {
            visaAmount = visaAmount.add(ce.getReplyMny());
        }
        LambdaQueryWrapper<ProductionEntity> lambda3 = Wrappers.<ProductionEntity>lambdaQuery();
        lambda3.eq(ProductionEntity::getProjectId, projectId);
        lambda3.eq(ProductionEntity::getDr, 0);
        lambda3.in(ProductionEntity::getBillState, billStatus);
        List<ProductionEntity> productionEntities = productionService.list(lambda3);
        for (ProductionEntity ce : productionEntities) {
            outputAmount = outputAmount.add(ce.getFinishTaxMny());
        }
        LambdaQueryWrapper<QuoteEntity> lambda4 = Wrappers.<QuoteEntity>lambdaQuery();
        lambda4.eq(QuoteEntity::getProjectId, projectId);
        lambda4.eq(QuoteEntity::getDr, 0);
        lambda4.in(QuoteEntity::getBillState, billStatus);
        List<QuoteEntity> quoteEntities = quoteService.list(lambda4);
        for (QuoteEntity ce : quoteEntities) {
            batchAmount = batchAmount.add(ce.getQuoteTaxMny());
        }
        IncomeReportMnyVo incomeReportMnyVo = new IncomeReportMnyVo();
        incomeReportMnyVo.setContractAmount(contractAmount);
        incomeReportMnyVo.setContractQuantity(entities.size());
        incomeReportMnyVo.setVisaAmount(visaAmount);
        incomeReportMnyVo.setVisasNumber(claimEntities.size());
        incomeReportMnyVo.setOutputAmount(outputAmount);
        incomeReportMnyVo.setOutputNumber(productionEntities.size());
        incomeReportMnyVo.setBatchAmount(batchAmount);
        incomeReportMnyVo.setBatchNumber(quoteEntities.size());
        return incomeReportMnyVo;
    }

    @Override
    public List<ProjectReportVo> getMonthProduction(Long projectId) {
        return baseMapper.getMonthProduction(projectId);
    }



    //查询大于开始日期的数据
    private List<ReportVo> dateInterval(List<ReportVo> reportList, String beginTime) {
        List<ReportVo> list = new ArrayList<>();
        Integer startTime = Integer.parseInt(beginTime.replaceAll("-", ""));
        for (ReportVo vo : reportList) {
            if (Integer.parseInt(vo.getConfirmTime().replaceAll("-", "")) >= startTime) {
                list.add(vo);
            }
        }
        return list;
    }

    // 比较日期大小,如2020-10-23格式
//    private int compareTime(String t1, String t2) {
//        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
//        int trr2 = Integer.parseInt(t2.replaceAll("-", ""));
//        if (trr1 > trr2) {
//            return 1;
//        } else if (trr1 < trr2) {
//            return -1;
//        }
//        return 0;
//    }

    // t1是否在日期t2t3之间
    private boolean indexTime(String t1, String t2, String t3) {
        int trr1 = Integer.parseInt(t1.replaceAll("-", ""));
        int trr2 = Integer.parseInt(t2.replaceAll("-", ""));
        int trr3 = Integer.parseInt(t3.replaceAll("-", ""));
        if (trr1 >= trr2 && trr1 <= trr3) {
            return true;
        } else {
            return false;
        }
    }

    // 获取当年的一月2020-01
    private String firstMonth(String t1) {
        return t1.substring(0, 5) + "01";
    }

    /**
     * 获取对应合同和日期条件下的累计回款金额
     *
     * @param reportList 全部数据
     * @param cidTimeMap key:ContractId,value:日期集合
     * @return
     */
    private Map<String, BigDecimal> getSumReceiveMny(List<ReportVo> reportList, Map<Long, Set<String>> cidTimeMap) {
        Map<String, BigDecimal> map = new HashMap<>();
        for (ReportVo vo : reportList) {
            if (cidTimeMap.containsKey(vo.getContractId())) {//目标数据的合同主键相同
                Set<String> ctimeList = cidTimeMap.get(vo.getContractId());
                for (String ctime : ctimeList) {
                    if (MonthUtil.compareTime(ctime, vo.getConfirmTime()) >= 0) {//该日期小于目标数据的日期，金额累加
                        if (map.containsKey(vo.getContractId() + ctime)) {
                            BigDecimal add = map.get(vo.getContractId() + ctime).add(vo.getReceiveMny());
                            map.put(vo.getContractId() + ctime, add);
                        } else {
                            map.put(vo.getContractId() + ctime, vo.getReceiveMny());
                        }
                    }
                }
            }
        }
        return map;
    }

    /**
     * 获取对应合同和日期条件下的累计金额
     *
     * @param reportList 全部数据
     * @param cidTimeMap key:ContractId,value:日期集合
     * @return
     */
    private Map<String, BigDecimal> getFinishMny(List<ReportSumVo> reportList, Map<Long, Set<String>> cidTimeMap) {
        Map<String, BigDecimal> map = new HashMap<>();
        for (ReportSumVo vo : reportList) {
            if (cidTimeMap.containsKey(vo.getRid())) {//目标数据的合同主键相同
                Set<String> ctimeList = cidTimeMap.get(vo.getRid());
                for (String ctime : ctimeList) {
//                    if (MonthUtil.compareTime(ctime, vo.getOccurDate()) >= 0) {//该日期小于目标数据的日期，金额累加
                        if (map.containsKey(vo.getRid() + ctime)) {
                            BigDecimal add = map.get(vo.getRid() + ctime).add(vo.getFinishMny() == null ? BigDecimal.ZERO : vo.getFinishMny());
                            map.put(vo.getRid() + ctime, add);
                        } else {
                            map.put(vo.getRid() + ctime, vo.getFinishMny() == null ? BigDecimal.ZERO : vo.getFinishMny());
                        }
//                    }
                }
            }
        }
        return map;
    }

    @Override
    public List<ProjectMnyVO> queryProjectMnyList( Page<ProjectMnyVO> page,QueryWrapper wrapper) {
        return reportMapper.queryProjectMnyList(page,wrapper);
    }


}
