package com.ejianc.business.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 竣工结算实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_contract_finish_settle")
public class ContractFinishSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_id")
    private Long contractId; // 合同
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="customer_id")
    private Long customerId; // 合同甲方
    @TableField(value="contractor_unit")
    private Long contractorUnit; // 合同乙方
    @TableField(value="customer_name")
    private String customerName; // 合同甲方名称
    @TableField(value="contractor_unit_name")
    private String contractorUnitName; // 合同乙方名称
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="sign_date")
    private Date signDate; // 合同签约日期
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="quality_assurance_mny")
    private BigDecimal qualityAssuranceMny; // 合同约定质保金
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值报量
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值报量
    @TableField(value="sum_quote_tax_mny")
    private BigDecimal sumQuoteTaxMny; // 累计甲方报量（含税）
    @TableField(value="sum_quote_mny")
    private BigDecimal sumQuoteMny; // 累计甲方报量
    @TableField(value="sum_invoicing_tax_mny")
    private BigDecimal sumInvoicingTaxMny; // 累计开票（含税）
    @TableField(value="sum_invoicing_mny")
    private BigDecimal sumInvoicingMny; // 累计开票
    @TableField(value="sum_collect_mny")
    private BigDecimal sumCollectMny; // 累计收款
    @TableField(value="sum_claim_mny")
    private BigDecimal sumClaimMny; // 累计变更洽商
    @TableField(value="sum_receive_quality_assurance_mny")
    private BigDecimal sumReceiveQualityAssuranceMny; // 已收质保金
    @TableField(value="end_settle_mny")
    private BigDecimal endSettleMny; // 竣工结算金额
    @TableField(value="quality_assurance_mny_ratio")
    private Double qualityAssuranceMnyRatio; // 质保金比例
    @TableField(value="end_date")
    private Date endDate; // 竣工结算日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_department")
    private String employeeDepartment; // 经办人部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="warranty_amount")
    private BigDecimal warrantyAmount; // 质保金额
    @TableField(value="amount_owed_receivable")
    private BigDecimal amountOwedReceivable; // 应收欠收金额

    /**
     * 推送凭证标识
     */
    @TableField("voucher_flag")
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    @TableField("voucher_info")
    private String voucherInfo;


    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public Long getContractorUnit() {
        return contractorUnit;
    }

    public BigDecimal getWarrantyAmount() {
        return warrantyAmount;
    }

    public void setWarrantyAmount(BigDecimal warrantyAmount) {
        this.warrantyAmount = warrantyAmount;
    }

    public BigDecimal getAmountOwedReceivable() {
        return amountOwedReceivable;
    }

    public void setAmountOwedReceivable(BigDecimal amountOwedReceivable) {
        this.amountOwedReceivable = amountOwedReceivable;
    }

    public void setContractorUnit(Long contractorUnit) {
        this.contractorUnit = contractorUnit;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getQualityAssuranceMny() {
        return qualityAssuranceMny;
    }

    public void setQualityAssuranceMny(BigDecimal qualityAssuranceMny) {
        this.qualityAssuranceMny = qualityAssuranceMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumQuoteTaxMny() {
        return sumQuoteTaxMny;
    }

    public void setSumQuoteTaxMny(BigDecimal sumQuoteTaxMny) {
        this.sumQuoteTaxMny = sumQuoteTaxMny;
    }
    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }
    public BigDecimal getSumInvoicingTaxMny() {
        return sumInvoicingTaxMny;
    }

    public void setSumInvoicingTaxMny(BigDecimal sumInvoicingTaxMny) {
        this.sumInvoicingTaxMny = sumInvoicingTaxMny;
    }
    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    public BigDecimal getSumClaimMny() {
        return sumClaimMny;
    }

    public void setSumClaimMny(BigDecimal sumClaimMny) {
        this.sumClaimMny = sumClaimMny;
    }
    public BigDecimal getSumReceiveQualityAssuranceMny() {
        return sumReceiveQualityAssuranceMny;
    }

    public void setSumReceiveQualityAssuranceMny(BigDecimal sumReceiveQualityAssuranceMny) {
        this.sumReceiveQualityAssuranceMny = sumReceiveQualityAssuranceMny;
    }
    public BigDecimal getEndSettleMny() {
        return endSettleMny;
    }

    public void setEndSettleMny(BigDecimal endSettleMny) {
        this.endSettleMny = endSettleMny;
    }
    public Double getQualityAssuranceMnyRatio() {
        return qualityAssuranceMnyRatio;
    }

    public void setQualityAssuranceMnyRatio(Double qualityAssuranceMnyRatio) {
        this.qualityAssuranceMnyRatio = qualityAssuranceMnyRatio;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeDepartment() {
        return employeeDepartment;
    }

    public void setEmployeeDepartment(String employeeDepartment) {
        this.employeeDepartment = employeeDepartment;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
