package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service("change")
public class ContractChangeBpmService implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private IChangeClauseService changeClauseService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IHistoryService historyService;
    @Autowired
    private IHistoryDetailService historyDetailService;
    @Autowired
    private IHistoryClauseService historyClauseService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state,String billTypeCode) {
        //变更表
        ChangeEntity entity = changeService.selectById(billId);
        //合同主表
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());

        //同步原合同到记录表
        HistoryEntity historyEntity = BeanMapper.map(contractEntity, HistoryEntity.class);
        historyEntity.setContractId(entity.getContractId());//原合同主键
        //变更原因
        historyEntity.setChangeReason(entity.getChangeReason());
        historyEntity.setId(null);
        historyService.saveOrUpdate(historyEntity,false);

        //同步原清单到记录表
        QueryParam deparm = new QueryParam();
        deparm.getParams().put("contractId", new Parameter(QueryParam.EQ, contractEntity.getId()));
        List<ContractDetailEntity> checkList = contractDetailService.queryList(deparm,false);
        if(null!=checkList&&checkList.size()>0){
            List<HistoryDetailEntity> historyDetails = BeanMapper.mapList(checkList, HistoryDetailEntity.class);
            for(HistoryDetailEntity hde:historyDetails){
                hde.setHistoryId(historyEntity.getId());//记录表主键
                hde.setContractId(entity.getContractId());//原合同主键
                hde.setContractBid(hde.getId());//原合同子表主键
                hde.setId(null);
            }
            historyDetailService.saveOrUpdateBatch(historyDetails,historyDetails.size(),false);
        }

        //同步原条款到记录表
        List<ContractClauseEntity> clauseList = contractClauseService.queryList(deparm,false);
        if(null!=clauseList&&clauseList.size()>0){
            List<HistoryClauseEntity> historyClauses = BeanMapper.mapList(clauseList, HistoryClauseEntity.class);
            for(HistoryClauseEntity hce:historyClauses){
                hce.setHistoryId(historyEntity.getId());//记录表主键
                hce.setContractId(entity.getContractId());//原合同主键
                hce.setContractBid(hce.getId());//原合同子表主键
                hce.setId(null);
            }
            historyClauseService.saveOrUpdateBatch(historyClauses,historyClauses.size(),false);
        }

        //回写合同主表

        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());//变更后金额变为变更前金额
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());//变更后金额变为变更前金额
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());//变更中金额变为变更后金额
        contractEntity.setContractMny(contractEntity.getChangingMny());//变更中金额变为变更后金额
        contractEntity.setChangingTaxMny(null);//变更中金额清空
        contractEntity.setChangingMny(null);//变更中金额清空
        contractEntity.setChangeStatus(3);//状态改为已变更
        contractEntity.setChangeCode(contractEntity.getChangeCode());
        contractEntity.setChangeId(contractEntity.getChangeId());
        contractEntity.setBillState(contractEntity.getBillState());
        contractEntity.setSumProductionTaxMny(contractEntity.getSumProductionTaxMny());
        contractEntity.setSumProductionMny(contractEntity.getSumProductionMny());
        contractEntity.setSumQuoteTaxMny(contractEntity.getSumQuoteTaxMny());
        contractEntity.setSumQuoteMny(contractEntity.getSumQuoteMny());
        contractEntity.setSumCollectMny(contractEntity.getSumCollectMny());
        contractEntity.setSumInvoicingTaxMny(contractEntity.getSumInvoicingTaxMny());
        contractEntity.setSumInvoicingMny(contractEntity.getSumInvoicingMny());

        contractEntity.setProjectId(entity.getProjectId());
        contractEntity.setProjectName(entity.getProjectName());
        contractEntity.setContractName(entity.getContractName());
        contractEntity.setBillCode(entity.getBillCode());
        contractEntity.setOrgId(entity.getOrgId());
        contractEntity.setOrgName(entity.getOrgName());
        contractEntity.setContractStatus(entity.getContractStatus());
        contractEntity.setCustomerId(entity.getCustomerId());
        contractEntity.setCustomerName(entity.getCustomerName());
        contractEntity.setContractorUnit(entity.getContractorUnit());
        contractEntity.setContractorUnitName(entity.getContractorUnitName());
        contractEntity.setType(entity.getType());
        contractEntity.setManageChargeRate(entity.getManageChargeRate());
        contractEntity.setTaxRate(entity.getTaxRate());
        contractEntity.setContractValuationType(entity.getContractValuationType());
        contractEntity.setSignDate(entity.getSignDate());
        contractEntity.setStartDate(entity.getStartDate());
        contractEntity.setEndDate(entity.getEndDate());
        contractEntity.setTerm(entity.getTerm());
        contractEntity.setEmployeeId(entity.getEmployeeId());
        contractEntity.setEmployeeName(entity.getEmployeeName());
        contractEntity.setMemo(entity.getMemo());
        contractEntity.setTaxMny(entity.getTaxMny());

        contractEntity.setChangeReason(entity.getChangeReason());

        contractEntity.setChangeVersion(entity.getChangeVersion());

        contractEntity.setProjectManager(entity.getProjectManager());
        contractEntity.setProjectManagerName(entity.getProjectManagerName());
        contractEntity.setProjectOwner(entity.getProjectOwner());
        contractEntity.setOtherPartyManager(entity.getOtherPartyManager());
        contractEntity.setOtherPartyManagerPhone(entity.getOtherPartyManagerPhone());
        contractEntity.setContractType(entity.getContractType());
        contractEntity.setContractTypeName(entity.getContractTypeName());
        contractEntity.setFloatFlag(entity.getFloatFlag());//合同是否浮动单价
        contractService.saveOrUpdate(contractEntity);

        //回写原合同清单表
        contractDetailService.deleteByContractId(entity.getContractId());
        QueryParam parm = new QueryParam();
        parm.getParams().put("changeId", new Parameter(QueryParam.EQ, entity.getId()));
        List<ChangeDetailEntity> changeDetailList = changeDetailService.queryList(parm, false);
//        List<ChangeDetailEntity> changeDetailList = entity.getCheckList();
        if(null!=changeDetailList&&changeDetailList.size()>0){
            List<ContractDetailEntity> detailList=new ArrayList<>();
            for(ChangeDetailEntity cde:changeDetailList){
                ContractDetailEntity cdetail = BeanMapper.map(cde, ContractDetailEntity.class);
                cdetail.setId(null);
                cdetail.setChangeBid(cde.getId());
                //变更类型如果是中止，不能改类型
                if(null==cdetail.getChangeType()||cdetail.getChangeType()!=5){
                    cdetail.setChangeType(0);
                }

                detailList.add(cdetail);
            }
            contractDetailService.saveOrUpdateBatch(detailList,detailList.size(),false);
            //维护父子关系
            Map<Long,Long> parentMap =new HashMap<>();
            for(ContractDetailEntity cde:detailList){
                parentMap.put(cde.getChangeBid(),cde.getId());
            }
            for(ContractDetailEntity cde:detailList){
                if(cde.getParentId() != null && cde.getParentId() > 0 ){
                    cde.setParentId(parentMap.get(cde.getParentId()));
                }
            }
            contractDetailService.saveOrUpdateBatch(detailList,detailList.size(),false);
        }

        //回写原合同条款表
//        QueryParam parm = new QueryParam();
//        parm.getParams().put("changeId", new Parameter(QueryParam.EQ, entity.getId()));
        List<ChangeClauseEntity> changeClauseList = changeClauseService.queryList(parm, false);
//        List<ChangeClauseEntity> changeClauseList = entity.getClauseList();
        contractClauseService.remove(new QueryWrapper<ContractClauseEntity>().eq("contract_id",entity.getContractId()),false);
        if(null!=changeClauseList&&changeClauseList.size()>0){
            List<ContractClauseEntity> contractClauses = BeanMapper.mapList(changeClauseList, ContractClauseEntity.class);
            for(ContractClauseEntity cce:contractClauses){
                cce.setChangeId(cce.getChangeId());
                cce.setChangeBid(cce.getId());
                cce.setId(null);
            }
            contractClauseService.saveOrUpdateBatch(contractClauses,contractClauses.size(),false);
        }
        //entity.setBillState();
        entity.setUsedTime(new Date());
        entity.setBeforeContractName(contractEntity.getContractName());
        changeService.saveOrUpdate(entity,false);
        //变更合同附件复制到主合同
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId),"BT200605000000002","incomeContractBill",String.valueOf(contractEntity.getId()),"BT200528000000002","incomeContractBill");
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        return CommonResponse.error("合同变更单暂不支持回退功能!");
    }
}
