package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ContractFinishSettleEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.service.IContractFinishSettleService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("contractFinishSettle") 
public class ContractFinishSettleBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractService contractService;

	@Autowired
	private IContractFinishSettleService service;

	@Autowired
	private HttpServletRequest request;

	// 是否推送凭证
	private static final String VOUCHER_PARAM = "P-h5UC6769";

	@Autowired
	private IParamConfigApi paramConfigApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		ContractFinishSettleEntity entity = service.selectById(billId);
		this.writeBackContractFinsishFlag(entity, Boolean.FALSE);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ContractFinishSettleEntity entity = service.selectById(billId);
		this.writeBackContractFinsishFlag(entity, Boolean.TRUE);

		// 推送凭证
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
		if (byCode.isSuccess() && null != byCode.getData()) {
			ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
			String valueData = paramRegisterSetVO.getValueData();
			Long projectId = entity.getProjectId();
			if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
				ExecutorService threadPool = Executors.newFixedThreadPool(1);
				String authority = request.getHeader("authority");
				if (authority == null) {
					logger.info("request-authority为空");
					authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
				}
				try {
					Callable<CommonResponse> voucherCallable = new VoucherCallable(true, entity, RequestContextHolder.getRequestAttributes(), authority);
					threadPool.submit(voucherCallable);
				} catch (Exception e) {
					logger.error("产值进度推送凭证异常, ", e);
				} finally {
					threadPool.shutdown();
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ContractFinishSettleEntity entity = service.selectById(billId);
		this.writeBackContractFinsishFlag(entity, Boolean.FALSE);

		//更新凭证恢复到初始态
		if (!VoucherFlag.NO_NEED.equals(entity.getVoucherFlag())) {
			//有凭证则删除
			ExecutorService threadPool = Executors.newFixedThreadPool(1);
			String authority = request.getHeader("authority");
			if (authority == null) {
				logger.info("request-authority为空");
				authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
			}
			try {
				Callable<CommonResponse> voucherCallable = new VoucherCallable(false, entity, RequestContextHolder.getRequestAttributes(), authority);
				threadPool.submit(voucherCallable);
			} catch (Exception e) {
				logger.error("产值进度撤回凭证异常, ", e);
			} finally {
				threadPool.shutdown();
			}
		}
		return CommonResponse.success();
	}

	class VoucherCallable implements Callable<CommonResponse> {

		private ContractFinishSettleEntity entity;
		private boolean isGenerate;
		private RequestAttributes context;
		private String authority;

		public VoucherCallable(boolean isGenerate, ContractFinishSettleEntity entity, RequestAttributes context, String authority) {
			this.entity = entity;
			this.isGenerate = isGenerate;
			this.context = context;
			this.authority = authority;
		}

		@Override
		public CommonResponse call() {
			logger.info("--------------{}--voucher线程开始-------{}---------", this.getClass(), isGenerate);
			RequestContextHolder.setRequestAttributes(context);
			InvocationInfoProxy.setExtendAttribute("authority", authority);
			service.handleVoucher(entity, isGenerate);
			logger.info("--------------{}--voucher线程结束-------{}---------", this.getClass(), isGenerate);
			return null;
		}
	}

	/**
	 * 回写合同完工状态
	 *
	 * @param
	 * @param
	 */
	private void writeBackContractFinsishFlag(ContractFinishSettleEntity contractFinishSettleEntity, Boolean finishFlag) {
		LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		//根据完工状态回写合同状态，合同状态3已封账，2履约中
		updateWrapper.set(ContractEntity::getContractStatus, finishFlag ? "3" : "2");
		updateWrapper.eq(ContractEntity::getId, contractFinishSettleEntity.getContractId());
		ContractEntity contractEntity = contractService.getById(contractFinishSettleEntity.getContractId());
		contractService.update(contractEntity, updateWrapper, false);
	}

}
