package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ContractFinishSettleVO;
import com.ejianc.business.income.vo.FinishHistoryVo;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.business.income.vo.report.ProjectMnyVO;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.income.mapper.ContractFinishSettleMapper;
import com.ejianc.business.income.bean.ContractFinishSettleEntity;
import com.ejianc.business.income.service.IContractFinishSettleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 竣工结算实体
 * 
 * @author generator
 * 
 */
@Service("contractFinishSettleService")
public class ContractFinishSettleServiceImpl extends BaseServiceImpl<ContractFinishSettleMapper, ContractFinishSettleEntity> implements IContractFinishSettleService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IVoucherApi voucherApi;

    @Autowired
    private ContractFinishSettleMapper contractFinishSettleMapper;
    @Autowired
    private IContractService contractService;
    @Override
    public ContractFinishSettleVO queryByContractId(Long contractId) {
        ContractFinishSettleVO resp = null;
        QueryWrapper<ContractFinishSettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        ContractFinishSettleEntity entity = contractFinishSettleMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, ContractFinishSettleVO.class);
        }
        return resp;
    }

    @Override
    public FinishHistoryVo queryFinishHistory(Long id) {
        QueryWrapper<ContractFinishSettleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", id);
        queryWrapper.orderByDesc( "create_time");
        List<ContractFinishSettleEntity> finishSettleEntities = contractFinishSettleMapper.selectList(queryWrapper);
        ContractEntity contractEntity = contractService.selectById(id);
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        FinishHistoryVo vo = new FinishHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractTaxMny);
        BigDecimal endSettleMny = finishSettleEntities.stream().filter(item -> item.getEndSettleMny() != null).map(ContractFinishSettleEntity::getEndSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setEndSettleMny(endSettleMny);
        vo.setFinishSettleVOList(BeanMapper.mapList(finishSettleEntities, ContractFinishSettleVO.class));
        return vo;
    }

    @Override
    public void handleVoucher(ContractFinishSettleEntity entity, boolean isGenerate) {
        if (isGenerate) {
            VoucherParams voucherParams = VoucherParams.newInstance("BT202308000001", entity.getOrgId(), entity.getBillCode(), entity, SystemCodeEnum.INCOME);
            CommonResponse<VoucherInfo> response = voucherApi.save(voucherParams);
            logger.info("推送凭证结果：" + DataConvertUtil.toPrettyFormat(response));
            LambdaUpdateWrapper<ContractFinishSettleEntity> lambda = new LambdaUpdateWrapper<>();
            lambda.eq(ContractFinishSettleEntity::getId, entity.getId());
            if (response.isSuccess()) {
                VoucherInfo voucherInfo = response.getData();
                lambda.set(ContractFinishSettleEntity::getVoucherInfo, DataConvertUtil.objToString(voucherInfo));
                lambda.set(ContractFinishSettleEntity::getVoucherFlag, voucherInfo.getVoucherFlag());
            } else {
                lambda.set(ContractFinishSettleEntity::getVoucherInfo, response.getMsg());
                lambda.set(ContractFinishSettleEntity::getVoucherFlag, VoucherFlag.FAILED);
            }
            this.update(lambda);
        } else {
            if (VoucherFlag.SUCCESS.equals(entity.getVoucherFlag())) {
                CommonResponse<String> response = voucherApi.del(JSONObject.parseObject(entity.getVoucherInfo(), VoucherInfo.class));
                logger.info("删除凭证结果：" + DataConvertUtil.toPrettyFormat(response));
                if (response.isSuccess()) {
                    LambdaUpdateWrapper<ContractFinishSettleEntity> lambda = new LambdaUpdateWrapper<>();
                    lambda.eq(ContractFinishSettleEntity::getId, entity.getId());
                    lambda.set(ContractFinishSettleEntity::getVoucherInfo, null);
                    lambda.set(ContractFinishSettleEntity::getVoucherFlag, 0);
                    this.update(lambda);
                }
            }

        }
    }
}
