package com.ejianc.business.income.service.impl;

import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionClaimService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("production")
public class ProductionBpmService implements ICommonBusinessService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionClaimService productionClaimService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;


    // 是否推送凭证
    private static final String VOUCHER_PARAM = "P-h5UC6769";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private HttpServletRequest request;


    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //回写主表
        ProductionEntity productionEntity = productionService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(productionEntity.getContractId());
        //本期完成产值（含税）
        BigDecimal finishTaxMny = productionEntity.getFinishTaxMny() == null ? BigDecimal.ZERO : productionEntity.getFinishTaxMny();
        //累计产值报量（含税）
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        //累加
        contractEntity.setSumProductionTaxMny(finishTaxMny.add(sumProductionTaxMny));

        //本期完成产值（不含税）
        BigDecimal finishMny = productionEntity.getFinishMny() == null ? BigDecimal.ZERO : productionEntity.getFinishMny();
        //累计产值报量（不含税）
        BigDecimal sumProductionMny = contractEntity.getSumProductionMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionMny();
        //累计产值报量（不含税）
        contractEntity.setSumProductionMny(finishMny.add(sumProductionMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter(QueryParam.EQ, productionEntity.getId()));
        List<ProductionClaimEntity> claimList = productionClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumProductionMny((ce.getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny())
                        .add(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }

        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(VOUCHER_PARAM);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            Long projectId = productionEntity.getProjectId();
            if (valueData.equals(String.valueOf(projectId)) || "是".equals(valueData)) {
                ExecutorService threadPool = Executors.newFixedThreadPool(1);
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    Callable<CommonResponse> productionVoucherCallable = new ProductionVoucherCallable(true, productionEntity, RequestContextHolder.getRequestAttributes(), authority);
                    threadPool.submit(productionVoucherCallable);
                } catch (Exception e) {
                    logger.error("产值进度推送凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }

            }
        }
        return CommonResponse.success();
    }

    class ProductionVoucherCallable implements Callable<CommonResponse> {

        private ProductionEntity productionEntity;
        private boolean isGenerate;
        private RequestAttributes context;
        private String authority;

        public ProductionVoucherCallable(boolean isGenerate, ProductionEntity productionEntity, RequestAttributes context, String authority) {
            this.productionEntity = productionEntity;
            this.isGenerate = isGenerate;
            this.context = context;
            this.authority = authority;
        }

        @Override
        public CommonResponse call() {
            logger.info("--------------voucher线程开始-------{}---------", isGenerate);
            RequestContextHolder.setRequestAttributes(context);
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            productionService.handleVoucher(productionEntity, isGenerate);
            logger.info("--------------voucher线程结束-------{}---------", isGenerate);
            return null;
        }
    }

    // 审批通过回退
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

        if(res.isSuccess()) {//单据未被下游单据引用
            callBackProduction(billId,state,billTypeCode);
            return CommonResponse.success();
        }else{
            return CommonResponse.error(res.getMsg());
        }
    }


    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ProductionEntity productionEntity = productionService.selectById(billId);
        //更新凭证恢复到初始态
        if (!VoucherFlag.NO_NEED.equals(productionEntity.getVoucherFlag())) {
            //有凭证则删除
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            String authority = request.getHeader("authority");
            if (authority == null) {
                logger.info("request-authority为空");
                authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
            }
            try {
                Callable<CommonResponse> productionVoucherCallable = new ProductionVoucherCallable(false, productionEntity, RequestContextHolder.getRequestAttributes(), authority);
                threadPool.submit(productionVoucherCallable);
            } catch (Exception e) {
                logger.error("产值进度撤回凭证异常, ", e);
            } finally {
                threadPool.shutdown();
            }
        }
        return CommonResponse.success();
    }

    // 撤回回写
    private void callBackProduction(Long billId, Integer state, String billTypeCode){

        //回写主表
        ProductionEntity productionEntity = productionService.selectById(billId);
        ContractEntity contractEntity = contractService.selectById(productionEntity.getContractId());
        //本期完成产值（含税）
        BigDecimal finishTaxMny = productionEntity.getFinishTaxMny() == null ? BigDecimal.ZERO : productionEntity.getFinishTaxMny();
        //累计产值报量（含税）
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        //累减
        contractEntity.setSumProductionTaxMny(sumProductionTaxMny.subtract(finishTaxMny));

        //本期完成产值（不含税）
        BigDecimal finishMny = productionEntity.getFinishMny() == null ? BigDecimal.ZERO : productionEntity.getFinishMny();
        //累计产值报量（不含税）
        BigDecimal sumProductionMny = contractEntity.getSumProductionMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionMny();
        //累计产值报量（不含税）
        contractEntity.setSumProductionMny(sumProductionMny.subtract(finishMny));

        contractService.updateById(contractEntity);

        //回写签证洽商索赔
        QueryParam parm = new QueryParam();
        parm.getParams().put("productionId", new Parameter(QueryParam.EQ, productionEntity.getId()));
        List<ProductionClaimEntity> claimList = productionClaimService.queryList(parm, false);

        if (null != claimList && claimList.size() > 0) {
            List<Long> ids = new ArrayList<>();
            Map<Long, BigDecimal> idMap = new HashMap<>();
            for (ProductionClaimEntity pce : claimList) {
                ids.add(pce.getClaimId());
                idMap.put(pce.getClaimId(), pce.getOccurMny());
            }

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<ClaimEntity> claimEntities = claimService.queryList(queryParam, false);
            for (ClaimEntity ce : claimEntities) {
                ce.setSumProductionMny((ce.getSumProductionMny() == null ? BigDecimal.ZERO : ce.getSumProductionMny())
                        .subtract(idMap.get(ce.getId()) == null ? BigDecimal.ZERO : idMap.get(ce.getId())));
            }
            claimService.updateBatchById(claimEntities);
        }
    }

}
