package com.ejianc.business.income.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.consts.ProjectSurveyEnum;
import com.ejianc.business.income.service.*;
import com.ejianc.business.income.utils.BigDecimalUtil;
import com.ejianc.business.income.utils.EJCDateUtil;
import com.ejianc.business.income.vo.ProjectInOutVO;
import com.ejianc.business.income.vo.QuoteDetailVo;
import com.ejianc.business.income.vo.report.FinanceUseResVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.tax.vo.InvoiceOpenRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * <p>
 * 施工合同表 前端控制器
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@RestController
@RequestMapping("/contract")
public class ContractController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static volatile HttpServletRequest request;
    private static final String imageUrl = "https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/999999/202102/1356430587925999617.png";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IQuoteService quoteService;
    @Value("${common.env.base-host}")
    public String BASE_HOST;

    @Autowired
    private SessionManager sessionManager;

    /**
     * 新增或编辑
     *
     * @param contractVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVo> saveOrUpdate(@RequestBody ContractVo contractVo) {
        CommonResponse<ContractVo> response = contractService.saveOrUpdate(contractVo);
        return response;
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVo> queryDetail(@RequestParam Long id) {
        ContractVo purchaseContractVo = contractService.queryDetail(id);
        if(CollectionUtils.isNotEmpty(purchaseContractVo.getCheckList())){
            //计算合同明细下的累计报量，累计报量金额，累计报量比例
            purchaseContractVo.getCheckList().forEach(contractDetailVo -> {
                Map<String,Object> map = new HashMap<>();
                map.put("code",contractDetailVo.getCode());
                map.put("name",contractDetailVo.getName());
                map.put("contractDetailId",contractDetailVo.getId());
                //根据合同清单id和名称 编码 查询报量明细
                QuoteDetailVo quoteDetailVo = quoteService.queryNumAndPriceSum(map);
                if(quoteDetailVo != null){
                    //累计报量
                    contractDetailVo.setQuoteNumSum(quoteDetailVo.getNumSum());
                    //累计报量金额
                    contractDetailVo.setQuotePriceSum(quoteDetailVo.getPriceSum());
                    //累计报量比例
                    contractDetailVo.setQuoteScaleSum(BigDecimalUtil.safeMultiply(BigDecimalUtil.safeDiv(quoteDetailVo.getNumSum(),quoteDetailVo.getNum()),new BigDecimal(100)));
                }
            });
        }
        return CommonResponse.success(purchaseContractVo);
    }


    /**
     * 删除
     *
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVo> vos) {
        contractService.deleteContract(vos);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、发包单位、承包单位、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (StringUtils.isNotEmpty(authOrgIds)){
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            param.getParams().put("orgId",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Object returnedMnyFlag = param.getParams().get("returnedMnyFlag") !=null ? param.getParams().get("returnedMnyFlag").getValue() : null;
        param.getParams().remove("returnedMnyFlag");
        //IPage<ContractEntity> pageData = contractService.queryPage(param, false);
        Page<ContractEntity> pageData = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if("1".equals(returnedMnyFlag)){
            wrapper.gt("sum_collect_mny",BigDecimal.ZERO);
        }
        if("0".equals(returnedMnyFlag)){
            wrapper.apply("(sum_collect_mny <= 0 or sum_collect_mny is null)");
        }
        IPage iPage = contractService.selectPage(pageData, wrapper);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = contractService.countContractAmount(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(iPage.getRecords(), ContractVo.class));
        page.put("total", iPage.getTotal());
        page.put("current", iPage.getCurrent());
        page.put("size", iPage.getSize());
        page.put("pages", iPage.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询汇总金额
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/sumMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> sumMny(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、发包单位、承包单位、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<ContractEntity> list = contractService.queryList(param, false);
        Map<String, BigDecimal> map = new HashMap<>();
        BigDecimal sumBaseMoney = BigDecimal.ZERO;
        BigDecimal sumContractMny = BigDecimal.ZERO;
        for (ContractEntity entity : list) {
            if (entity.getBaseTaxMoney() != null) {
                sumBaseMoney = sumBaseMoney.add(entity.getBaseTaxMoney());
            }
            if (entity.getContractTaxMny() != null) {
                sumContractMny = sumContractMny.add(entity.getContractTaxMny());
            }
        }
        map.put("sumBaseMoney", sumBaseMoney);
        map.put("sumContractMny", sumContractMny);
        return CommonResponse.success("查询汇总金额成功！", map);
    }

    /**
     * 合同参照
     *
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractEntity>> queryRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                          @RequestParam(defaultValue = "10") Integer pageSize,
                                                          @RequestParam(value = "searchText", required = false) String searchText,
                                                          @RequestParam(value = "condition", required = false) String condition) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
                queryParam.getParams().remove("orgId");
            }
        }
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        queryParam.getParams().put("contract_status", new Parameter(QueryParam.NE, 3));
        //queryParam.getOrderMap().put("signDate","desc");
        queryParam.getOrderMap().put("createTime","desc");
        return CommonResponse.success("查询列表数据成功！", contractService.queryPage(queryParam, false));
    }
    /**
     * 合同状态修改
     *
     * @param contractVo
     * @return
     */
    @PostMapping("changeState")
    public CommonResponse<String> changeState(@RequestBody ContractVo contractVo) {
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ContractEntity::getId,contractVo.getId());
        updateWrapper.set(ContractEntity::getContractStatus, contractVo.getContractStatus());
        contractService.update(updateWrapper);
        return CommonResponse.success("修改合同状态成功！");
    }

    /**
     * 导出
     *
     * @param param
     * @return
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同编号、合同名称、发包单位、承包单位、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("contractorUnitName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Object returnedMnyFlag = param.getParams().get("returnedMnyFlag") !=null ? param.getParams().get("returnedMnyFlag").getValue() : null;
        param.getParams().remove("returnedMnyFlag");
        Page<ContractEntity> pageData = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if("1".equals(returnedMnyFlag)){
            wrapper.gt("sum_collect_mny",BigDecimal.ZERO);
        }
        if("0".equals(returnedMnyFlag)){
            wrapper.apply("(sum_collect_mny <= 0 or sum_collect_mny is null)");
        }
        IPage iPage = contractService.selectPage(pageData, wrapper);

        //IPage<ContractEntity> pageData = contractService.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        List<ContractVo> list = new ArrayList<>();
        if(null!=iPage.getRecords()&&CollectionUtils.isNotEmpty(iPage.getRecords())){
            list = BeanMapper.mapList(iPage.getRecords(), ContractVo.class);
            list.forEach(vo -> {
                if(null != vo.getContractStatus()){
                    if(1==vo.getContractStatus()){
                        vo.setContractStatusName("未签订");
                    }else if(2 == vo.getContractStatus()){
                        vo.setContractStatusName("履约中");
                    }else if(3 == vo.getContractStatus()){
                        vo.setContractStatusName("已封账");
                    }
                }else{
                    vo.setContractStatusName("");
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if(vo.getCreateTime()!=null){
                    vo.setCreateTimeStr(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getCreateTime()));
                }
                if(vo.getSignDate()!=null){
                    vo.setSignDateStr(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getSignDate()));
                }
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-export.xlsx", beans, response);
    }

    /**
     * 工程收款
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinanceHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractEntity> queryFinanceHistory(@RequestParam Long id) {
        ContractEntity vo = contractService.queryFinanceHistory(id);
        return CommonResponse.success(vo);
    }
    /**
     * 开票登记
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryTaxHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvoiceOpenRecordVO> queryTaxHistory(@RequestParam Long id) {
        InvoiceOpenRecordVO vo = contractService.queryTaxHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/contractDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVo> contractDetail(@RequestParam Long id) {
        ContractVo vo = contractService.contractDetail(id);
        return CommonResponse.success(vo);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/9/23 移动端 ---年度经营指标查询
     * @Description contractDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.income.vo.ContractVo>
     */
    @RequestMapping(value = "/getAnnuallyCountData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getAnnuallyCountData(@RequestParam Integer type, HttpServletRequest req){
        BigDecimal product = new BigDecimal("0.00");
        BigDecimal claim = new BigDecimal("0.00");
        BigDecimal quote = new BigDecimal("0.00");
        BigDecimal totalReceiveIn = new BigDecimal("0.00");
        BigDecimal totalOut = new BigDecimal("0.00");
        BigDecimal totalReceiveTax = new BigDecimal("0.00");
        BigDecimal totalOpen = new BigDecimal("0.00");
        request = req;
        Calendar calendar = Calendar.getInstance();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));//单据状态已提交和审批通过
        queryParam.getParams().put("productionDate",new Parameter(QueryParam.BETWEEN,calendar.get(Calendar.YEAR)+"-01-01,"+calendar.get(Calendar.YEAR)+"-12-31"));//
        List<Long> projectIds = new ArrayList<>();
        if(type != 1){//非全部项目
            CommonResponse<List<Long>> commonResponse = iProjectApi.getProjectIdsByProperties(type);
            if(commonResponse.isSuccess()){
                projectIds = commonResponse.getData();
                if(ListUtil.isNotEmpty(projectIds)){
                    queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
                }else {
                    JSONObject back = new JSONObject();
                    back.put("product", product);
                    back.put("claim", claim);
                    back.put("quote", quote);
                    back.put("totalReceiveIn", totalReceiveIn);
                    back.put("totalOut", totalOut);
                    back.put("totalReceiveTax", totalReceiveTax);
                    back.put("totalOpen", totalOpen);
                    return CommonResponse.success(back);
                }
            }
        }
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,orgIds));
        }
        /** 查询年度产值 */
        List<ProductionEntity> productionEntities = productionService.queryList(queryParam,false);
        /** 查询签证变更索赔*/
        queryParam.getParams().remove("productionDate");
        queryParam.getParams().put("occurDate",new Parameter(QueryParam.BETWEEN,calendar.get(Calendar.YEAR)+"-01-01,"+calendar.get(Calendar.YEAR)+"-12-31"));//
        List<ClaimEntity> claimEntities = claimService.queryList(queryParam,false);
        /** 查询甲方批量 */
        queryParam.getParams().remove("occurDate");
        queryParam.getParams().put("quoteDate",new Parameter(QueryParam.BETWEEN,calendar.get(Calendar.YEAR)+"-01-01,"+calendar.get(Calendar.YEAR)+"-12-31"));//
        List<QuoteEntity> quoteEntities = quoteService.queryList(queryParam,false);
        /** 创建一个固定数量的线程池 */
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        /** 累计付款 & 累计支出*/
        Callable<JSONObject> receiveAndOut = new PostDataCallable(BASE_HOST + "ejc-finance-web/api/receive/getAnnuallyCountData",projectIds);
        Future<JSONObject> receiveAndOutFuture = threadPool.submit(receiveAndOut);
        /** 累计收票 & 累计开票*/
        Callable<JSONObject> receiveAndOpen = new PostDataCallable(BASE_HOST + "ejc-tax-web/api/tax/getAnnuallyCountData",projectIds);
        Future<JSONObject> receiveAndOpenFuture = threadPool.submit(receiveAndOpen);
        try {
            JSONObject c1 = receiveAndOutFuture.get();
            if(c1.getInteger("code") == 0){
                JSONObject data = c1.getJSONObject("data");
                totalReceiveIn = totalReceiveIn.add(data.getBigDecimal("totalReceive"));
                totalOut = totalOut.add(data.getBigDecimal("totalOut"));
            }
            c1 = receiveAndOpenFuture.get();
            if(c1.getInteger("code") == 0){
                JSONObject data = c1.getJSONObject("data");
                totalReceiveTax = totalReceiveTax.add(data.getBigDecimal("totalReceive"));
                totalOpen = totalOpen.add(data.getBigDecimal("totalOpen"));
            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            threadPool.shutdown();
        }
        if(ListUtil.isNotEmpty(productionEntities)){
            for (ProductionEntity p : productionEntities){
                if(p.getFinishTaxMny()!=null){
                    product = product.add(p.getFinishTaxMny());
                }
            }
        }
        if(ListUtil.isNotEmpty(claimEntities)){
            for (ClaimEntity p : claimEntities){
                if(p.getReplyMny()!=null){
                    claim = claim.add(p.getReplyMny());
                }
            }
        }
        if(ListUtil.isNotEmpty(quoteEntities)){
            for (QuoteEntity p : quoteEntities){
                if(p.getQuoteTaxMny()!=null){
                    quote = quote.add(p.getQuoteTaxMny());
                }
            }
        }
        JSONObject back = new JSONObject();
        product = product.divide(new BigDecimal("10000")).setScale(2,BigDecimal.ROUND_HALF_UP);
        claim = claim.divide(new BigDecimal("10000")).setScale(2,BigDecimal.ROUND_HALF_UP);
        quote = quote.divide(new BigDecimal("10000")).setScale(2,BigDecimal.ROUND_HALF_UP);
        totalOut = totalOut.divide(new BigDecimal("10000")).setScale(2,BigDecimal.ROUND_HALF_UP);
        totalReceiveIn = totalReceiveIn.divide(new BigDecimal("10000")).setScale(2,BigDecimal.ROUND_HALF_UP);
        totalReceiveTax = totalReceiveTax.divide(new BigDecimal("10000")).setScale(2,BigDecimal.ROUND_HALF_UP);
        totalOpen = totalOpen.divide(new BigDecimal("10000")).setScale(2,BigDecimal.ROUND_HALF_UP);
        back.put("product", product);
        back.put("claim", claim);
        back.put("quote", quote);
        back.put("totalReceiveIn", totalReceiveIn);
        back.put("totalOut", totalOut);
        back.put("totalReceiveTax", totalReceiveTax);
        back.put("totalOpen", totalOpen);
        return CommonResponse.success(back);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2021/2/1 首页，项目列表信息查询
     * @Description contractDetail
     * @Param num 需要查询的项目数量
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.income.vo.ContractVo>
     */
    @RequestMapping(value = "/queryProjectInfoList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONArray> queryProjectInfoList(@RequestParam(defaultValue = "10") Integer num){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));//租户隔离
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,"1,3"));//单据状态已提交和审批通过
        /** 签约日期升序 */
        queryParam.getOrderMap().put("signDate",QueryParam.ASC);
        CommonResponse<List<ProjectRegisterVO>> projectIdsResp = iProjectApi.queryProjectList(num);
        if(!projectIdsResp.isSuccess()){
            return CommonResponse.error("查询项目列表失败");
        }
        List<ProjectRegisterVO> voList = projectIdsResp.getData();
        JSONArray backArray = new JSONArray();
        if(ListUtil.isNotEmpty(voList)){
            voList.forEach(vo->{
                JSONObject object = new JSONObject();
                CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(vo.getId(),"BT200519000000002","projectImage","asc");
                if(response.isSuccess() && ListUtil.isNotEmpty(response.getData())){
                    String imageURL = imageUrl;
                    for (int i = 0; i < response.getData().size(); i++) {
                        AttachmentVO attachmentVO = response.getData().get(i);
                        if(attachmentVO.getFileName()!=null &&
                                (attachmentVO.getFileName().toLowerCase().endsWith("png") ||
                                        attachmentVO.getFileName().toLowerCase().endsWith("jpg") ||
                                        attachmentVO.getFileName().toLowerCase().endsWith("jpeg") ||
                                        attachmentVO.getFileName().toLowerCase().endsWith("gif") ||
                                        attachmentVO.getFileName().toLowerCase().endsWith("bpm")
                                )){
                            imageURL = attachmentVO.getTruePath();
                            break;
                        }
                    }
                    object.put("imageUrl",imageURL);
                }else {
                    object.put("imageUrl",imageUrl);
                }
                object.put("projectName",vo.getName());
                object.put("projectId",vo.getId());
                object.put("orgId",vo.getOrgId());
                object.put("area",vo.getArea()==null?"":vo.getArea());
                queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,vo.getId()));
                List<ContractEntity> contractEntities = contractService.queryList(queryParam,false);
                if(ListUtil.isNotEmpty(contractEntities)){
                    object.put("customerName",contractEntities.get(0).getCustomerName()==null?"":contractEntities.get(0).getCustomerName());
                    /** 开工升序 */
                    List<ContractEntity> comparingStartDateEntities = new ArrayList<>();
                    List<ContractEntity> comparingEndDateEntities = new ArrayList<>();
                    contractEntities.forEach(c->{
                        if(c.getStartDate()!=null){
                            comparingStartDateEntities.add(c);
                        }
                        if(c.getEndDate()!=null){
                            comparingEndDateEntities.add(c);
                        }
                    });
                    comparingStartDateEntities.sort(Comparator.comparing(ContractEntity::getStartDate));
                    Date startDate = comparingStartDateEntities.size()>0?comparingStartDateEntities.get(0).getStartDate():null;
                    if(startDate!=null){
                        object.put("startDate",DateFormatUtil.formatDate("yyyy-MM-dd",startDate));
                    }else {
                        object.put("startDate","未知");
                    }
                    /** 竣工降序 */
                    comparingEndDateEntities.sort(Comparator.comparing(ContractEntity::getEndDate).reversed());
                    Date endDate = comparingEndDateEntities.size()>0?comparingEndDateEntities.get(0).getEndDate():null;
                    if(endDate!=null){
                        object.put("endDate",DateFormatUtil.formatDate("yyyy-MM-dd",endDate));
                    }else {
                        object.put("endDate","未知");
                    }
                    if(startDate!=null && endDate!=null){
                        object.put("days",DateUtil.daysBetween(startDate,endDate));
                    }else {
                        object.put("days","未知");
                    }
                    BigDecimal money = new BigDecimal("0.00");
                    for (ContractEntity entity : contractEntities) {
                    	if(entity.getContractTaxMny()!=null){
                    		money = money.add(entity.getContractTaxMny());
                    	}
                    }
                    money = money.setScale(2,BigDecimal.ROUND_HALF_UP);
                    object.put("money",money);
                    if(endDate!=null){
                        int remainDays = DateUtil.daysBetween(new Date(),endDate);
                        if(remainDays<0){
                            remainDays = 0 ;
                        }
                        object.put("remainDays",remainDays);
                    }else {
                        object.put("remainDays","未知");
                    }
                }else{
                    if(vo.getPlannedCommencementDate()!=null){
                        object.put("startDate", DateFormatUtil.formatDate("yyyy-MM-dd",vo.getPlannedCommencementDate()));
                    }else {
                        object.put("startDate", "未知");
                    }
                    if(vo.getPlannedFinishDate()!=null){
                        object.put("endDate",DateFormatUtil.formatDate("yyyy-MM-dd",vo.getPlannedFinishDate()));
                    }else {
                        object.put("endDate", "未知");
                    }
                    if(vo.getPlannedCommencementDate()!=null && vo.getPlannedFinishDate()!=null){
                        object.put("days", DateUtil.daysBetween(vo.getPlannedCommencementDate(),vo.getPlannedFinishDate()));
                    }else {
                        object.put("days", "0");
                    }
                    object.put("money","0.00");
                    if(vo.getPlannedFinishDate()!=null){
                        int remainDays = DateUtil.daysBetween(new Date(),vo.getPlannedFinishDate());
                        if(remainDays<0){
                            remainDays = 0 ;
                        }
                        object.put("remainDays",remainDays);
                    }else {
                        object.put("remainDays","0");
                    }
                    object.put("customerName",vo.getPubUnitName()==null?"":vo.getPubUnitName());
                }
                backArray.add(object);
            });
        }
        return CommonResponse.success(backArray);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/9/22
     * @Description
     * @Param
     * @Return
     */
    class PostDataCallable implements Callable<JSONObject> {
        private String url;
        private Object data;
        public PostDataCallable(String url,Object data){
            this.data = data;
            this.url = url;
        }
        @Override
        public JSONObject call() throws Exception {
            String responseStr = ReferHttpClientUtils.postByJson(url, JSON.toJSONString(data),request);
            System.out.println(responseStr);
            return JSONObject.parseObject(responseStr);
        }
    }

    /**
     * 统计匹配条件的（属于项目的）施工合同含税现合同金额总值(单位：万元）
     *
     * @param param
     *      projectIds: 指定所属的项目的id列表
     * @return
     */
    @PostMapping(value = "analysisContract")
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        QueryParam queryParam = new QueryParam();
        //查询本租户下的
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));
        //已审批生效的
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        //在指定项目范围内的
        if(null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((List<Long>)param.get("projectIds"))) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, param.get("projectIds")));
        }
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(orgIds)){
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIds));
        }
        Map<String, Object> result = contractService.countContractAmount(queryParam);
        String dataStr =  (null != result && null != result.get("curAmount")) ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);

        return CommonResponse.success(total.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        class A{
            private Date date;

            public Date getDate() {
                return date;
            }

            public void setDate(Date date) {
                this.date = date;
            }
        }
        List<A> aList = new ArrayList<>();
        A a = new A();
        a.setDate(sdf.parse("2010-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2000-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2012-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2015-02-20 12:12:21"));
        aList.add(a);
        a = new A();
        a.setDate(sdf.parse("2013-02-20 12:12:21"));
        aList.add(a);

        aList.sort(Comparator.comparing(A::getDate));
        System.out.println(aList.get(0));
        aList.sort(Comparator.comparing(A::getDate).reversed());
        System.out.println();
        BigDecimal decimal = new BigDecimal("0.00");
        decimal.add(new BigDecimal("2.00"));
        System.out.println(decimal);
    }
    /*****************工程云门户首页start*******************/
    //资金统计
    @RequestMapping(value = "/capitalCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String,BigDecimal>> capitalCount(@RequestParam(defaultValue = "1") Integer range) {
        return contractService.capitalCount(range,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
    }

    @RequestMapping(value = "/queryFinanceUse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUse(@RequestParam String dateIn) {
        return contractService.queryFinanceUse(dateIn ,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
    }

    //项目进度查项目
    @RequestMapping(value = "/getproject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map>> getproject() {
        return contractService.getproject(orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
    }
    //项目进度查进度
    @RequestMapping(value = "/getprogress", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> getprogress(@RequestParam(value = "projectId")Long projectId) {
        return contractService.getprogress(projectId);
    }
    //成本统计
    @RequestMapping(value = "/costCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map>> costCount(@RequestParam(defaultValue = "1") Integer range) {
        return contractService.costCount(range,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

    }
    //项目概况
    @RequestMapping(value = "/projectCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectCount(@RequestParam(defaultValue = "thisyear") String range,@RequestParam(value = "name", required = false) String name,@RequestParam(value = "dateIn", required = false) String dateIn,@RequestParam(value = "projectType", required = false) String projectType) {
        return contractService.projectCount(range,name,dateIn,projectType,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

    }
    // 项目收支统计
    @RequestMapping(value = "/proPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> proPageList(@RequestBody(required = false) Map<String, Object> params) {
        //return contractService.projectCount(range,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        //在controller 统一处理
        String startDate=null;
        String endDate=null;
        String type=null;
        if (params.containsKey("dateIn")){
            if (ProjectSurveyEnum.THISYEAR.getCode().equals(params.get("dateIn"))){
                params.put("dateIn",EJCDateUtil.getYear());
                type="1";
            }
            else if (ProjectSurveyEnum.LASTYEAR.getCode().equals(params.get("dateIn"))){
                params.put("dateIn",EJCDateUtil.getLatYear());
                type="1";
            }
            else if (ProjectSurveyEnum.NEAR6MON.getCode().equals(params.get("dateIn"))){
                List<String> monthBetween = EJCDateUtil.getMonthBetween(EJCDateUtil.getMonth(-5), EJCDateUtil.getMonth(0));
                startDate=monthBetween.get(0);
                endDate=monthBetween.get(monthBetween.size()-1);
                params.put("startDate",startDate);
                params.put("endDate",endDate);
                type="2";
            }
            else if (ProjectSurveyEnum.NEAR3MON.getCode().equals(params.get("dateIn"))){
                List<String> monthBetween = EJCDateUtil.getMonthBetween(EJCDateUtil.getMonth(-2), EJCDateUtil.getMonth(0));
                startDate=monthBetween.get(0);
                endDate=monthBetween.get(monthBetween.size()-1);
                params.put("startDate",startDate);
                params.put("endDate",endDate);
                type="2";
            }
            else if (ProjectSurveyEnum.THISMON.getCode().equals(params.get("dateIn"))){
                List<String> monthBetween = EJCDateUtil.getMonthBetween(EJCDateUtil.getMonth(0), EJCDateUtil.getMonth(0));
                startDate=monthBetween.get(0);
                endDate=monthBetween.get(0);
                params.put("startDate",startDate);
                params.put("endDate",endDate);
                type="2";
            }
        }
        if (!params.containsKey("searchText")){
            params.put("searchText",null);
        }
        params.put("type",type);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        JSONObject resp = new JSONObject();
            params.put("orgIds", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        IPage<ProjectInOutVO> page =  contractService.proPageList(params);
        resp.put("data", page);
        BigDecimal inContractMoneySum = contractService.getInContractMoneySum(params);
        resp.put("inContractMoneySum",inContractMoneySum);
        return CommonResponse.success(resp);
    }

    // 根据项目id获取施工合同信息
    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractEntity>> queryDetailByProjectId(@RequestParam Long projectId) {

        QueryWrapper<ContractEntity> wrapper = new QueryWrapper<>();
        wrapper.in("bill_state",1,3);
        wrapper.eq("project_id",projectId);
        List<ContractEntity> list = contractService.list(wrapper);

        return CommonResponse.success(list);
    }

    /*****************工程云门户首页end********************/
}

