package com.ejianc.business.income.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.income.bean.ContractFinishSettleEntity;
import com.ejianc.business.income.service.IContractFinishSettleService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ContractFinishSettleVO;
import com.ejianc.business.income.vo.FinishHistoryVo;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 竣工结算实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping(value = "contractFinishSettle")
public class ContractFinishSettleController {


    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CONTRACT_FINISH_SETTLE_CODE";//此处需要根据实际修改

    @Autowired
    private IContractFinishSettleService service;
    @Autowired
    private IContractService contractService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IVoucherApi voucherApi;

    /**
     * @description: 推送凭证
     *
     * @param voucherInfo
     * @return {@link CommonResponse}
     * @author songlx
     * @date: 2024/1/12
     */
    @RequestMapping(value = "/pushVoucher", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushVoucher(@RequestBody VoucherInfo voucherInfo) {
        Long billId = voucherInfo.getBillId();
        Assert.notNull(billId, "单据billId不能为空！");
        ContractFinishSettleEntity entity = service.selectById(billId);
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId(ContractFinishSettleEntity.BILL_TYPE_CODE, entity, SystemCodeEnum.INCOME);
        CommonResponse<VoucherInfo> response = voucherApi.handleVoucher(voucherParams, VoucherOptFlag.SAVE);
        if (response.isSuccess()) {
            voucherInfo = response.getData();
            LambdaUpdateWrapper<ContractFinishSettleEntity> lambda = new LambdaUpdateWrapper<>();
            lambda.eq(ContractFinishSettleEntity::getId, entity.getId());
            lambda.set(ContractFinishSettleEntity::getVoucherInfo, DataConvertUtil.objToString(voucherInfo));
            lambda.set(ContractFinishSettleEntity::getVoucherFlag, voucherInfo.getVoucherFlag());
            service.update(lambda);
        }
        return response;
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractFinishSettleVO> saveOrUpdate(@RequestBody ContractFinishSettleVO saveOrUpdateVO) {
    	ContractFinishSettleEntity entity = BeanMapper.map(saveOrUpdateVO, ContractFinishSettleEntity.class);
        //校验合同是否已做过竣工结算单
        ContractFinishSettleVO voByContract = service.queryByContractId(saveOrUpdateVO.getContractId());
        if(null != voByContract && (null == saveOrUpdateVO.getId() || !voByContract.getId().equals(voByContract.getId()))) {
            return CommonResponse.error("保存失败，该合同下已存在竣工结算单，请勿重复添加！");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ContractFinishSettleVO vo = BeanMapper.map(entity, ContractFinishSettleVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractFinishSettleVO> queryDetail(Long id) {
    	ContractFinishSettleEntity entity = service.selectById(id);
    	ContractFinishSettleVO vo = BeanMapper.map(entity, ContractFinishSettleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractFinishSettleVO> vos) {
        List<Long> ids = vos.stream().map(ContractFinishSettleVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(vos)) {
            service.removeByIds(ids, false);
        }
        return CommonResponse.success("删除成功！");
    }
    /**
     * 竣工结算历史记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinishHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinishHistoryVo> queryFinishHistory(@RequestParam Long id) {
        FinishHistoryVo vo = service.queryFinishHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractFinishSettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("customerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<ContractFinishSettleEntity> page = service.queryPage(param,false);
        IPage<ContractFinishSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractFinishSettleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @GetMapping(value = "/contractFinishSettleCheck")
    public CommonResponse<String> contractFinishSettleCheck(@RequestParam(value = "contractId") Long contractId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        QueryWrapper<ContractFinishSettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);

        ContractFinishSettleEntity entityByContract = service.getOne(query);
        if(null != entityByContract && (null == billId || !entityByContract.getId().equals(billId))) {
            return CommonResponse.error("该合同已存在竣工结算单！");
        }
        return CommonResponse.success("该合同可以做竣工结算单！");
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ContractFinishSettleEntity> list = service.queryList(param);
        List<ContractFinishSettleVO> contractFinishSettleVOS = BeanMapper.mapList(list, ContractFinishSettleVO.class);
        if (CollectionUtils.isNotEmpty(contractFinishSettleVOS)) {
            contractFinishSettleVOS.forEach(t -> {
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", contractFinishSettleVOS);
        ExcelExport.getInstance().export("ContractFinishSettle-export.xlsx", beans, response);
    }

}
