package com.ejianc.business.income.controller;

import java.io.Serializable;

import com.ejianc.business.income.vo.DeductionExportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.income.bean.DeductionEntity;
import com.ejianc.business.income.service.IDeductionService;
import com.ejianc.business.income.vo.DeductionVO;

/**
 * 甲方扣款实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("/deduction")
public class DeductionController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "INCOME_DEDCODE";

    @Autowired
    private IDeductionService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeductionVO> saveOrUpdate(@RequestBody DeductionVO saveorUpdateVO) {
        DeductionEntity entity = BeanMapper.map(saveorUpdateVO, DeductionEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DeductionVO vo = BeanMapper.map(entity, DeductionVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeductionVO> queryDetail(Long id) {
        DeductionEntity entity = service.selectById(id);
        entity.setSumDeduction(service.getSumMoney(entity.getProjectId(),null));
        DeductionVO vo = BeanMapper.map(entity, DeductionVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description getSumMoney 获取累计金额
     * @param projectId
     * @param contractId
     */
    @RequestMapping(value = "/getSumMoney", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeductionVO> getSumMoney(Long projectId,Long contractId){
        DeductionVO vo = new DeductionVO();
        BigDecimal sumMoney = service.getSumMoney(projectId, contractId);
        vo.setSumDeduction(sumMoney == null ? BigDecimal.valueOf(0) : sumMoney);
        return CommonResponse.success("查询累计金额数据成功!",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeductionVO> vos) {
        service.removeByIds(vos.stream().map(DeductionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeductionEntity>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //项目名称、合同名称、变更摘要、变更签证编号、经办人
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("theme");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime","desc");
        IPage<DeductionEntity> deductionEntityIPage = service.queryPage(param, false);
        return CommonResponse.success("查询列表数据成功！",deductionEntityIPage);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<DeductionEntity> list = service.queryList(param);
        List<DeductionExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
            DeductionExportVO exportVO = BeanMapper.map(vo, DeductionExportVO.class);
            if(vo.getHandleTime()!=null){
                exportVO.setHandleTime(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getHandleTime()));
            }
            exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("deductionExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refDeductionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeductionVO>> refDeductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DeductionEntity> page = service.queryPage(param,false);
        IPage<DeductionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeductionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
