package com.ejianc.business.income.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IRecoveriesApi;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.utils.BigDecimalUtil;
import com.ejianc.business.income.vo.report.ProjectMnyVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@RestController
@RequestMapping("/report")
public class ReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReportService reportService;


    @Autowired
    private IOrgApi orgApi;

    @Autowired
    IProjectApi projectApi;

    @Autowired
    IRecoveriesApi recoveriesApi;

    @Autowired
    private SessionManager sessionManager;


    /**
     * 项目回款台账
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> projectPageList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.pageList(param));
    }

    /**
     * 月度经营报表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/monthPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> monthPageList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", reportService.monthPageList(param));
    }

    /**
     * 项目回款台账导出
     *
     * @param param
     * @return
     */
    @PostMapping("projectExport")
    public void projectExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        JSONObject pageList = reportService.pageList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", pageList.get("records"));
        ExcelExport.getInstance().export("projectReport-export.xlsx", beans, response);
    }

    /**
     * 月度经营报表导出
     *
     * @param param
     * @return
     */
    @PostMapping("monthExport")
    public void monthExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        JSONObject pageList = reportService.monthPageList(param);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", pageList.get("records"));
        ExcelExport.getInstance().export("monthReport-export.xlsx", beans, response);
    }
    /***************  移动看板start  *****************/
    /***************  移动看板end    *****************/

    /**
     * 回款登记
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryProjectMnyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectMnyVO>> queryProjectMnyList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        //先使用pc端的orgid
        if (InvocationInfoProxy.getOrgId() != null) {
            Long orgId = InvocationInfoProxy.getOrgId();
            if (null != orgId && orgId > 0) {
                List<Long> commonOrgIds = new ArrayList<>();
                CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
                if (!orgListResp.isSuccess()) {
                    throw new BusinessException("列表查询失败, 查询组织信息失败！");
                }
                commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
                }
            }
        } else {
            if (StringUtils.isNotEmpty(authOrgIds)) {
                String[] split = authOrgIds.split(",");
                List<Long> orgList = new ArrayList<>();
                List<String> collect = Arrays.stream(split).collect(Collectors.toList());
                collect.forEach(item -> {
                    orgList.add(Long.parseLong(item));
                });
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgList));
            }
        }
        //截止时间
        Map<String, Parameter> paramsmap = param.getParams();
        if (paramsmap.containsKey("quoteDate")) {
            Date date = DateUtil.date();
            int year = DateUtil.year(date);
            String quoteDate = (String) paramsmap.get("quoteDate").getValue();
            quoteDate = year + "-" + quoteDate + "-31";
            param.getParams().put("quote_date", new Parameter(QueryParam.LE, quoteDate));
            paramsmap.remove("quoteDate");
        }

        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("project_id");
        Page<ProjectMnyVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<ProjectMnyVO> list = reportService.queryProjectMnyList(page, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> projectIds = list.stream().map(ProjectMnyVO::getProjectId).collect(Collectors.toList());
            CommonResponse<List<ProjectRegisterVO>> projectRes = projectApi.queryProjectByIds(projectIds);
            CommonResponse<List<ReceiveVO>> recoveries = recoveriesApi.queryProjectReceiveMny(projectIds);
            Map<Long, ProjectRegisterVO> projectMap = new HashMap<>();
            if (projectRes.isSuccess() && CollectionUtils.isNotEmpty(projectRes.getData())) {
                projectMap = projectRes.getData().stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
            }
            Map<Long, ReceiveVO> recoverieMap = new HashMap<>();
            if (recoveries.isSuccess() && CollectionUtils.isNotEmpty(recoveries.getData())) {
                recoverieMap = recoveries.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }
            for (ProjectMnyVO mnyVO : list) {
                Long projectId = mnyVO.getProjectId();
                ProjectRegisterVO projectRegisterVO = projectMap.get(projectId);
                if (null != projectRegisterVO) {
                    mnyVO.setParentOrgId(projectRegisterVO.getOrgId());
                    mnyVO.setParentOrgName(projectRegisterVO.getOrgName());
                    mnyVO.setProjectManager(projectRegisterVO.getProjectManagerName());
                    mnyVO.setPubUnitName(projectRegisterVO.getPubUnitName());
                    mnyVO.setInvestorName(projectRegisterVO.getInvestorName());
                }
                ReceiveVO receiveVO = recoverieMap.get(projectId);
                if (null != receiveVO) {
                    mnyVO.setReceiveMny(receiveVO.getReceiveMny());
                }
                if (mnyVO.getParentOrgId() == null)
                    logger.error("此数据【projectId：{}】的ParentOrgId为空！", mnyVO.getProjectId());
            }
            if (CollectionUtils.isNotEmpty(list)) {
                Map<Long, List<ProjectMnyVO>> map = list.stream().filter(s -> s != null && s.getParentOrgId() != null).collect(Collectors.groupingBy(ProjectMnyVO::getParentOrgId));
                for (ProjectMnyVO v : list) {
                    Long parentorgid = v.getParentOrgId();
                    List<ProjectMnyVO> ll = map.get(parentorgid);
                    if (CollectionUtils.isNotEmpty(ll)) {
                        v.setOrgRowSpan(ll.size());
                        map.remove(parentorgid);
                    } else {
                        v.setOrgRowSpan(0);
                    }
                }
            }
        }

        Map<Long, List<ProjectMnyVO>> map = new HashMap<>();
        map = list.stream().filter(s -> s != null).filter(s->s.getProjectId()!=null).collect(Collectors.groupingBy(ProjectMnyVO::getProjectId));
        for (ProjectMnyVO mnyVO : list) {
            Long projectId = mnyVO.getProjectId();
            List<ProjectMnyVO> projectMnyVOS = map.get(projectId);
            if (CollectionUtils.isNotEmpty(projectMnyVOS)) {
                BigDecimal sumreceivemny = projectMnyVOS.stream().filter(s -> s.getReceiveMny() != null).map(ProjectMnyVO::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                mnyVO.setSumReceiveMny(sumreceivemny);
                BigDecimal sumQuoteTaxMny = projectMnyVOS.stream().filter(s -> s.getQuoteTaxMny() != null).map(ProjectMnyVO::getQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                mnyVO.setSumQuoteTaxMny(sumQuoteTaxMny);
                BigDecimal yun = BigDecimalUtil.safeSub(sumQuoteTaxMny, sumreceivemny);
                mnyVO.setYue(yun);
            }
        }
        List<ProjectMnyVO> collect = list.stream().filter(s->s.getParentOrgId()!=null).sorted(Comparator.comparing(ProjectMnyVO::getParentOrgId)).collect(Collectors.toList());
        IPage<ProjectMnyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(collect);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "excelExportInAndOutStoreList", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(10000);
        param.setPageIndex(1);
        CommonResponse<IPage<ProjectMnyVO>> iPageCommonResponse = queryProjectMnyList(param);
        List<ProjectMnyVO> records = iPageCommonResponse.getData().getRecords();
        int num = 0;

        if (ListUtil.isNotEmpty(records)) {
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
            sheet.setColumnWidth(7, 60 * 135);
            //首行标题
            XSSFRow row = sheet.createRow(0);
            CellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern(CellStyle.SOLID_FOREGROUND);
            style.setAlignment(CellStyle.ALIGN_CENTER);

            XSSFCell cell = row.createCell(0);
            cell.setCellValue("回款汇总");
            cell.setCellStyle(style);
            //第二行数据
            row = sheet.createRow(1);

            cell = row.createCell(0);
            cell.setCellValue("区域");

            cell.setCellStyle(style);
            cell = row.createCell(1);
            cell.setCellValue("项目经理");

            cell.setCellStyle(style);
            cell = row.createCell(2);
            cell.setCellStyle(style);
            cell.setCellValue("项目");

            cell = row.createCell(3);
            cell.setCellValue("投资主体");
            cell.setCellStyle(style);

            cell = row.createCell(4);
            cell.setCellValue("发包单位");
            cell.setCellStyle(style);

            cell = row.createCell(5);
            cell.setCellValue("回款金额");
            cell.setCellStyle(style);

            cell = row.createCell(6);
            cell.setCellValue("实际回款");
            cell.setCellStyle(style);

            cell = row.createCell(7);
            cell.setCellValue("余额");
            cell.setCellStyle(style);


            for (int i = 0; i < 7; i++) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 60 / 10);
            }
            for (int i = 0; i < records.size(); i++) {
                ProjectMnyVO vo = records.get(i);
                row = sheet.createRow(i + 2);
                if (vo.getOrgRowSpan() > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.getParentOrgName() == null ? "" : vo.getParentOrgName().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (vo.getOrgRowSpan() - 1), 0, 0));
                }
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectManager() != null ? vo.getProjectManager() : null);

                cell = row.createCell(2);
                cell.setCellValue(vo.getProjectName() != null ? vo.getProjectName().toString() : null);

                cell = row.createCell(3);
                cell.setCellValue(vo.getInvestorName() != null ? vo.getInvestorName().toString() : null);

                cell = row.createCell(4);
                cell.setCellValue(vo.getPubUnitName() != null ? vo.getPubUnitName().toString() : null);

                cell = row.createCell(5);
                cell.setCellValue(vo.getSumQuoteTaxMny() != null ? vo.getSumQuoteTaxMny().setScale(2, BigDecimal.ROUND_HALF_UP).toString() : "0.00");

                cell = row.createCell(6);
                cell.setCellValue(vo.getReceiveMny() != null ? vo.getReceiveMny().setScale(2, BigDecimal.ROUND_HALF_UP).toString() : "0.00");

                cell = row.createCell(7);
                cell.setCellValue(vo.getYue() != null ? vo.getYue().setScale(2, BigDecimal.ROUND_HALF_UP).toString() : "0.00");
            }
            List<Integer> list1 = new ArrayList<>();
            records.forEach(item -> {
                if (item.getOrgRowSpan() > 0) {
                    Integer orgRowSpan = item.getOrgRowSpan();
                    list1.add(orgRowSpan);
                    int sum1 = (int) list1.stream().collect(Collectors.summarizingInt(value -> value)).getSum();
                    sheet.shiftRows(sum1 + 2, sheet.getLastRowNum() + 1, 1, true, false);
                    XSSFRow newRow = sheet.createRow(sum1 + 2);
                    XSSFCell newCell = newRow.createCell(0);
                    newCell = newRow.createCell(0);
                    newCell.setCellValue(item.getParentOrgName() == null ? "" : item.getParentOrgName().toString());
                    newCell = newRow.createCell(1);
                    newCell.setCellValue("合计");

                    BigDecimal sumQuoteTaxMny = records.stream().filter(s -> (s.getParentOrgId().equals(item.getParentOrgId()) && s.getSumQuoteTaxMny() != null)).map(ProjectMnyVO::getSumQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(5);
                    newCell.setCellValue(sumQuoteTaxMny != null ? sumQuoteTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP).toString() : "0.00");

                    BigDecimal receiveMny = records.stream().filter(s -> s.getParentOrgId().equals(item.getParentOrgId())).map(ProjectMnyVO::getSumReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(6);
                    newCell.setCellValue(receiveMny != null ? receiveMny.setScale(2, BigDecimal.ROUND_HALF_UP).toString() : "0.00");
                    BigDecimal yun = BigDecimalUtil.safeSub(sumQuoteTaxMny, receiveMny);
                    newCell = newRow.createCell(7);
                    newCell.setCellValue(yun != null ? yun.setScale(2, BigDecimal.ROUND_HALF_UP).toString() : "0.00");
                    list1.remove(orgRowSpan);
                    list1.add(orgRowSpan + 1);
                }
            });
            workbook.write(outputStream);
        }

    }

}
