package com.ejianc.business.income.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.income.bean.DeductionEntity;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 甲方扣款实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface DeductionMapper extends BaseCrudMapper<DeductionEntity> {
    @Select("SELECT MAX(quote_date) from ejc_income_quote eip where eip.dr=0 and contract_id=#{contractId} and eip.bill_state in (1,3)")
    Date getLastDate(Long contractId);

    /**
     * 根据projectId查询总钱数
     * @param projectId
     * @return
     */
    @Select("select sum(deduction) from ejc_income_deduction where dr = 0 and project_id = #{projectId} and bill_state in (1,3)")
    BigDecimal getSumMoney(Long projectId);

    /**
     * 方法重载 添加contractId 参数
     * @param projectId
     * @param contractId
     * @return
     */
    @Select("select sum(deduction) from ejc_income_deduction where dr = 0 and project_id = #{projectId} and contract_id = #{contractId}")
    BigDecimal getSumMoney(Long projectId,Long contractId);
}
