package com.ejianc.business.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.voucher.service.IVoucherService;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 产值进度 服务类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public interface IProductionService extends IBaseService<ProductionEntity>, IVoucherService<ProductionEntity> {

    CommonResponse<ProductionVo> saveOrUpdate(ProductionVo productionVo);

    ProductionVo queryDetail(Long id);

    void deleteProduction(List<ProductionVo> vos);

    ProductionHistoryVo queryProductionHistory(Long id);

    List<ProductionDetailVo> detailRef(Long id);

    /**
     * 根据来源主键（合同清单）查询历史数据的含本期累计完成量，完成产值
     * @param
     * @param
     * @return
     */
    JSONObject queryProductionDetailHistory(ProductionDetailVo productionDetailVo);

    ProductionVo queryInfoProjectId(Long projectId);
}
