package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.income.bean.*;
import com.ejianc.business.income.service.*;
import com.ejianc.business.income.vo.*;
import com.ejianc.business.income.vo.comparator.ProductionDetailComparatorVo;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.utils.DataConvertUtil;
import com.ejianc.business.voucher.vo.VoucherInfo;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.mapper.ProductionMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

/**
 * <p>
 * 产值进度 服务实现类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Service("ProductionService")
public class ProductionServiceImpl extends BaseServiceImpl<ProductionMapper, ProductionEntity> implements IProductionService {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final String PRODUCTION_BILL_CODE = "INCOME_PRODUCTION";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private ProductionMapper productionMapper;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionClaimService productionClaimService;

    @Autowired
    private IProductionOtherService productionOtherService;
    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IClaimService claimService;

    @Autowired
    private IVoucherApi voucherApi;

    @Autowired
    private IContractFinishSettleService finishSettleService;


    @Override
    public CommonResponse<ProductionVo> saveOrUpdate(ProductionVo productionVo) {
//        if(null == productionVo.getCheckList() || productionVo.getCheckList().size()<1){
//            throw new BusinessException("产值明细不可以为空");
//        }
        //保存时校验合同version是否一致
        ContractEntity contractEntity = contractService.selectById(productionVo.getContractId());

        Jedis jedis = jedisPool.getResource();
        boolean locked = false;
        try {
            locked = RedisTool.tryLock(jedis, String.valueOf(productionVo.getContractId()), "saveOrUpdate", 1000);
            logger.info("判断单据单据锁结果------" + locked);
            if (productionVo.getContractVersion() != null && productionVo.getContractVersion() != 0) {
                if (locked) {
                    Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                    Integer conVersion = productionVo.getContractVersion();
                    if (!version.equals(conVersion)) {
                        return CommonResponse.error("施工合同已被更新，请刷新后重做！");
                    }
                } else {
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            }
            List<ProductionClaimVo> claimVos = productionVo.getClaimList();
            if (claimVos != null && claimVos.size() > 0) {
                Map<Long, Integer> versionMap = new HashMap<>();
                for (ProductionClaimVo claimVo : claimVos) {
                    if (claimVo.getClaimVersion() != null && claimVo.getClaimVersion() != 0) {
                        versionMap.put(claimVo.getClaimId(), claimVo.getClaimVersion());
                    }
                }
                if (versionMap != null && versionMap.size() > 0) {
                    if (locked) {
                        QueryParam param = new QueryParam();
                        param.getParams().put("id", new Parameter("in", new ArrayList<Long>(versionMap.keySet())));
                        List<ClaimEntity> claimEntities = claimService.queryList(param, false);
                        for (ClaimEntity claimEntity : claimEntities) {
                            if ((claimEntity.getVersion() == null ? 0 : claimEntity.getVersion()) != versionMap.get(claimEntity.getId())) {
                                return CommonResponse.error("变更签证洽商索赔已被更新，请刷新后重做！");
                            }
                        }
                    } else {
                        return CommonResponse.error("出现并发操作,请稍后重试！");
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (locked) {
                RedisTool.releaseLock(jedis, String.valueOf(productionVo.getContractId()), "saveOrUpdate");
            }
            jedis.close();
        }

        Date signDate = contractEntity.getSignDate();
        if (null != signDate && productionVo.getProductionDate().getTime() < signDate.getTime()) {
            throw new BusinessException("产值时间只能是大于等于施工合同的签约日期");
        }
        Date lastDate = productionMapper.getLastDate(productionVo.getContractId());
        if (null != lastDate && productionVo.getProductionDate().getTime() < lastDate.getTime()) {
            throw new BusinessException("产值时间要大于等于该合同下的产值时间");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ProductionEntity entity = null;
        String operateType = null;
        if (productionVo.getId() != null && productionVo.getId() > 0) { //修改
            if (StringUtils.isEmpty(productionVo.getBillCode())) {
                productionVo.setBillCode(null);
            }
            entity = BeanMapper.map(productionVo, ProductionEntity.class);
            operateType = "edit";
        } else {
            //同一个合同只能存在一个自由态或审批中的单据
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, productionVo.getContractId()));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(0);
            billStatus.add(2);
            billStatus.add(5);
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            List<ProductionEntity> entities = super.queryList(queryParam, false);
            if (null != entities && entities.size() > 0) {
                throw new BusinessException("合同存在进行中的单据，不允许保存");
            }
            //新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PRODUCTION_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                productionVo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity = BeanMapper.map(productionVo, ProductionEntity.class);
            operateType = "add";
        }
        if (productionVo.getId() != null && productionVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<ProductionEntity> lambda = Wrappers.<ProductionEntity>lambdaQuery();
            lambda.eq(ProductionEntity::getBillCode, productionVo.getBillCode());
            lambda.eq(ProductionEntity::getTenantId, tenantId);
            lambda.ne(ProductionEntity::getId, productionVo.getId());
            List<ProductionEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ProductionEntity> lambda = Wrappers.<ProductionEntity>lambdaQuery();
            lambda.eq(ProductionEntity::getTenantId, tenantId);
            lambda.eq(ProductionEntity::getBillCode, productionVo.getBillCode());
            List<ProductionEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        super.saveOrUpdate(entity);

        List<ProductionDetailVo> detailsVos = productionVo.getCheckList();
        List<ProductionDetailEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for (ProductionDetailVo detailsVo : detailsVos) {
            if ("add".equals(detailsVo.getRowState())) {
                ProductionDetailEntity detailslist = BeanMapper.map(detailsVo, ProductionDetailEntity.class);
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                saveOrUpldates.add(detailslist);
            } else if ("edit".equals(detailsVo.getRowState())) {
                ProductionDetailEntity detailslist = BeanMapper.map(detailsVo, ProductionDetailEntity.class);
                saveOrUpldates.add(detailslist);
            } else if ("del".equals(detailsVo.getRowState())) {
                deleteIds.add(detailsVo.getId());
            }
        }
        if (saveOrUpldates.size() > 0) {
            productionDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (ProductionDetailEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProductionDetailEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            productionDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            productionDetailService.removeByIds(deleteIds, false);
        }

        List<ProductionClaimVo> clauseVos = productionVo.getClaimList();
        List<ProductionClaimEntity> clauseList = new ArrayList<>();
        List<Long> deleteClauseIds = new ArrayList<>();
        for (ProductionClaimVo clauseVo : clauseVos) {
            if ("add".equals(clauseVo.getRowState())) {
                ProductionClaimEntity detailslist = BeanMapper.map(clauseVo, ProductionClaimEntity.class);
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                clauseList.add(detailslist);
            } else if ("edit".equals(clauseVo.getRowState())) {
                ProductionClaimEntity detailslist = BeanMapper.map(clauseVo, ProductionClaimEntity.class);
                clauseList.add(detailslist);
            } else if ("del".equals(clauseVo.getRowState())) {
                deleteClauseIds.add(clauseVo.getId());
            }
        }
        if (clauseList.size() > 0) {
            productionClaimService.saveOrUpdateBatch(clauseList, clauseList.size(), false);
        }
        if (deleteClauseIds.size() > 0) {
            productionClaimService.removeByIds(deleteClauseIds, false);
        }

        List<ProductionOtherVO> otherVOs = productionVo.getOtherList();
        List<ProductionOtherEntity> otherList = new ArrayList<>();
        List<Long> deleteOtherIds = new ArrayList<>();
        for (ProductionOtherVO clauseVo : otherVOs) {
            if ("add".equals(clauseVo.getRowState())) {
                ProductionOtherEntity detailslist = BeanMapper.map(clauseVo, ProductionOtherEntity.class);
                detailslist.setProductionId(entity.getId());
                detailslist.setId(null);
                otherList.add(detailslist);
            } else if ("edit".equals(clauseVo.getRowState())) {
                ProductionOtherEntity detailslist = BeanMapper.map(clauseVo, ProductionOtherEntity.class);
                otherList.add(detailslist);
            } else if ("del".equals(clauseVo.getRowState())) {
                deleteOtherIds.add(clauseVo.getId());
            }
        }
        if (otherList.size() > 0) {
            productionOtherService.saveOrUpdateBatch(otherList, otherList.size(), false);
        }
        if (deleteOtherIds.size() > 0) {
            productionOtherService.removeByIds(deleteOtherIds, false);
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public ProductionVo queryDetail(Long id) {
        ProductionEntity entity = productionMapper.selectById(id);
        if (entity != null) {
            ProductionVo vo = BeanMapper.map(entity, ProductionVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("productionId", new Parameter(QueryParam.EQ, vo.getId()));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<ProductionDetailEntity> details = productionDetailService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (ProductionDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List<ProductionDetailVo> resultMapList = BeanMapper.mapList(details, ProductionDetailVo.class);
                //实现排序
                Collections.sort(resultMapList, new ProductionDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
            }
            QueryParam parm = new QueryParam();
            parm.getParams().put("productionId", new Parameter(QueryParam.EQ, vo.getId()));
            List<ProductionClaimEntity> productionClaimEntities = productionClaimService.queryList(parm, false);
            vo.setClaimList(BeanMapper.mapList(productionClaimEntities, ProductionClaimVo.class));
            List<ProductionOtherEntity> productionOtherEntities = productionOtherService.queryList(parm, false);
            vo.setOtherList(BeanMapper.mapList(productionOtherEntities, ProductionOtherVO.class));
            return vo;
        }
        return null;
    }

    @Override
    public void deleteProduction(List<ProductionVo> vos) {
        super.removeByIds(vos.stream().map(ProductionVo::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ProductionHistoryVo queryProductionHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<ProductionEntity> prodEntities = productionMapper.selectList(new QueryWrapper<ProductionEntity>()
                .eq("contract_id", id)
                .in("bill_state", billStatus).orderByDesc("production_date", "create_time"));
        ContractEntity contractEntity = contractService.selectById(id);
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumClaimMny = contractEntity.getSumClaimMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimMny();
        ProductionHistoryVo vo = new ProductionHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumProductionTaxMny(contractEntity.getSumProductionTaxMny());//累计完成产值
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        //第一版
        BigDecimal add = contractTaxMny;
        //第二版
        //BigDecimal add = contractTaxMny.add(sumClaimMny);
        if (add.compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumImageProgress(BigDecimal.ZERO);//累计形象进度
        } else {
            vo.setSumImageProgress(sumProductionTaxMny.divide(add, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100)));
        }

        vo.setProductionRecord(BeanMapper.mapList(prodEntities, ProductionVo.class));
        return vo;
    }

    @Override
    public List<ProductionDetailVo> detailRef(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("productionId", new Parameter(QueryParam.EQ, id));
        //queryParam.getOrderMap().put("detailIndex", "asc");
        List<ProductionDetailEntity> details = productionDetailService.queryList(queryParam, false);
        if (details != null && details.size() > 0) {
            for (ProductionDetailEntity cdEntity : details) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<ProductionDetailVo> resultMapList = BeanMapper.mapList(details, ProductionDetailVo.class);
            //实现排序
            Collections.sort(resultMapList, new ProductionDetailComparatorVo());
            return TreeNodeBUtil.buildTree(resultMapList);
        }
        return null;
    }

    @Override
    public JSONObject queryProductionDetailHistory(ProductionDetailVo productionDetailVo) {
        BigDecimal sumFinishNum = new BigDecimal(0);
        BigDecimal sumFinishMny = new BigDecimal(0);
        if (productionDetailVo.getContractDetailId() != null) {
            productionDetailVo.setSourceType(1);
            List<ProductionDetailVo> list = baseMapper.queryProductionDetailHistory(productionDetailVo);
            if (CollectionUtils.isNotEmpty(list)) {
                //计算历史含本期金额
                for (ProductionDetailVo vo : list) {
                    sumFinishNum = BigDecimalUtils.safeAdd(sumFinishNum, vo.getFinishNum());
                    sumFinishMny = BigDecimalUtils.safeAdd(sumFinishMny, vo.getFinishMny());
                }
            }
        }

        JSONObject jo = new JSONObject();
        jo.put("sumFinishNum", sumFinishNum);
        jo.put("sumFinishMny", sumFinishMny);
        return jo;
    }

    /***
     * 根据项目id 查询 累计完成产值
     * @param projectId
     * @return
     */
    @Override
    public ProductionVo queryInfoProjectId(Long projectId) {
        QueryWrapper<ProductionEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.select("IFNULL(sum(finish_tax_mny) , 0 ) AS sumProductionTaxMny");
        List<ProductionEntity> list = this.list(wrapper);
        BigDecimal sumProductionTaxMny = BigDecimal.ZERO;
        if (list.get(0) != null) {
            sumProductionTaxMny = list.stream().map(ProductionEntity::getSumProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        ProductionVo productionVo = new ProductionVo();
        productionVo.setSumProductionTaxMny(sumProductionTaxMny);

        QueryWrapper<ContractFinishSettleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<ContractFinishSettleEntity> finishSettleEntities = finishSettleService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(finishSettleEntities)) {
            BigDecimal endSettleMny = finishSettleEntities.stream().filter(item -> item.getEndSettleMny() != null).map(ContractFinishSettleEntity::getEndSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            productionVo.setEndSettleMny(endSettleMny);
        }

        return productionVo;
    }


    @Override
    public CommonResponse handleVoucher(ProductionEntity entity, String voucherOptFlag) {
        CommonResponse response = null;
        if(VoucherOptFlag.DEL.equals(voucherOptFlag) || VoucherOptFlag.SAVE.equals(voucherOptFlag)){
            if (VoucherFlag.SUCCESS.equals(entity.getVoucherFlag())) {
                response = voucherApi.del(JSONObject.parseObject(entity.getVoucherInfo(), VoucherInfo.class));
                logger.info("{}删除凭证结果：{}", voucherOptFlag, DataConvertUtil.toPrettyFormat(response));
                if (response.isSuccess()) {
                    LambdaUpdateWrapper<ProductionEntity> lambda = new LambdaUpdateWrapper<>();
                    lambda.eq(ProductionEntity::getId, entity.getId());
                    lambda.set(ProductionEntity::getVoucherInfo, null);
                    lambda.set(ProductionEntity::getVoucherFlag, 0);
                    this.update(lambda);
                }
            }
            if(VoucherOptFlag.DEL.equals(voucherOptFlag)){
                return response;
            }
        }
        VoucherParams voucherParams = VoucherParams.newInstanceByOrgId("BT200616000000001", entity, SystemCodeEnum.INCOME);
        response = voucherApi.save(voucherParams);
        logger.info("{}保存凭证结果：{}" ,voucherOptFlag, DataConvertUtil.toPrettyFormat(response));
        LambdaUpdateWrapper<ProductionEntity> lambda = new LambdaUpdateWrapper<>();
        lambda.eq(ProductionEntity::getId, entity.getId());
        if (response.isSuccess()) {
            VoucherInfo voucherInfo = (VoucherInfo) response.getData();
            lambda.set(ProductionEntity::getVoucherInfo, DataConvertUtil.objToString(voucherInfo));
            lambda.set(ProductionEntity::getVoucherFlag, voucherInfo.getVoucherFlag());
        } else {
            lambda.set(ProductionEntity::getVoucherInfo, response.getMsg());
            lambda.set(ProductionEntity::getVoucherFlag, VoucherFlag.FAILED);
        }
        this.update(lambda);
        return response;
    }

}
