package com.ejianc.business.integration.base.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.framework.core.response.CommonResponse;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * 本类主要用于
 *
 * @author liuhaoi
 * @since Created At 2020/5/11 11:08 上午
 */
@Slf4j
@Data
public class OpenApiResponse<T> {


    private Object code;

    private String message;

    private T data;

    public void check() {
        if (code instanceof Number && ((int) code == 0 || (int) code == 200)) {
            return;
        }

        if ("00000".equals(code) || "200".equals(code)) {
            return;
        }

        log.info("用友开放平台接口返回结果:"+ JSON.toJSONString(this, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
    }

    public CommonResponse toCommonResponse() {
        if (code instanceof Number && ((int) code == 0 || (int) code == 200)) {
            return CommonResponse.success(data);
        }

        if ("00000".equals(code) || "200".equals(code)) {
            return CommonResponse.success(data);
        }
        log.info("用友开放平台接口返回结果:"+ JSON.toJSONString(this, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        return CommonResponse.error(JSON.toJSONString(this));
    }
}
