package com.ejianc.business.integration.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.integration.base.module.reponse.ApiDataResponse;
import com.ejianc.business.integration.controller.BaseOpenApi;
import com.ejianc.business.integration.controller.OpenApiURL;
import com.ejianc.business.integration.vo.YSVoucherInfo;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @description: 凭证
 **/
@RestController
@RequestMapping(value = "/api/ysVoucherApi/")
public class YSVoucherApi extends BaseOpenApi {

    /**
     * @description: {
     * 	"srcSystemCode": "figl",
     * 	"accbookCode": "dxbook003",
     * 	"voucherTypeCode": "01",
     * 	"billCode": 111,
     * 	"attachedBill": 1,
     * 	"makerMobile": "18510047432",
     * 	"makerEmail": "liuyazh@yonyou.com",
     * 	"makeTime": "2021-08-25",
     * 	"description": "凭证头摘要",
     * 	"defInfo1": "自定义扩展信息1",
     * 	"defInfo2": "自定义扩展信息2",
     * 	"defInfo3": "自定义扩展信息3",
     * 	"defInfo4": "自定义扩展信息4",
     * 	"defInfo5": "自定义扩展信息5",
     * 	"bodies": [
     *                {
     * 			"description": "购买xx设备",
     * 			"accsubjectCode": "1001",
     * 			"price": 15,
     * 			"quantity": 2,
     * 			"currencyCode": "CNY",
     * 			"busidate": "2021-08-23",
     * 			"rateType": "01",
     * 			"organizeRateTypeCode": "CWGGZDH_ZZBHLLX1",
     * 			"groupRatetypeCode": "CWGGZDH_JTBHLLX1",
     * 			"globalRatetypeCode": "CWGGZDH_QJUHLLX1",
     * 			"rateOrg": 1,
     * 			"organizeRate": 1,
     * 			"rateGroup": 1,
     * 			"rateGlobal": 1,
     * 			"debitOriginal": 13.1,
     * 			"creditOriginal": 13.1,
     * 			"debitOrg": 13.1,
     * 			"organizeDebitAmount": 13.1,
     * 			"debitGroup": 13.1,
     * 			"debitGlobal": 13.1,
     * 			"creditOrg": 13.1,
     * 			"organizeCreditAmount": 13.1,
     * 			"creditGroup": 13.1,
     * 			"creditGlobal": 13.1,
     * 			"secondOrgCode": "fwefqfe",
     * 			"settlementModeCode": "02",
     * 			"billTime": "2021-08-23",
     * 			"billNo": "1235",
     * 			"bankVerifyCode": "789703",
     * 			"clientAuxiliaryList": [
     *                {
     * 					"filedCode": "000433",
     * 					"valueCode": "0000000001"
     *                }
     * 			],
     * 			"cashflowList": [
     *                {
     * 					"innerOrgCode": "AAA",
     * 					"mainItemCode": "1111",
     * 					"supItemCode": "031501",
     * 					"amountOriginal": 12,
     * 					"amountOrg": 12
     *                }
     * 			]
     *        }
     * 	]
     * }
     *
     */

    /**
     * @description: 保存凭证
     *
     * @return {@link CommonResponse<  YSVoucherInfo >}
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "save")
    public CommonResponse<YSVoucherInfo> save(@RequestBody Map<String, Object> params) {
        //BigDecimal taxMny = ComputeUtil.scaleTwo(voucherVO.getTaxMny());
        //Map<String, Object> params = new HashMap<>();
        Object taxMny = params.get("taxMny");
        params.put("accbookCode", "CS001");
        params.put("voucherTypeCode", "JZ");
        params.put("makerMobile", "13598006631");
        params.put("makerEmail", "1");

        JSONObject body1 = new JSONObject();
        body1.put("description", "益企联科技大厦劳务分包结算");
        body1.put("accsubjectCode", "590101");
        body1.put("debitOriginal", taxMny);
        body1.put("debitOrg", taxMny);
        body1.put("debitGroup", taxMny);
        body1.put("debitGlobal", taxMny);
        body1.put("organizeDebitAmount", taxMny);
        JSONArray clientAuxiliaryList1 = new JSONArray();
        JSONObject clientAuxiliaryList1_1 = new JSONObject();
        clientAuxiliaryList1_1.put("filedCode", "0002");
        clientAuxiliaryList1_1.put("valueCode", "XM001");
        clientAuxiliaryList1.add(clientAuxiliaryList1_1);
        body1.put("clientAuxiliaryList", clientAuxiliaryList1);
     /*   JSONArray cashflowList1 = new JSONArray();
        JSONObject cashflowList1_1 = new JSONObject();
        cashflowList1_1.put("mainItemCode", "defInfo1");
        cashflowList1_1.put("amountOriginal",  taxMny);
        cashflowList1_1.put("amountOrg",  taxMny);
        cashflowList1.add(cashflowList1_1);
        body1.put("cashflowList", cashflowList1);*/

        JSONObject body2 = new JSONObject();
        body2.put("description", "益企联科技大厦劳务分包结算");
        body2.put("accsubjectCode", "220201");
        body2.put("creditOriginal", taxMny);
        body2.put("creditOrg", taxMny);
        body2.put("creditGroup", taxMny);
        body2.put("creditGlobal", taxMny);
        body2.put("organizeCreditAmount", taxMny);

        JSONArray clientAuxiliaryList2 = new JSONArray();
        JSONObject clientAuxiliaryList2_1 = new JSONObject();
        clientAuxiliaryList2_1.put("filedCode", "0002");
        clientAuxiliaryList2_1.put("valueCode", "XM001");
        clientAuxiliaryList2.add(clientAuxiliaryList2_1);
        JSONObject clientAuxiliaryList2_2 = new JSONObject();
        clientAuxiliaryList2_2.put("filedCode", "0004");
        clientAuxiliaryList2_2.put("valueCode", "00LW000001");
        clientAuxiliaryList2.add(clientAuxiliaryList2_2);
        body2.put("clientAuxiliaryList", clientAuxiliaryList2);
        /*JSONArray cashflowList2 = new JSONArray();
        JSONObject cashflowList2_1 = new JSONObject();
        cashflowList2_1.put("mainItemCode", "defInfo1");
        cashflowList2_1.put("amountOriginal",  "100.00");
        cashflowList2_1.put("amountOrg",  "100.00");
        cashflowList2.add(cashflowList2_1);

        JSONObject cashflowList2_2 = new JSONObject();
        cashflowList2_2.put("mainItemCode", "defInfo2");
        cashflowList2_2.put("amountOriginal",  "100.00");
        cashflowList2_2.put("amountOrg",  "100.00");
        cashflowList2.add(cashflowList2_2);
        body2.put("cashflowList", cashflowList2);*/
        JSONArray bodies = new JSONArray();
        bodies.add(body1);
        bodies.add(body2);
        params.put("bodies", bodies);

        ApiDataResponse apiDataResponse = postForEntity(OpenApiURL.ADD_VOUCHER, params, ApiDataResponse.class);
        CommonResponse commonResponse = apiDataResponse.toCommonResponse();

        if (commonResponse.isSuccess()) {
            Map<String, Object> data = (Map<String, Object>) commonResponse.getData();
            YSVoucherInfo ysVoucherInfo = new YSVoucherInfo();
            ysVoucherInfo.setVoucherId(data.get("voucherId").toString());
            ysVoucherInfo.setPeriod(data.get("period").toString());
            ysVoucherInfo.setBillCode(data.get("billCode").toString());
            commonResponse.setData(ysVoucherInfo);
        }
        return commonResponse;
    }


    /**
     * @description: 查询凭证
     * pager	object	否	否	分页对象信息
     * pageIndex	int	否	否	当前页    示例：1
     * pageSize	int	否	否	每页数量（最大1000）    示例：20
     * ccbookCode	string	否	是	账簿code    示例：dxbook001
     * periodStart	string	否	否	起始期间（默认当前系统年月 ）格式为yyyy-MM    示例：2021-08
     * periodEnd	string	否	否	截止期间（默认当前系统年月）格式为yyyy-MM    示例：2021-08
     * billcodeMin	int	否	否	凭证号区间左端点    示例：10
     * billcodeMax	int	否	否	凭证号区间右端点    示例：10
     * @author songlx
     * @date: 2023/11/21
     */
    @PostMapping(value = "queryVouchers")
    public CommonResponse<Map<String, Object>> queryVouchers(@RequestBody Map<String, Object> params) {
        params.put("accbookCode", "CS001");
        params.put("voucherTypeCodeList", Arrays.asList("JZ"));
        params.put("periodStart", params.get("period"));
        params.put("periodEnd", params.get("period"));
        params.put("billcodeMin", params.get("billCode"));
        params.put("billcodeMax", params.get("billCode"));
        JSONObject pager = new JSONObject();
        pager.put("pageIndex", 1);
        pager.put("pageSize", 500);
        params.put("pager", pager);

        ApiDataResponse apiDataResponse = postForEntity(OpenApiURL.QUERY_VOUCHERS, params, ApiDataResponse.class);
        CommonResponse commonResponse = apiDataResponse.toCommonResponse();

        if (commonResponse.isSuccess()) {
            Map<String, Object> data = (Map<String, Object>) commonResponse.getData();
            List<Map<String, Object>> recordList = (List<Map<String, Object>>) data.get("recordList");
         /*   Map<String, Object> voucherData = null;
            for (Map<String, Object> map : recordList) {
                Map<String, Object> header = (Map<String, Object>) map.get("header");
                String id = header.get("id").toString();
                if (id.equals(voucherVO.getVoucherId())) {
                   *//* Map<String, String> accbook = (Map<String, String>) header.get("accbook");
                    voucherVO.setAccbookName(accbook.get("name"));
                    Map<String, String> vouchertype = (Map<String, String>) header.get("vouchertype");
                    voucherVO.setVouchertypeName(vouchertype.get("name"));
                    voucherVO.setVouchertypeName(vouchertype.get("voucherstr"));
                    voucherVO.setMaketime(header.get("maketime").toString());
                    List<Map<String, Object>> bodyList = (List<Map<String, Object>>) map.get("body");
                    LinkedList<Map<String, Object>> detail = new LinkedList<>();
                    detail.add(bodyList.get(0));
                    detail.add(bodyList.get(1));
                    voucherVO.setDetail(detail);*//*
                    voucherData = map;
                    break;
                }
            }*/
            //  commonResponse.setData(voucherVO);
            if(CollectionUtils.isNotEmpty(recordList)){
                commonResponse.setData(recordList.get(0));
            }
        }
        return commonResponse;
    }


    /**
     * @description: 凭证删除, 目前ys只支持单个删除
     * ids: ["E5919010-0035-4996-A492-EB53F73CE6BA"]
     * @param params
     * @return {@link CommonResponse< Map< String, Object>>}
     * @author songlx
     * @date: 2023/11/22
     */
    @PostMapping(value = "del")
    public CommonResponse del(@RequestBody Map<String, Object> params) {
        ApiDataResponse apiDataResponse = postForEntity(OpenApiURL.DEL_VOUCHER, params, ApiDataResponse.class);
        return apiDataResponse.toCommonResponse();
    }
}
