package com.ejianc.business.budget.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 项目预算清单明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_budget_project_detail_pro")
public class BudgetProjectDetailProEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="budget_id")
    private Long budgetId; // 预算主键
    @TableField(value="detail_index")
    private String detailIndex; // 序号
    @TableField(value="code")
    private String code; // 清单编号
    @TableField(value="parent_id")
    private Long parentId; // parent_id
    @TableField(value="name")
    private String name; // 清单名称
    @TableField(value="category_id")
    private Long categoryId; // 分类id
    @TableField(value="category_name")
    private String categoryName; // 分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="cost_type")
    private Integer costType; // 费用类型
    @TableField(value="cost_type_name")
    private String costTypeName; // 费用类型名称
    @TableField(value="spec")
    private String spec; // 特征/规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="num")
    private BigDecimal num; // 工程量
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 综合单价（含税）
    @TableField(value="price")
    private BigDecimal price; // 综合单价（无税）
    @TableField(value="rate")
    private BigDecimal rate; // 税率
    @TableField(value="labor_tax_mny_cost")
    private BigDecimal laborTaxMnyCost; // 人工费（含税）
    @TableField(value="labor_mny_cost")
    private BigDecimal laborMnyCost; // 人工费(无税)
    @TableField(value="material_tax_mny_cost")
    private BigDecimal materialTaxMnyCost; // 材料费（含税）
    @TableField(value="material_mny_cost")
    private BigDecimal materialMnyCost; // 材料费（无税）
    @TableField(value="mechanical_tax_mny_cost")
    private BigDecimal mechanicalTaxMnyCost; // 机械费(含税)
    @TableField(value="mechanical_mny_cost")
    private BigDecimal mechanicalMnyCost; // 机械费（无税）
    @TableField(value="indirection_tax_mny_cost")
    private BigDecimal indirectionTaxMnyCost; // 间接费用(含税)
    @TableField(value="indirection_mny_cost")
    private BigDecimal indirectionMnyCost; // 间接费用（无税）
    @TableField(value="major_tax_mny_cost")
    private BigDecimal majorTaxMnyCost; // 专业费（含税）
    @TableField(value="major_mny_cost")
    private BigDecimal majorMnyCost; // 专业费（无税）
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 合价(含税)
    @TableField(value="mny")
    private BigDecimal mny; // 合价(无税)
    @TableField(value="leaf_flag")
    private Integer leafFlag; // 是否末级
    @TableField(value="lock_num")
    private BigDecimal lockNum; // 占用数量
    @TableField(value="lock_mny")
    private BigDecimal lockMny; // 占用金额(无税)
    @TableField(value="lock_tax_mny")
    private BigDecimal lockTaxMny; // 占用金额(含税)
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_bid")
    private Long changeBid; // 变更子表主键


    @TableField(value="subject_id")
    private Long subjectId; // 成本科目id
    @TableField(value="subject_name")
    private String subjectName; // 成本科目
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;
    @TableField(exist = false)
    private String key;
    /**
     * 模糊匹配生成档案使用
     */
    @TableField(exist = false)
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    @TableField(exist = false)
    private String matchStatusDescription;

    @TableField(value = "body_memo")
    private String bodyMemo; // 备注

    public String getBodyMemo() {
        return bodyMemo;
    }

    public void setBodyMemo(String bodyMemo) {
        this.bodyMemo = bodyMemo;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }


    public Integer getCostType() {
        return costType;
    }

    public void setCostType(Integer costType) {
        this.costType = costType;
    }

    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    public BigDecimal getLaborTaxMnyCost() {
        return laborTaxMnyCost;
    }

    public void setLaborTaxMnyCost(BigDecimal laborTaxMnyCost) {
        this.laborTaxMnyCost = laborTaxMnyCost;
    }
    public BigDecimal getLaborMnyCost() {
        return laborMnyCost;
    }

    public void setLaborMnyCost(BigDecimal laborMnyCost) {
        this.laborMnyCost = laborMnyCost;
    }
    public BigDecimal getMaterialTaxMnyCost() {
        return materialTaxMnyCost;
    }

    public void setMaterialTaxMnyCost(BigDecimal materialTaxMnyCost) {
        this.materialTaxMnyCost = materialTaxMnyCost;
    }
    public BigDecimal getMaterialMnyCost() {
        return materialMnyCost;
    }

    public void setMaterialMnyCost(BigDecimal materialMnyCost) {
        this.materialMnyCost = materialMnyCost;
    }
    public BigDecimal getMechanicalTaxMnyCost() {
        return mechanicalTaxMnyCost;
    }

    public void setMechanicalTaxMnyCost(BigDecimal mechanicalTaxMnyCost) {
        this.mechanicalTaxMnyCost = mechanicalTaxMnyCost;
    }
    public BigDecimal getMechanicalMnyCost() {
        return mechanicalMnyCost;
    }

    public void setMechanicalMnyCost(BigDecimal mechanicalMnyCost) {
        this.mechanicalMnyCost = mechanicalMnyCost;
    }
    public BigDecimal getIndirectionTaxMnyCost() {
        return indirectionTaxMnyCost;
    }

    public void setIndirectionTaxMnyCost(BigDecimal indirectionTaxMnyCost) {
        this.indirectionTaxMnyCost = indirectionTaxMnyCost;
    }
    public BigDecimal getIndirectionMnyCost() {
        return indirectionMnyCost;
    }

    public void setIndirectionMnyCost(BigDecimal indirectionMnyCost) {
        this.indirectionMnyCost = indirectionMnyCost;
    }

    public BigDecimal getMajorTaxMnyCost() {
        return majorTaxMnyCost;
    }

    public void setMajorTaxMnyCost(BigDecimal majorTaxMnyCost) {
        this.majorTaxMnyCost = majorTaxMnyCost;
    }

    public BigDecimal getMajorMnyCost() {
        return majorMnyCost;
    }

    public void setMajorMnyCost(BigDecimal majorMnyCost) {
        this.majorMnyCost = majorMnyCost;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Integer getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Integer leafFlag) {
        this.leafFlag = leafFlag;
    }
    public BigDecimal getLockNum() {
        return lockNum;
    }

    public void setLockNum(BigDecimal lockNum) {
        this.lockNum = lockNum;
    }
    public BigDecimal getLockMny() {
        return lockMny;
    }

    public void setLockMny(BigDecimal lockMny) {
        this.lockMny = lockMny;
    }
    public BigDecimal getLockTaxMny() {
        return lockTaxMny;
    }

    public void setLockTaxMny(BigDecimal lockTaxMny) {
        this.lockTaxMny = lockTaxMny;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }
}
