package com.ejianc.business.budget.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目预算主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_budget_project_pro")
public class BudgetProjectProEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="budget_tax_mny")
    private BigDecimal budgetTaxMny; // 预算总金额（含税）
    @TableField(value="budget_mny")
    private BigDecimal budgetMny; // 预算总金额(无税)
    @TableField(value="indirection_tax_mny")
    private BigDecimal indirectionTaxMny; // 间接费(含税)
    @TableField(value="indirection_mny")
    private BigDecimal indirectionMny; // 间接费（无税）
    @TableField(value="labor_tax_mny")
    private BigDecimal laborTaxMny; // 人工费（含税）
    @TableField(value="labor_mny")
    private BigDecimal laborMny; // 人工费（无税）
    @TableField(value="material_tax_mny")
    private BigDecimal materialTaxMny; // 材料费（含税）
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 材料费（无税）
    @TableField(value="major_tax_mny")
    private BigDecimal majorTaxMny; // 专业费（含税）
    @TableField(value="major_mny")
    private BigDecimal majorMny; // 专业费（无税）
    @TableField(value="mechanical_tax_mny")
    private BigDecimal mechanicalTaxMny; // 机械费(含税 )
    @TableField(value="mechanical_mny")
    private BigDecimal mechanicalMny; // 机械费（无税）
    @TableField(value="sporadic_material_mny")
    private BigDecimal sporadicMaterialMny; // 零星材料费
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="cost_type_show")
    private String costTypeShow; // 备注
    
    @TableField(exist=false)
    @SubEntity(serviceName="budgetProjectDetailProService",pidName = "budgetId")//此处有pid="xxx"，默认值pid="pid"
    private List<BudgetProjectDetailProEntity> detailList = new ArrayList<>(); // 项目预算清单明细



    @TableField(value="estimate_type")
    private Integer estimateType; // 估算类型

    @TableField(value="theme")
    private String theme; // 名称
    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public Integer getEstimateType() {
        return estimateType;
    }

    public void setEstimateType(Integer estimateType) {
        this.estimateType = estimateType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public BigDecimal getSporadicMaterialMny() {
        return sporadicMaterialMny;
    }

    public void setSporadicMaterialMny(BigDecimal sporadicMaterialMny) {
        this.sporadicMaterialMny = sporadicMaterialMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getIndirectionTaxMny() {
        return indirectionTaxMny;
    }

    public void setIndirectionTaxMny(BigDecimal indirectionTaxMny) {
        this.indirectionTaxMny = indirectionTaxMny;
    }
    public BigDecimal getIndirectionMny() {
        return indirectionMny;
    }

    public void setIndirectionMny(BigDecimal indirectionMny) {
        this.indirectionMny = indirectionMny;
    }
    public BigDecimal getLaborTaxMny() {
        return laborTaxMny;
    }

    public void setLaborTaxMny(BigDecimal laborTaxMny) {
        this.laborTaxMny = laborTaxMny;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getMaterialTaxMny() {
        return materialTaxMny;
    }

    public void setMaterialTaxMny(BigDecimal materialTaxMny) {
        this.materialTaxMny = materialTaxMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getMajorTaxMny() {
        return majorTaxMny;
    }

    public void setMajorTaxMny(BigDecimal majorTaxMny) {
        this.majorTaxMny = majorTaxMny;
    }
    public BigDecimal getMajorMny() {
        return majorMny;
    }

    public void setMajorMny(BigDecimal majorMny) {
        this.majorMny = majorMny;
    }
    public BigDecimal getMechanicalTaxMny() {
        return mechanicalTaxMny;
    }

    public void setMechanicalTaxMny(BigDecimal mechanicalTaxMny) {
        this.mechanicalTaxMny = mechanicalTaxMny;
    }
    public BigDecimal getMechanicalMny() {
        return mechanicalMny;
    }

    public void setMechanicalMny(BigDecimal mechanicalMny) {
        this.mechanicalMny = mechanicalMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public List<BudgetProjectDetailProEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BudgetProjectDetailProEntity> detailList) {
        this.detailList = detailList;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCostTypeShow() {
        return costTypeShow;
    }

    public void setCostTypeShow(String costTypeShow) {
        this.costTypeShow = costTypeShow;
    }
}
