package com.ejianc.business.budget.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectChangeEntity;
import com.ejianc.business.budget.service.IBudgetProjectChangeService;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 项目预算变更单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("budgetProjectChange")
public class BudgetProjectChangeController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBudgetProjectChangeService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> saveOrUpdate(@RequestBody BudgetProjectChangeVO saveorUpdateVO) {
//    	BudgetProjectChangeEntity entity = BeanMapper.map(saveorUpdateVO, BudgetProjectChangeEntity.class);
//    	service.saveOrUpdate(entity, false);
//    	BudgetProjectChangeVO vo = BeanMapper.map(entity, BudgetProjectChangeVO.class);
//    	return CommonResponse.success("保存或修改单据成功！",vo);
        CommonResponse<BudgetProjectChangeVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> queryDetail(Long id) {
        BudgetProjectChangeVO changeVo = service.queryDetail(id);
        return CommonResponse.success(changeVo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeVO> vos) {
//        service.removeByIds(vos.stream().map(BudgetProjectChangeVO::getId).collect(Collectors.toList()),true);
//        return CommonResponse.success("删除成功！");
        service.deleteChange(vos);
        return CommonResponse.success("删除成功");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<BudgetProjectChangeEntity> page = service.queryPage(param,false);
        IPage<BudgetProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 变更新增
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectVO> queryDetailChange(@RequestParam Long id) {
        BudgetProjectVO vo=service.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BudgetProjectChangeVO>> queryChangeHistory(@RequestParam Long id) {
        List<BudgetProjectChangeVO> vo = service.queryChangeHistory(id);

        return CommonResponse.success(vo);
    }

}
