package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailChangeProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.service.IBudgetProjectChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.BudgetProjectChangeProVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目预算变更单主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectChangePro")
public class BudgetProjectChangeProController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PROJECT_BUDGET_PRO_CHANGE_CODE";//此处需要根据实际修改

    @Autowired
    private IBudgetProjectChangeProService service;
    @Autowired
    private IBudgetProjectProService budgetService;
    @Autowired
    private IBudgetProjectDetailChangeProService detailsService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICommonBusinessService budgetProjectChangePro;
    @Autowired
    private IMaterialApi materialApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> saveOrUpdate(@RequestBody BudgetProjectChangeProVO saveOrUpdateVO) {
        String operateType = null;
    	BudgetProjectChangeProEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetProjectChangeProEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                operateType = "add";
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<BudgetProjectDetailChangeProEntity> changeDetailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList) && operateType!=null && operateType.equals("add")){
            for (BudgetProjectDetailChangeProEntity changeProEntity : changeDetailList) {
                changeProEntity.setId(null);
            }
        }
        service.saveOrUpdate(entity, false);
        List<BudgetProjectDetailChangeProEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)){
            Map<String, MaterialVO> materialVOMap = new HashMap<>();
            Map<String, MaterialVO> archiveMap = new HashMap<>();
            //维护父子级关系
            Map<String,Long> idMap=new HashMap<>();
            for(BudgetProjectDetailChangeProEntity cdEntity:detailList){
                if (cdEntity.getMatchStatus() != null && cdEntity.getMatchStatus() != 1) {
                    MaterialVO materialVO = new MaterialVO();
                    materialVO.setCategoryName(cdEntity.getCategoryName());
                    materialVO.setName(cdEntity.getMaterialName());
                    materialVO.setSpec(cdEntity.getSpec());
                    materialVO.setUnitName(cdEntity.getUnit());
                    if (2 == cdEntity.getCostType()) {
                        materialVO.setType(1);
                    } else if (4 == cdEntity.getCostType()) {
                        materialVO.setType(2);
                    }
                    //这个地方拼接一个key 用于从返回的数据中取到 档案的相关信息
                    String key = cdEntity.getName() + cdEntity.getCostType() + cdEntity.getCategoryName() + cdEntity.getSpec() + cdEntity.getUnit();
                    cdEntity.setKey(key);
                    materialVOMap.put(key, materialVO);
                }
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            if (materialVOMap != null) {
                CommonResponse<Map<String, MaterialVO>> listCommonResponse = materialApi.batchInsertArchive(materialVOMap);
                logger.info("插入" + JSONObject.toJSONString(materialVOMap));
                if (listCommonResponse.isSuccess()) {
                    Map<String, MaterialVO> data = listCommonResponse.getData();
                    if (data != null) {
                        archiveMap = data;
                    }
                }
            }
            for(BudgetProjectDetailChangeProEntity cdEntity:detailList){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                if (archiveMap != null) {
                    MaterialVO materialVO = archiveMap.get(cdEntity.getKey());
                    if (materialVO != null) {
                        cdEntity.setCategoryId(materialVO.getCategoryId());
                        cdEntity.setMaterialId(materialVO.getId());
                        cdEntity.setCategoryId(materialVO.getCategoryId());
                        cdEntity.setCode(materialVO.getCode());
                        cdEntity.setMatchStatus(1);
                        cdEntity.setMatchStatusDescription("已匹配");
                    }
                }
                if (cdEntity.getBudgetDetailId()==null){
                    cdEntity.setSubjectId(cdEntity.getId());
                }else {
                    cdEntity.setSubjectId(cdEntity.getBudgetDetailId());
                }
                String subjectName=cdEntity.getName();
                if (cdEntity.getMaterialId()!=null){
                    if (StringUtils.isNotEmpty(cdEntity.getSpec())){
                        subjectName= subjectName+" "+"["+cdEntity.getSpec()+"]";
                    }
                }
                cdEntity.setSubjectCode(cdEntity.getCode());
                cdEntity.setSubjectName(subjectName);
                if (cdEntity.getCostType()!=null){
                    cdEntity.setCostTypeName(CostTypeEnum.getEnumByType(cdEntity.getCostType()).getName());
                }
            }
            entity.setDetailList(detailList);
            detailsService.saveOrUpdateBatch(detailList, detailList.size(),false);
        }
        //回写主表 变更信息
        LambdaUpdateWrapper<BudgetProjectProEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BudgetProjectProEntity::getChangeId, entity.getId());//变更主键
        updateWrapper.set(BudgetProjectProEntity::getChangeStatus, 2);//状态：变更中
        updateWrapper.set(BudgetProjectProEntity::getChangeCode, entity.getBillCode());//变更编码
        updateWrapper.set(BudgetProjectProEntity::getChangeVersion, entity.getVersion());//变更编码
        updateWrapper.eq(BudgetProjectProEntity::getId, entity.getBudgetId());
        budgetService.update(updateWrapper);
        BudgetProjectChangeProVO vo = service.queryDetail(entity.getId());
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> queryDetail(Long id) {
        BudgetProjectChangeProVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeProVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BudgetProjectChangeProVO vo : vos) {
                BudgetProjectChangeProEntity budgetProjectChangeProEntity = service.selectById(vo.getId());
                LambdaUpdateWrapper<BudgetProjectProEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(BudgetProjectProEntity::getId, budgetProjectChangeProEntity.getBudgetId());
                if (budgetProjectChangeProEntity.getChangeStatus()==1){
                    updateWrapper.set(BudgetProjectProEntity::getChangeStatus,1);
                }else {
                    updateWrapper.set(BudgetProjectProEntity::getChangeStatus,3);
                }
                budgetService.update(updateWrapper);
            }
        }
        service.removeByIds(vos.stream().map(BudgetProjectChangeProVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeProVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<BudgetProjectChangeProEntity> page = service.queryPage(param,false);
        IPage<BudgetProjectChangeProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeProVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetProjectChangeProEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetProjectChangePro-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBudgetProjectChangeProData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeProVO>> refBudgetProjectChangeProData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetProjectChangeProEntity> page = service.queryPage(param,false);
        IPage<BudgetProjectChangeProVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeProVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 变更新增
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeProVO> queryDetailChange(@RequestParam Long id) {
        BudgetProjectChangeProVO vo=service.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    @RequestMapping(value = "/checkQuote", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> checkQuote(@RequestBody List<Long> ids) {
        if(CollectionUtils.isNotEmpty(ids)){
            for (Long billId : ids) {
                CommonResponse<String>  res = billTypeApi.checkQuote("BT202210000001",billId);
                if(res.isSuccess()) {//单据未被下游单据引用
                    return CommonResponse.success();
                }else{
                    return CommonResponse.error(res.getMsg());
                }
            }
        }
        return CommonResponse.success();
    }

}
