package com.ejianc.business.budget.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailHistoryEntity;
import com.ejianc.business.budget.service.IBudgetProjectDetailHistoryService;
import com.ejianc.business.budget.vo.BudgetProjectDetailHistoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目预算记录清单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("budgetProjectDetailHistory")
public class BudgetProjectDetailHistoryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBudgetProjectDetailHistoryService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectDetailHistoryVO> saveOrUpdate(@RequestBody BudgetProjectDetailHistoryVO saveorUpdateVO) {
    	BudgetProjectDetailHistoryEntity entity = BeanMapper.map(saveorUpdateVO, BudgetProjectDetailHistoryEntity.class);
    	service.saveOrUpdate(entity, false);
    	BudgetProjectDetailHistoryVO vo = BeanMapper.map(entity, BudgetProjectDetailHistoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectDetailHistoryVO> queryDetail(Long id) {
    	BudgetProjectDetailHistoryEntity entity = service.selectById(id);
    	BudgetProjectDetailHistoryVO vo = BeanMapper.map(entity, BudgetProjectDetailHistoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectDetailHistoryVO> vos) {
        service.removeByIds(vos.stream().map(BudgetProjectDetailHistoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailHistoryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<BudgetProjectDetailHistoryEntity> page = service.queryPage(param,false);
        IPage<BudgetProjectDetailHistoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectDetailHistoryVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
