package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.mapper.BudgetProjectChangeProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("budgetProjectChangePro")
public class BudgetProjectChangeProBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private BudgetProjectChangeProMapper changeMapper;
    @Autowired
    private IBudgetProjectProService budgetProjectProService;
    @Autowired
    private BudgetProjectProMapper budgetMapper;
    @Autowired
    private IBudgetProjectHistoryProService historyProService;
    @Autowired
    private IBudgetProjectDetailProService budgetProjectDetailProService;
    @Autowired
    private IBudgetProjectChangeProService changeProService;
    @Autowired
    private IBudgetProjectDetailHistoryProService budgetProjectDetailHistoryProService;
    @Autowired
    private IBudgetProjectProService budgetProService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //变更表
        Date effectiveDate = new Date();
        BudgetProjectChangeProEntity changeEntity = changeProService.selectById(billId);
        LambdaUpdateWrapper<BudgetProjectChangeProEntity> projectChangeProEntityLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
        projectChangeProEntityLambdaUpdateWrapper.eq(BudgetProjectChangeProEntity::getId, billId);
        projectChangeProEntityLambdaUpdateWrapper.set(BudgetProjectChangeProEntity::getEffectiveDate, effectiveDate);
        changeProService.update(projectChangeProEntityLambdaUpdateWrapper);

        //项目预算主表
        BudgetProjectProEntity budgetEntity = budgetProjectProService.selectById(changeEntity.getBudgetId());
        BudgetProjectHistoryProEntity historyEntity = BeanMapper.map(budgetEntity, BudgetProjectHistoryProEntity.class);
        historyEntity.setBudgetId(changeEntity.getBudgetId());//原项目预算主键
        historyEntity.setId(null);
        historyEntity.setCreateUserCode(null);
        historyEntity.setCreateTime(changeEntity.getCreateTime());
        historyEntity.setVersion(null);
        historyEntity.setUpdateTime(null);
        historyEntity.setUpdateUserCode(null);
        historyEntity.setChangeCode(changeEntity.getBillCode());
        historyEntity.setChangeReason(changeEntity.getChangeReason());
        historyEntity.setEffectiveDate(effectiveDate);
        List<BudgetProjectDetailHistoryProEntity> historyDetailList = historyEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(historyDetailList)) {
            for (BudgetProjectDetailHistoryProEntity historyProEntity : historyDetailList) {
                historyProEntity.setBudgetId(budgetEntity.getId());//原预算主键
                historyProEntity.setBudgetDetailId(historyProEntity.getId());
                historyProEntity.setId(null);
            }
        }
        //同步原合同到记录表
        historyProService.saveOrUpdate(historyEntity, false);
        //这一步是维护子表的夫级和子级的关系 因为历史的子表是新生成 id改变

        List<BudgetProjectDetailHistoryProEntity> historyProDetailList = historyEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(historyProDetailList)) {
            Map<Long, BudgetProjectDetailHistoryProEntity> historyDetailMap = historyProDetailList.stream().collect(Collectors.toMap(k -> k.getBudgetDetailId(), (k) -> k));
            for (BudgetProjectDetailHistoryProEntity historyProEntity : historyProDetailList) {
                if (historyProEntity.getParentId() != null && historyDetailMap.get(historyProEntity.getParentId()) != null) {
                    historyProEntity.setParentId(historyDetailMap.get(historyProEntity.getParentId()).getId());
                }
            }
            budgetProjectDetailHistoryProService.saveOrUpdateBatch(historyProDetailList, historyProDetailList.size());
        }
        //回写项目预算主表 会写标体金额字段
        LambdaUpdateWrapper<BudgetProjectProEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BudgetProjectProEntity::getId, changeEntity.getBudgetId());
        updateWrapper.set(BudgetProjectProEntity::getBudgetTaxMny, changeEntity.getBudgetTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getBudgetMny, changeEntity.getBudgetMny());
        updateWrapper.set(BudgetProjectProEntity::getIndirectionTaxMny, changeEntity.getIndirectionTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getIndirectionMny, changeEntity.getIndirectionMny());
        updateWrapper.set(BudgetProjectProEntity::getLaborTaxMny, changeEntity.getLaborTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getLaborMny, changeEntity.getLaborMny());
        updateWrapper.set(BudgetProjectProEntity::getMajorTaxMny, changeEntity.getMajorTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getMajorMny, changeEntity.getMajorMny());
        updateWrapper.set(BudgetProjectProEntity::getMaterialTaxMny, changeEntity.getMaterialTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getMaterialMny, changeEntity.getMaterialMny());
        updateWrapper.set(BudgetProjectProEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(BudgetProjectProEntity::getChangeStatus, 3);
        updateWrapper.set(BudgetProjectProEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(BudgetProjectProEntity::getChangeReason, changeEntity.getChangeReason());
        updateWrapper.set(BudgetProjectProEntity::getChangeVersion, changeEntity.getVersion());

        updateWrapper.set(BudgetProjectProEntity::getMechanicalTaxMny, changeEntity.getMechanicalTaxMny());
        updateWrapper.set(BudgetProjectProEntity::getMechanicalMny, changeEntity.getMechanicalMny());
        updateWrapper.set(BudgetProjectProEntity::getSporadicMaterialMny, changeEntity.getSporadicMaterialMny());

        updateWrapper.set(BudgetProjectProEntity::getTheme, changeEntity.getTheme());
        budgetProjectProService.update(updateWrapper);
        //更新子表
        List<BudgetProjectDetailChangeProEntity> changeDetailList = changeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            List<BudgetProjectDetailProEntity> addOrUpdateList = new ArrayList<>();
            List<Long> delList = new ArrayList<>();
            //需要判断是走更新还是新增
            List<BudgetProjectDetailProEntity> detailList = budgetEntity.getDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                Map<Long, BudgetProjectDetailProEntity> detailMap = detailList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                Map<Long, BudgetProjectDetailChangeProEntity> changeDetailMap = changeDetailList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                for (BudgetProjectDetailChangeProEntity detailChangeProEntity : changeDetailList) {
                    if (detailMap.containsKey(detailChangeProEntity.getBudgetDetailId())) {
                        //修改
                        BudgetProjectDetailProEntity detailProEntity = detailMap.get(detailChangeProEntity.getBudgetDetailId());
                        if (detailProEntity != null) {
                            BudgetProjectDetailProEntity entity = BeanMapper.map(detailChangeProEntity, BudgetProjectDetailProEntity.class);
                            entity.setChangeId(changeEntity.getId());
                            entity.setChangeBid(detailChangeProEntity.getId());
                            entity.setId(detailProEntity.getId());
                            entity.setParentId(detailProEntity.getParentId());
                            entity.setVersion(detailProEntity.getVersion());
                            addOrUpdateList.add(entity);
                            detailMap.remove(detailChangeProEntity.getBudgetDetailId());
                        }
                    } else {
                        //新增
                        BudgetProjectDetailProEntity entity = BeanMapper.map(detailChangeProEntity, BudgetProjectDetailProEntity.class);
                        if (entity.getParentId() != null && changeDetailMap.get(entity.getParentId()) != null && changeDetailMap.get(entity.getParentId()).getBudgetDetailId() != null) {
                            entity.setParentId(changeDetailMap.get(entity.getParentId()).getBudgetDetailId());
                        }
                        entity.setChangeId(changeEntity.getId());
                        entity.setChangeBid(detailChangeProEntity.getId());
                        entity.setVersion(0);
                        entity.setBudgetId(budgetEntity.getId());
                        addOrUpdateList.add(entity);
                    }
                }
                if (!detailMap.isEmpty()) {
                    delList.addAll(detailMap.keySet());
                }
                //删除
                if (CollectionUtils.isNotEmpty(delList)) {
                    budgetProjectDetailProService.removeByIds(delList, true);
                }
                //修改or新增
                if (CollectionUtils.isNotEmpty(addOrUpdateList)) {
                    budgetProjectDetailProService.saveOrUpdateBatch(addOrUpdateList, addOrUpdateList.size());
                }
            } else {
                //原清单为空全部新增 变更子表同步->原清单
                List<BudgetProjectDetailProEntity> detailProEntityList = BeanMapper.mapList(changeDetailList, BudgetProjectDetailProEntity.class);
                for (BudgetProjectDetailProEntity budgetProjectDetailProEntity : detailProEntityList) {
                    budgetProjectDetailProEntity.setChangeId(changeEntity.getId());
                    budgetProjectDetailProEntity.setChangeBid(changeEntity.getId());
                    budgetProjectDetailProEntity.setBudgetId(budgetEntity.getId());
                    budgetProjectDetailProEntity.setVersion(0);
                }
                budgetProjectDetailProService.saveOrUpdateBatch(detailProEntityList);
            }

        } else {
            //变更的子表为空删除主表的子表
            List<BudgetProjectDetailProEntity> detailList = budgetEntity.getDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                budgetProjectDetailProService.removeByIds(detailList.stream().map(BudgetProjectDetailProEntity::getId).collect(Collectors.toList()), false);
            }
        }
        //在这个推送成本设置
        Long budgetId = budgetEntity.getId();
        budgetProService.pushCostSetting(budgetId);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
