package com.ejianc.business.earlier.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.earlier.bean.EarlierProgressDetailEntity;
/**
 * 前期手续一览
 * 
 * @author generator
 * 
 */
 @TableName("ejc_invest_earlier_progress")
public class EarlierProgressEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="description")
    private String description; // 描述
    @TableField(value="finish_state")
    private String finishState; // 是否完成(0:未完成-1:完成)
    @TableField(value="project_id")
    private Long projectId; // 预立项项目id
    @TableField(value="project_name")
    private String projectName; // 预立项项目名称
    @TableField(value="project_code")
    private String projectCode; // 预立项项目编号
    @TableField(value="plan_begin_date")
    private Date planBeginDate; // 计划开始日期
    @TableField(value="plan_finish_date")
    private Date planFinishDate; // 计划结束日期
    @TableField(value="project_cycle_num")
    private Integer projectCycleNum; // 项目周期
    @TableField(value="engineering_type_name")
    private String engineeringTypeName; // 工程类型名称
    @TableField(value="project_set_department_name")
    private String projectSetDepartmentName; // 立项部门名称
    @TableField(value="project_management_name")
    private String projectManagementName; // 项目负责人名称
    @TableField(value="project_overview")
    private String projectOverview; // 工程概况
    @TableField(value="total_investment_scale")
    private BigDecimal totalInvestmentScale; // 总投资规模
    @TableField(value="stage")
    private String stage; // 阶段(0:汇总1:报审2:调整报审)
    @TableField(value="progress")
    private String progress; // 进展(0:内部进行中1:外部进行中2:完成)
    @TableField(value="actual_finish_date")
    private Date actualFinishDate; // 最新跟踪日期
    @TableField(value="work_list_name")
    private String workListName; // 工作清单手续项
    
    @TableField(exist=false)
    @SubEntity(serviceName="earlierProgressDetailService")
    private List<EarlierProgressDetailEntity> earlierProgressDetailList = new ArrayList<>(); // 项目前期手续


    public Date getPlanBeginDate() {
        return planBeginDate;
    }

    public void setPlanBeginDate(Date planBeginDate) {
        this.planBeginDate = planBeginDate;
    }

    public Date getPlanFinishDate() {
        return planFinishDate;
    }

    public void setPlanFinishDate(Date planFinishDate) {
        this.planFinishDate = planFinishDate;
    }

    public Integer getProjectCycleNum() {
        return projectCycleNum;
    }

    public void setProjectCycleNum(Integer projectCycleNum) {
        this.projectCycleNum = projectCycleNum;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getProjectSetDepartmentName() {
        return projectSetDepartmentName;
    }

    public void setProjectSetDepartmentName(String projectSetDepartmentName) {
        this.projectSetDepartmentName = projectSetDepartmentName;
    }

    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }

    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }

    public BigDecimal getTotalInvestmentScale() {
        return totalInvestmentScale;
    }

    public void setTotalInvestmentScale(BigDecimal totalInvestmentScale) {
        this.totalInvestmentScale = totalInvestmentScale;
    }

    public String getStage() {
        return stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public String getProgress() {
        return progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public Date getActualFinishDate() {
        return actualFinishDate;
    }

    public void setActualFinishDate(Date actualFinishDate) {
        this.actualFinishDate = actualFinishDate;
    }

    public String getWorkListName() {
        return workListName;
    }

    public void setWorkListName(String workListName) {
        this.workListName = workListName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getFinishState() {
        return finishState;
    }

    public void setFinishState(String finishState) {
        this.finishState = finishState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    

    public List<EarlierProgressDetailEntity> getEarlierProgressDetailList() {
        return earlierProgressDetailList;
    }

    public void setEarlierProgressDetailList(List<EarlierProgressDetailEntity> earlierProgressDetailList) {
        this.earlierProgressDetailList = earlierProgressDetailList;
    }
}
