package com.ejianc.business.earlier.service.impl;


import com.ejianc.business.earlier.bean.EarlierProgressDetailEntity;
import com.ejianc.business.earlier.bean.EarlierProgressEntity;
import com.ejianc.business.earlier.bean.EarlierProgressTrackEntity;
import com.ejianc.business.earlier.service.IEarlierProgressDetailService;
import com.ejianc.business.earlier.service.IEarlierProgressService;
import com.ejianc.business.earlier.service.IEarlierProgressTrackService;
import com.ejianc.business.invest.bean.WorkProgressEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("earlierProgressTrack") 
public class EarlierProgressTrackBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IEarlierProgressTrackService service;
	@Autowired
	private IEarlierProgressDetailService detailService;
	@Autowired
	private IEarlierProgressService progressService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		EarlierProgressTrackEntity workProgressTrackEntity = service.selectById(billId);

		//更新明细表中的数据
		EarlierProgressDetailEntity workProgressDetailEntity = detailService.selectById(workProgressTrackEntity.getWorkProgressDetailId());
		workProgressDetailEntity.setStage(workProgressTrackEntity.getStage());//阶段
		workProgressDetailEntity.setProgress(workProgressTrackEntity.getProgress());//进展
		workProgressDetailEntity.setLastTrackDate(workProgressTrackEntity.getActualFinishDate());//最新跟踪日期
		workProgressDetailEntity.setDescription(workProgressTrackEntity.getDescription());//进展描述
		if ("2".equals(workProgressTrackEntity.getProgress())){//完成
			workProgressDetailEntity.setActualFinishDate(workProgressTrackEntity.getActualFinishDate());//实际结束日期

			//修改进展主表完成状态
			EarlierProgressEntity workProgressEntity = progressService.selectById(workProgressTrackEntity.getWorkProgressId());
			List<EarlierProgressDetailEntity> collect = workProgressEntity.getEarlierProgressDetailList().stream().filter(s -> (!"2".equals(s.getProgress()))).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(collect)){
				if (collect.size() == 1 && workProgressDetailEntity.getId().equals(collect.get(0).getId())){
					workProgressEntity.setFinishState("1");
					progressService.saveOrUpdate(workProgressEntity);
				}
			}
		}

		//修改进展主表完成状态
		EarlierProgressEntity workProgressEntity = progressService.selectById(workProgressTrackEntity.getWorkProgressId());
		workProgressEntity.setStage(workProgressTrackEntity.getStage());
		workProgressEntity.setProgress(workProgressTrackEntity.getProgress());
		workProgressEntity.setActualFinishDate(workProgressTrackEntity.getActualFinishDate());
		workProgressEntity.setWorkListName(workProgressTrackEntity.getWorkListName());

		progressService.saveOrUpdate(workProgressEntity);
		detailService.saveOrUpdate(workProgressDetailEntity);


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
