package com.ejianc.business.budget.service.impl;

import com.ejianc.business.budget.bean.*;
import com.ejianc.business.budget.mapper.BudgetProjectChangeMapper;
import com.ejianc.business.budget.mapper.BudgetProjectMapper;
import com.ejianc.business.budget.service.*;
import com.ejianc.business.budget.vo.cons.BillCons;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IBudgetProjectChangeService changeService;
    @Autowired
    private IBudgetProjectService contractService;
    @Autowired
    private IBudgetProjectHistoryService historyService;
    @Autowired
    private IBudgetProjectDetailService contractDetailService;
    @Autowired
    private IBudgetProjectDetailHistoryService historyDetailService;
    @Autowired
    private IBudgetProjectDetailChangeService changeDetailService;
    @Autowired
    private BudgetProjectChangeMapper changeMapper;
    @Autowired
    private BudgetProjectMapper budgetMapper;
    @Autowired
    private IAttachmentApi attachmentApi;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //变更表
        BudgetProjectChangeEntity entity = changeMapper.selectById(billId);

        //合同主表
        BudgetProjectEntity contractEntity = budgetMapper.selectById(entity.getBudgetId());

        //同步原合同到记录表
        BudgetProjectHistoryEntity historyEntity = BeanMapper.map(contractEntity, BudgetProjectHistoryEntity.class);
        historyEntity.setBudgetId(entity.getBudgetId());//原合同主键
        historyEntity.setId(null);
        historyService.saveOrUpdate(historyEntity, false);

        //同步原清单到记录表
        QueryParam deparm = new QueryParam();
        deparm.getParams().put("budgetId", new Parameter(QueryParam.EQ, contractEntity.getId()));
        deparm.getParams().put("changeType", new Parameter(QueryParam.NE, 5));
        deparm.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<BudgetProjectDetailEntity> checkList = contractDetailService.queryList(deparm, false);
        if (null != checkList && checkList.size() > 0) {
            List<BudgetProjectDetailHistoryEntity> historyDetails = BeanMapper.mapList(checkList, BudgetProjectDetailHistoryEntity.class);
            for (BudgetProjectDetailHistoryEntity hde : historyDetails) {
                hde.setBudgetHistoryId(historyEntity.getId());//记录表主键
                hde.setBudgetId(entity.getBudgetId());//原合同主键
                hde.setBudgetDetailId(hde.getId());//原合同子表主键
                hde.setId(null);
            }
            historyDetailService.saveOrUpdateBatch(historyDetails, historyDetails.size(), false);
        }


        //回写合同主表

        contractEntity.setBeforeChangeBudgetMny(contractEntity.getBudgetMny());//变更后金额变为变更前金额
        contractEntity.setBudgetMny(contractEntity.getChangingBudgetMny());//变更中金额变为变更后金额
        contractEntity.setChangingBudgetMny(null);//变更中金额清空
        contractEntity.setBeforeChangeLaborMny(contractEntity.getLaborMny());//变更后金额变为变更前金额
        contractEntity.setLaborMny(contractEntity.getChangingLaborMny());//变更中金额变为变更后金额
        contractEntity.setChangingLaborMny(null);//变更中金额清空
        contractEntity.setBeforeChangeMaterialMny(contractEntity.getMaterialMny());//变更后金额变为变更前金额
        contractEntity.setMaterialMny(contractEntity.getChangingMaterialMny());//变更中金额变为变更后金额
        contractEntity.setChangingMaterialMny(null);//变更中金额清空
        contractEntity.setBeforeChangeMechanicalMny(contractEntity.getMechanicalMny());//变更后金额变为变更前金额
        contractEntity.setMechanicalMny(contractEntity.getChangingMechanicalMny());//变更中金额变为变更后金额
        contractEntity.setChangingMechanicalMny(null);//变更中金额清空
        contractEntity.setBeforeChangeOtherMny(contractEntity.getOtherMny());//变更后金额变为变更前金额
        contractEntity.setOtherMny(contractEntity.getChangingOtherMny());//变更中金额变为变更后金额
        contractEntity.setChangingOtherMny(null);//变更中金额清空

        contractEntity.setChangeStatus(3);//状态改为已变更
        contractEntity.setChangeCode(contractEntity.getChangeCode());
        contractEntity.setChangeId(contractEntity.getChangeId());
        contractEntity.setBillState(contractEntity.getBillState());

        contractEntity.setProjectId(entity.getProjectId());
        contractEntity.setProjectName(entity.getProjectName());

        contractEntity.setBillCode(entity.getBillCode());
        contractEntity.setChangeReason(entity.getChangeReason());
        contractEntity.setChangeVersion(entity.getChangeVersion());
        //contractService.saveOrUpdate(contractEntity);

        // 同步科目
        Map<Long, BudgetProjectDetailEntity> checkMap = new HashMap<>();
        for (BudgetProjectDetailEntity bd : checkList) {
            checkMap.put(bd.getId(), bd);
        }
        //回写原合同清单表
        contractDetailService.deleteByBudgetId(entity.getBudgetId());
        QueryParam parm = new QueryParam();
        parm.getParams().put("budgetChangeId", new Parameter(QueryParam.EQ, entity.getId()));
        List<BudgetProjectDetailChangeEntity> changeDetailList = changeDetailService.queryList(parm, false);
        int leaf = 0;//全部末级数量
        int subject = 0;// 已关联数量
        if (null != changeDetailList && changeDetailList.size() > 0) {
            List<BudgetProjectDetailEntity> detailList = new ArrayList<>();
            for (BudgetProjectDetailChangeEntity cde : changeDetailList) {
                Long detailId = cde.getBudgetDetailId();
                // 同步科目
                if (cde.getLeafFlag()) {
                    if (checkMap.get(detailId) != null) {
                        cde.setSubjectId(checkMap.get(detailId).getSubjectId());
                        cde.setSubjectName(checkMap.get(detailId).getSubjectName());
                        if ((null == cde.getChangeType() || cde.getChangeType() != 5) && checkMap.get(detailId).getSubjectId() != null) {
                            subject++;
                        }
                    } else {
                        cde.setSubjectId(null);
                        cde.setSubjectName(null);
                    }
                    if (null == cde.getChangeType() || cde.getChangeType() != 5) {
                        leaf++;
                    }
                }
                BudgetProjectDetailEntity cdetail = BeanMapper.map(cde, BudgetProjectDetailEntity.class);
                cdetail.setId(null);
                cdetail.setChangeBid(cde.getId());
                //变更类型如果是中止，不能改类型
                if (null == cdetail.getChangeType() || cdetail.getChangeType() != 5) {
                    cdetail.setChangeType(0);
                }

                detailList.add(cdetail);
            }
            contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
            //维护父子关系
            Map<Long, Long> parentMap = new HashMap<>();
            for (BudgetProjectDetailEntity cde : detailList) {
                parentMap.put(cde.getChangeBid(), cde.getId());
            }
            for (BudgetProjectDetailEntity cde : detailList) {
                if (cde.getParentId() != null && cde.getParentId() > 0) {
                    cde.setParentId(parentMap.get(cde.getParentId()));
                }
            }
            contractDetailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
        if (leaf == subject) {
            contractEntity.setLinkedFlag(1);
            contractEntity.setUnassociate(0);
        } else {
            contractEntity.setLinkedFlag(0);
            contractEntity.setUnassociate(leaf - subject);//全部末级数量减去已关联
        }
        contractService.saveOrUpdate(contractEntity);

        entity.setUsedTime(new Date());
        //entity.setBeforeContractName(contractEntity.getContractName());
        changeService.saveOrUpdate(entity, false);
        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(billId), BillCons.BUDGET_CHANGE_BILL_TYPE, BillCons.BUDGET_CHANGE_SOURCE_TYPE,
                String.valueOf(contractEntity.getId()), BillCons.BUDGET_BILL_TYPE, BillCons.BUDGET_SOURCE_TYPE);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
