package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.bean.BudgetProjectChangeEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.budget.bean.BudgetProjectDetailEntity;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.mapper.BudgetProjectChangeMapper;
import com.ejianc.business.budget.mapper.BudgetProjectMapper;
import com.ejianc.business.budget.service.IBudgetProjectChangeService;
import com.ejianc.business.budget.service.IBudgetProjectDetailChangeService;
import com.ejianc.business.budget.service.IBudgetProjectDetailService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.vo.BudgetProjectChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailVO;
import com.ejianc.business.budget.vo.BudgetProjectVO;
import com.ejianc.business.budget.vo.comparator.BudgetDetailComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 项目预算变更单
 *
 * @author generator
 */
@Service("budgetProjectChangeService")
public class BudgetProjectChangeServiceImpl extends BaseServiceImpl<BudgetProjectChangeMapper, BudgetProjectChangeEntity> implements IBudgetProjectChangeService {
    private static final String BILL_CODE_ROLE = "BUDGET_PRO_CHANGE_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetProjectDetailChangeService changeDetailService;
    @Autowired
    private IBudgetProjectService budgetService;
    @Autowired
    private BudgetProjectMapper budgetMapper;
    @Autowired
    private IBudgetProjectDetailService detailsService;
    @Autowired
    private BudgetProjectChangeMapper changeMapper;

    @Override
    public CommonResponse<BudgetProjectChangeVO> saveOrUpdate(BudgetProjectChangeVO changeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetProjectChangeEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0) { //修改
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = BeanMapper.map(changeVo, BudgetProjectChangeEntity.class);
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(1);//第一次变更
            } else {
                changeVo.setChangeVersion(changeVo.getChangeVersion() + 1);//版本号+1
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("合同存在变更中单据，不允许保存!");
            }
            //新增
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
                if (billCode.isSuccess()) {
                    changeVo.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(changeVo, BudgetProjectChangeEntity.class);

            operateType = "add";
        }

        super.saveOrUpdate(entity);

        List<BudgetProjectDetailChangeVO> detailsVos = changeVo.getCheckList();
        List<BudgetProjectDetailChangeEntity> saveOrUpldates = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();

        if (operateType.equals("add")) {
            for (BudgetProjectDetailChangeVO detailsVo : detailsVos) {
                BudgetProjectDetailChangeEntity detailslist = BeanMapper.map(detailsVo, BudgetProjectDetailChangeEntity.class);
                detailslist.setBudgetChangeId(entity.getId());
                detailslist.setBudgetId(entity.getBudgetId());
                detailslist.setBudgetDetailId(detailsVo.getId());
                detailslist.setId(null);
                detailslist.setBeforeChangeMny(detailsVo.getMny());
                detailslist.setBeforeChangePrice(detailsVo.getPrice());
                detailslist.setBeforeChangeNum(detailsVo.getNum());
                detailslist.setBeforeChangeLaborCost(detailsVo.getLaborCost());
                detailslist.setBeforeChangeMaterialCost(detailsVo.getMechanicalCost());
                detailslist.setBeforeChangeMechanicalCost(detailsVo.getMechanicalCost());
                detailslist.setBeforeChangeOtherCost(detailsVo.getOtherCost());
                saveOrUpldates.add(detailslist);
            }
        } else {
            for (BudgetProjectDetailChangeVO detailsVo : detailsVos) {
                if ("add".equals(detailsVo.getRowState())) {
                    BudgetProjectDetailChangeEntity detailslist = BeanMapper.map(detailsVo, BudgetProjectDetailChangeEntity.class);
                    detailslist.setBudgetChangeId(entity.getId());
                    detailslist.setBudgetId(entity.getBudgetId());
                    detailslist.setBudgetDetailId(detailsVo.getId());
                    detailslist.setId(null);
                    saveOrUpldates.add(detailslist);
                } else if ("edit".equals(detailsVo.getRowState())) {
                    BudgetProjectDetailChangeEntity detailslist = BeanMapper.map(detailsVo, BudgetProjectDetailChangeEntity.class);
                    saveOrUpldates.add(detailslist);
                } else if ("del".equals(detailsVo.getRowState())) {
                    deleteIds.add(detailsVo.getId());
                }
            }
        }

        if (saveOrUpldates.size() > 0) {
            changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (BudgetProjectDetailChangeEntity cdEntity : saveOrUpldates) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetProjectDetailChangeEntity cdEntity : saveOrUpldates) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            changeDetailService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            changeDetailService.removeByIds(deleteIds, false);
        }

        //回写主表
        LambdaUpdateWrapper<BudgetProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BudgetProjectEntity::getChangingBudgetMny, changeVo.getBudgetMny());//变更中
        updateWrapper.set(BudgetProjectEntity::getChangingLaborMny, changeVo.getLaborMny());//变更中
        updateWrapper.set(BudgetProjectEntity::getChangingMaterialMny, changeVo.getMaterialMny());//变更中
        updateWrapper.set(BudgetProjectEntity::getChangingMechanicalMny, changeVo.getMechanicalMny());//变更中
        updateWrapper.set(BudgetProjectEntity::getChangingOtherMny, changeVo.getOtherMny());//变更中
        updateWrapper.set(BudgetProjectEntity::getChangeId, entity.getId());//变更主键
        updateWrapper.set(BudgetProjectEntity::getChangeStatus, 2);//状态：变更中
        updateWrapper.set(BudgetProjectEntity::getChangeCode, entity.getBillCode());//变更编码
        updateWrapper.eq(BudgetProjectEntity::getId, entity.getBudgetId());

        budgetService.update(updateWrapper);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public BudgetProjectChangeVO queryDetail(Long id) {
        BudgetProjectChangeEntity entity = changeMapper.selectById(id);
        BudgetProjectChangeVO changeVo = BeanMapper.map(entity, BudgetProjectChangeVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("budget_change_id", new Parameter(QueryParam.EQ, changeVo.getId()));
        List<BudgetProjectDetailChangeEntity> deils = changeDetailService.queryList(param);
        List<BudgetProjectDetailChangeVO> checkList = BeanMapper.mapList(deils,BudgetProjectDetailChangeVO.class);
        if (checkList != null && checkList.size() > 0) {
            for (BudgetProjectDetailChangeVO cdEntity : checkList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            changeVo.setCheckList(TreeNodeBUtil.buildTree(checkList));
        }
        return changeVo;
    }

    @Override
    public void deleteChange(List<BudgetProjectChangeVO> vos) {
        for (BudgetProjectChangeVO vo : vos) {
            BudgetProjectChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<BudgetProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(BudgetProjectEntity::getChangingBudgetMny, BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingLaborMny, BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingMaterialMny, BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingMechanicalMny, BigDecimal.ZERO);
            updateWrapper.set(BudgetProjectEntity::getChangingOtherMny, BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(BudgetProjectEntity::getChangeStatus, 1);
            } else {
                updateWrapper.set(BudgetProjectEntity::getChangeStatus, 3);
            }
            updateWrapper.eq(BudgetProjectEntity::getId, changeEntity.getBudgetId());
            budgetService.update(updateWrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public BudgetProjectVO queryDetailChange(Long id) {
        BudgetProjectEntity entity = budgetMapper.selectById(id);
        if (entity != null) {
            BudgetProjectVO contractVo = BeanMapper.map(entity, BudgetProjectVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("budgetId", new Parameter(QueryParam.EQ, contractVo.getId()));
            queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<BudgetProjectDetailEntity> purchaseDetailss = detailsService.queryList(queryParam, false);
            if (purchaseDetailss != null && purchaseDetailss.size() > 0) {
                for (BudgetProjectDetailEntity cdEntity : purchaseDetailss) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List<BudgetProjectDetailVO> resultMapList = BeanMapper.mapList(purchaseDetailss, BudgetProjectDetailVO.class);
                //实现排序
                Collections.sort(resultMapList, new BudgetDetailComparatoeVo());
                contractVo.setCheckList(TreeNodeBUtil.buildTree(resultMapList));
            }
            contractVo.setBeforeChangeBudgetMny(entity.getBudgetMny());
            contractVo.setBeforeChangeLaborMny(entity.getLaborMny());
            contractVo.setBeforeChangeMaterialMny(entity.getMaterialMny());
            contractVo.setBeforeChangeMechanicalMny(entity.getMechanicalMny());
            contractVo.setBeforeChangeOtherMny(entity.getOtherMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            return contractVo;
        }
        return null;
    }

    @Override
    public List<BudgetProjectChangeVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<BudgetProjectChangeEntity> changeEntities = changeMapper.selectList(new QueryWrapper<BudgetProjectChangeEntity>()
                .eq("budget_id", id)
                .in("bill_state", billStatus).orderByDesc("used_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<BudgetProjectChangeVO> changeVos = BeanMapper.mapList(changeEntities, BudgetProjectChangeVO.class);
            for (BudgetProjectChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }
}
